/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.blueprint.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.mcbrawls.blueprint.anchor.Anchor;
import net.mcbrawls.blueprint.resource.BlueprintManager;
import net.mcbrawls.blueprint.structure.BlockStateProcessor;
import net.mcbrawls.blueprint.structure.Blueprint;
import net.mcbrawls.blueprint.structure.PlacedBlueprint;
import net.mcbrawls.blueprint.structure.ProgressProvider;
import net.mcbrawls.blueprint.structure.ProgressiveFuture;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lnet/mcbrawls/blueprint/structure/BlueprintBatch;", "", "<init>", "()V", "Lnet/minecraft/class_3218;", "world", "", "Lnet/mcbrawls/blueprint/structure/BlueprintBatch$Entry;", "entries", "Lnet/mcbrawls/blueprint/structure/ProgressiveFuture;", "Lnet/mcbrawls/blueprint/structure/BlueprintBatch$BatchResult;", "place", "(Lnet/minecraft/class_3218;Ljava/util/Set;)Lnet/mcbrawls/blueprint/structure/ProgressiveFuture;", "Entry", "BatchResult", "blueprint"})
@SourceDebugExtension(value={"SMAP\nBlueprintBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlueprintBatch.kt\nnet/mcbrawls/blueprint/structure/BlueprintBatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,59:1\n1285#2,2:60\n1299#2,4:62\n1#3:66\n126#4:67\n153#4,3:68\n*S KotlinDebug\n*F\n+ 1 BlueprintBatch.kt\nnet/mcbrawls/blueprint/structure/BlueprintBatch\n*L\n15#1:60,2\n15#1:62,4\n23#1:67\n23#1:68,3\n*E\n"})
public final class BlueprintBatch {
    @NotNull
    public static final BlueprintBatch INSTANCE = new BlueprintBatch();

    private BlueprintBatch() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProgressiveFuture<BatchResult> place(@NotNull class_3218 world, @NotNull Set<Entry> entries) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        AtomicReference<Float> progress = new AtomicReference<Float>(Float.valueOf(0.0f));
        Iterable $this$associateWith$iv = entries;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Blueprint blueprint;
            void it;
            Entry entry = (Entry)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            class_2960 id = it.getId();
            if (BlueprintManager.INSTANCE.get(id) == null) {
                throw new IllegalArgumentException("No blueprint found: " + id);
            }
            map.put(t, blueprint);
        }
        Map blueprints = result$iv;
        Iterable $i$f$associateWith22 = blueprints.values();
        int n = 0;
        for (Object t : $i$f$associateWith22) {
            void p0;
            Blueprint blueprint = (Blueprint)t;
            int n2 = n;
            boolean bl = false;
            int n3 = p0.getTotalBlocks();
            n = n2 + n3;
        }
        int totalBlocks = n;
        CompletableFuture<BatchResult> completableFuture = CompletableFuture.supplyAsync(() -> BlueprintBatch.place$lambda$4(blueprints, world, progress, totalBlocks));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        CompletableFuture<BatchResult> future = completableFuture;
        return new ProgressiveFuture<BatchResult>(future, new ProgressProvider(progress){
            final /* synthetic */ AtomicReference<Float> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Float getProgress() {
                return this.$tmp0.get();
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(0, this.$tmp0, AtomicReference.class, "get", "get()Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ProgressProvider ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    private static final void place$lambda$4$lambda$3$lambda$2$lambda$1(class_3218 $world, class_2338 $pos, Entry $entry, AtomicReference $progress, Ref.IntRef $i, int $totalBlocks, class_2338 offset, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        class_2680 state = (class_2680)pair.component1();
        class_2487 blockEntityNbt = (class_2487)pair.component2();
        Blueprint.Companion.placePosition($world, $pos, offset, state, blockEntityNbt, $entry.getProcessor());
        ++$i.element;
        $progress.set(Float.valueOf((float)$i.element / (float)$totalBlocks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final BatchResult place$lambda$4(Map $blueprints, class_3218 $world, AtomicReference $progress, int $totalBlocks) {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = $blueprints;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entry entry2 = (Entry)entry.getKey();
            Blueprint blueprint = (Blueprint)entry.getValue();
            class_2338 pos = entry2.getPos();
            class_3218 class_32182 = $world;
            synchronized (class_32182) {
                boolean bl2 = false;
                Ref.IntRef i = new Ref.IntRef();
                blueprint.forEach((arg_0, arg_1) -> BlueprintBatch.place$lambda$4$lambda$3$lambda$2$lambda$1($world, pos, entry2, $progress, i, $totalBlocks, arg_0, arg_1));
                Unit unit = Unit.INSTANCE;
            }
            collection.add(new PlacedBlueprint(blueprint, pos));
        }
        List placedBlueprints = (List)destination$iv$iv;
        return new BatchResult(CollectionsKt.toSet((Iterable)placedBlueprints));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnet/mcbrawls/blueprint/structure/BlueprintBatch$BatchResult;", "", "", "Lnet/mcbrawls/blueprint/structure/PlacedBlueprint;", "placedBlueprints", "<init>", "(Ljava/util/Set;)V", "", "id", "", "Lnet/mcbrawls/blueprint/anchor/Anchor;", "getAnchors", "(Ljava/lang/String;)Ljava/util/List;", "getUniqueAnchor", "(Ljava/lang/String;)Lnet/mcbrawls/blueprint/anchor/Anchor;", "Ljava/util/Set;", "getPlacedBlueprints", "()Ljava/util/Set;", "blueprint"})
    @SourceDebugExtension(value={"SMAP\nBlueprintBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlueprintBatch.kt\nnet/mcbrawls/blueprint/structure/BlueprintBatch$BatchResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1374#2:60\n1460#2,5:61\n1#3:66\n*S KotlinDebug\n*F\n+ 1 BlueprintBatch.kt\nnet/mcbrawls/blueprint/structure/BlueprintBatch$BatchResult\n*L\n51#1:60\n51#1:61,5\n*E\n"})
    public static final class BatchResult {
        @NotNull
        private final Set<PlacedBlueprint> placedBlueprints;

        public BatchResult(@NotNull Set<PlacedBlueprint> placedBlueprints) {
            Intrinsics.checkNotNullParameter(placedBlueprints, (String)"placedBlueprints");
            this.placedBlueprints = placedBlueprints;
        }

        @NotNull
        public final Set<PlacedBlueprint> getPlacedBlueprints() {
            return this.placedBlueprints;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Anchor> getAnchors(@NotNull String id) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$flatMap$iv = this.placedBlueprints;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PlacedBlueprint it = (PlacedBlueprint)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getAnchors(id);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final Anchor getUniqueAnchor(@NotNull String id) {
            Anchor anchor;
            block1: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                for (PlacedBlueprint it : (Iterable)this.placedBlueprints) {
                    boolean bl = false;
                    Anchor anchor2 = it.getUniqueAnchor(id);
                    if (anchor2 == null) continue;
                    anchor = anchor2;
                    break block1;
                }
                anchor = null;
            }
            return anchor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ0\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u000f\u00a8\u0006\""}, d2={"Lnet/mcbrawls/blueprint/structure/BlueprintBatch$Entry;", "", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2338;", "pos", "Lnet/mcbrawls/blueprint/structure/BlockStateProcessor;", "processor", "<init>", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2338;Lnet/mcbrawls/blueprint/structure/BlockStateProcessor;)V", "component1", "()Lnet/minecraft/class_2960;", "component2", "()Lnet/minecraft/class_2338;", "component3", "()Lnet/mcbrawls/blueprint/structure/BlockStateProcessor;", "copy", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2338;Lnet/mcbrawls/blueprint/structure/BlockStateProcessor;)Lnet/mcbrawls/blueprint/structure/BlueprintBatch$Entry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2960;", "getId", "Lnet/minecraft/class_2338;", "getPos", "Lnet/mcbrawls/blueprint/structure/BlockStateProcessor;", "getProcessor", "blueprint"})
    public static final class Entry {
        @NotNull
        private final class_2960 id;
        @NotNull
        private final class_2338 pos;
        @Nullable
        private final BlockStateProcessor processor;

        public Entry(@NotNull class_2960 id, @NotNull class_2338 pos, @Nullable BlockStateProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.id = id;
            this.pos = pos;
            this.processor = processor;
        }

        public /* synthetic */ Entry(class_2960 class_29602, class_2338 class_23382, BlockStateProcessor blockStateProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                blockStateProcessor = null;
            }
            this(class_29602, class_23382, blockStateProcessor);
        }

        @NotNull
        public final class_2960 getId() {
            return this.id;
        }

        @NotNull
        public final class_2338 getPos() {
            return this.pos;
        }

        @Nullable
        public final BlockStateProcessor getProcessor() {
            return this.processor;
        }

        @NotNull
        public final class_2960 component1() {
            return this.id;
        }

        @NotNull
        public final class_2338 component2() {
            return this.pos;
        }

        @Nullable
        public final BlockStateProcessor component3() {
            return this.processor;
        }

        @NotNull
        public final Entry copy(@NotNull class_2960 id, @NotNull class_2338 pos, @Nullable BlockStateProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Entry(id, pos, processor);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, class_2960 class_29602, class_2338 class_23382, BlockStateProcessor blockStateProcessor, int n, Object object) {
            if ((n & 1) != 0) {
                class_29602 = entry.id;
            }
            if ((n & 2) != 0) {
                class_23382 = entry.pos;
            }
            if ((n & 4) != 0) {
                blockStateProcessor = entry.processor;
            }
            return entry.copy(class_29602, class_23382, blockStateProcessor);
        }

        @NotNull
        public String toString() {
            return "Entry(id=" + this.id + ", pos=" + this.pos + ", processor=" + this.processor + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.pos.hashCode();
            result = result * 31 + (this.processor == null ? 0 : this.processor.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)entry.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)entry.pos)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.processor, (Object)entry.processor);
        }
    }
}

