/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.blueprint.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import net.mcbrawls.blueprint.BlueprintMod;
import net.mcbrawls.blueprint.anchor.Anchor;
import net.mcbrawls.blueprint.region.CompoundRegion;
import net.mcbrawls.blueprint.region.EmptyRegion;
import net.mcbrawls.blueprint.region.PointRegion;
import net.mcbrawls.blueprint.region.Region;
import net.mcbrawls.blueprint.region.serialization.SerializableRegion;
import net.mcbrawls.blueprint.structure.Blueprint;
import net.mcbrawls.blueprint.structure.PlacedBlueprint;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\"\n\u0002\b\u0006\b\u0086\b\u0018\u0000 H2\u00020\u0001:\u0001HB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0011\"\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b \u0010!J\u001b\u0010%\u001a\u00020$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010'\u001a\u00020$2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b+\u0010,J$\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b-\u0010.J\u001a\u00101\u001a\u0002002\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b1\u00102J\u0010\u00104\u001a\u000203H\u00d6\u0001\u00a2\u0006\u0004\b4\u00105J\u0010\u00106\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b6\u00107R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010*R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010:\u001a\u0004\b;\u0010,R\u0017\u0010<\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u0017\u0010@\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b@\u0010:\u001a\u0004\bA\u0010,R!\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00040B8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\u00a8\u0006\u0003"}, d2={"Lnet/mcbrawls/blueprint/structure/PlacedBlueprint;", "", "Lnet/mcbrawls/blueprint/structure/Blueprint;", "blueprint", "Lnet/minecraft/class_2338;", "position", "<init>", "(Lnet/mcbrawls/blueprint/structure/Blueprint;Lnet/minecraft/class_2338;)V", "Lnet/minecraft/class_3218;", "world", "place", "(Lnet/minecraft/class_3218;)Lnet/mcbrawls/blueprint/structure/PlacedBlueprint;", "", "key", "Lnet/mcbrawls/blueprint/region/Region;", "getRegion", "(Ljava/lang/String;)Lnet/mcbrawls/blueprint/region/Region;", "", "keys", "getRegionsCombined", "([Ljava/lang/String;)Lnet/mcbrawls/blueprint/region/Region;", "id", "Lnet/minecraft/class_243;", "getPointRegionPos", "(Ljava/lang/String;)Lnet/minecraft/class_243;", "", "Lnet/mcbrawls/blueprint/anchor/Anchor;", "getAnchors", "(Ljava/lang/String;)Ljava/util/List;", "anchor", "getAnchorOffset", "(Lnet/mcbrawls/blueprint/anchor/Anchor;)Lnet/mcbrawls/blueprint/anchor/Anchor;", "getUniqueAnchor", "(Ljava/lang/String;)Lnet/mcbrawls/blueprint/anchor/Anchor;", "Ljava/util/function/Consumer;", "action", "", "forEachPosition", "(Ljava/util/function/Consumer;)V", "clear", "(Lnet/minecraft/class_3218;)V", "component1", "()Lnet/mcbrawls/blueprint/structure/Blueprint;", "component2", "()Lnet/minecraft/class_2338;", "copy", "(Lnet/mcbrawls/blueprint/structure/Blueprint;Lnet/minecraft/class_2338;)Lnet/mcbrawls/blueprint/structure/PlacedBlueprint;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lnet/mcbrawls/blueprint/structure/Blueprint;", "getBlueprint", "Lnet/minecraft/class_2338;", "getPosition", "offset", "Lnet/minecraft/class_243;", "getOffset", "()Lnet/minecraft/class_243;", "center", "getCenter", "", "positions$delegate", "Lkotlin/Lazy;", "getPositions", "()Ljava/util/Set;", "positions", "Companion"})
@SourceDebugExtension(value={"SMAP\nPlacedBlueprint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlacedBlueprint.kt\nnet/mcbrawls/blueprint/structure/PlacedBlueprint\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n9389#2,2:162\n9539#2,4:164\n536#3:168\n521#3,6:169\n37#4:175\n36#4,3:176\n774#5:179\n865#5,2:180\n1563#5:182\n1634#5,3:183\n*S KotlinDebug\n*F\n+ 1 PlacedBlueprint.kt\nnet/mcbrawls/blueprint/structure/PlacedBlueprint\n*L\n83#1:162,2\n83#1:164,4\n88#1:168\n88#1:169,6\n97#1:175\n97#1:176,3\n114#1:179\n114#1:180,2\n115#1:182\n115#1:183,3\n*E\n"})
public final class PlacedBlueprint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Blueprint blueprint;
    @NotNull
    private final class_2338 position;
    @NotNull
    private final class_243 offset;
    @NotNull
    private final class_2338 center;
    @NotNull
    private final Lazy positions$delegate;
    @NotNull
    private static final Codec<PlacedBlueprint> CODEC;

    public PlacedBlueprint(@NotNull Blueprint blueprint, @NotNull class_2338 position) {
        Intrinsics.checkNotNullParameter((Object)blueprint, (String)"blueprint");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.blueprint = blueprint;
        this.position = position;
        class_243 class_2432 = class_243.method_24954((class_2382)((class_2382)this.position));
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"of(...)");
        this.offset = class_2432;
        class_2338 class_23382 = this.position.method_10081(this.blueprint.getCenter());
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"add(...)");
        this.center = class_23382;
        this.positions$delegate = LazyKt.lazy(() -> PlacedBlueprint.positions_delegate$lambda$1(this));
    }

    @NotNull
    public final Blueprint getBlueprint() {
        return this.blueprint;
    }

    @NotNull
    public final class_2338 getPosition() {
        return this.position;
    }

    @NotNull
    public final class_243 getOffset() {
        return this.offset;
    }

    @NotNull
    public final class_2338 getCenter() {
        return this.center;
    }

    @NotNull
    public final Set<class_2338> getPositions() {
        Lazy lazy = this.positions$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final PlacedBlueprint place(@NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Blueprint.place$default(this.blueprint, world, this.position, null, 4, null);
        return this;
    }

    @Nullable
    public final Region getRegion(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SerializableRegion serializableRegion = this.blueprint.getRegions().get(key);
        if (serializableRegion == null) {
            return null;
        }
        SerializableRegion region = serializableRegion;
        return region.withOffset(this.offset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Region getRegionsCombined(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        String[] $this$associateWith$iv = keys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        String[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void key;
            String element$iv$iv;
            String string = element$iv$iv = $this$associateWithTo$iv$iv[i];
            String string2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            SerializableRegion serializableRegion = this.blueprint.getRegions().get(key);
            map.put(string2, serializableRegion);
        }
        Map nullableRegions = result$iv;
        List regions = CollectionsKt.filterNotNull((Iterable)nullableRegions.values());
        if (regions.size() != nullableRegions.size()) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = nullableRegions;
            boolean $i$f$filter = false;
            Map $i$f$associateWithTo2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!(it.getValue() == null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Set invalidKeys = destination$iv$iv.keySet();
            BlueprintMod.INSTANCE.getLogger().warn("Tried to access blueprint regions but were not present: " + invalidKeys);
        }
        if (regions.isEmpty()) {
            return EmptyRegion.INSTANCE;
        }
        Collection $this$toTypedArray$iv = regions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SerializableRegion[] serializableRegionArray = thisCollection$iv.toArray(new SerializableRegion[0]);
        return CompoundRegion.Companion.ofRegionsOffset(this.offset, Arrays.copyOf(serializableRegionArray, serializableRegionArray.length));
    }

    @NotNull
    public final class_243 getPointRegionPos(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Region region = this.getRegion(id);
        if (region == null) {
            throw new IllegalArgumentException("Not a valid region: " + id);
        }
        Region region2 = region;
        PointRegion pointRegion = region2 instanceof PointRegion ? (PointRegion)region2 : null;
        if (pointRegion == null) {
            throw new IllegalArgumentException("Not a point region: " + id);
        }
        PointRegion pointRegion2 = pointRegion;
        return pointRegion2.getPointPosition();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Anchor> getAnchors(@NotNull String id) {
        void $this$mapTo$iv$iv;
        Pair pair;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Iterable $this$filter$iv = this.blueprint.getAnchors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            String testedId = (String)pair.component1();
            if (!Intrinsics.areEqual((Object)testedId, (Object)id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Anchor anchor = (Anchor)pair.component2();
            collection.add(this.getAnchorOffset(anchor));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Anchor getAnchorOffset(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        class_243 class_2432 = anchor.getPosition().method_1019(this.offset);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"add(...)");
        return new Anchor(class_2432, anchor.getRotation(), anchor.getData());
    }

    @Nullable
    public final Anchor getUniqueAnchor(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Anchor)CollectionsKt.firstOrNull(this.getAnchors(id));
    }

    public final void forEachPosition(@NotNull Consumer<class_2338> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.getPositions().forEach(action);
    }

    public final void clear(@NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.forEachPosition(arg_0 -> PlacedBlueprint.clear$lambda$6(world, arg_0));
    }

    @NotNull
    public final Blueprint component1() {
        return this.blueprint;
    }

    @NotNull
    public final class_2338 component2() {
        return this.position;
    }

    @NotNull
    public final PlacedBlueprint copy(@NotNull Blueprint blueprint, @NotNull class_2338 position) {
        Intrinsics.checkNotNullParameter((Object)blueprint, (String)"blueprint");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new PlacedBlueprint(blueprint, position);
    }

    public static /* synthetic */ PlacedBlueprint copy$default(PlacedBlueprint placedBlueprint, Blueprint blueprint, class_2338 class_23382, int n, Object object) {
        if ((n & 1) != 0) {
            blueprint = placedBlueprint.blueprint;
        }
        if ((n & 2) != 0) {
            class_23382 = placedBlueprint.position;
        }
        return placedBlueprint.copy(blueprint, class_23382);
    }

    @NotNull
    public String toString() {
        return "PlacedBlueprint(blueprint=" + this.blueprint + ", position=" + this.position + ")";
    }

    public int hashCode() {
        int result = this.blueprint.hashCode();
        result = result * 31 + this.position.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlacedBlueprint)) {
            return false;
        }
        PlacedBlueprint placedBlueprint = (PlacedBlueprint)other;
        if (!Intrinsics.areEqual((Object)this.blueprint, (Object)placedBlueprint.blueprint)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.position, (Object)placedBlueprint.position);
    }

    private static final Set positions_delegate$lambda$1(PlacedBlueprint this$0) {
        Set set;
        Set $this$positions_delegate_u24lambda_u241_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        class_2382 size = this$0.blueprint.getSize();
        int sizeX = size.method_10263();
        int sizeY = size.method_10264();
        int sizeZ = size.method_10260();
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    class_2338 class_23382 = this$0.position.method_10069(x, y, z);
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"add(...)");
                    $this$positions_delegate_u24lambda_u241_u24lambda_u240.add(class_23382);
                }
            }
        }
        return SetsKt.build((Set)set);
    }

    private static final void clear$lambda$6(class_3218 $world, class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        $world.method_8652(pos, class_2246.field_10124.method_9564(), 22);
    }

    private static final Blueprint CODEC$lambda$9$lambda$7(KProperty1 $tmp0, PlacedBlueprint p0) {
        return (Blueprint)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final class_2338 CODEC$lambda$9$lambda$8(KProperty1 $tmp0, PlacedBlueprint p0) {
        return (class_2338)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$9(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Blueprint.Companion.getCODEC().fieldOf("source_blueprint").forGetter(arg_0 -> PlacedBlueprint.CODEC$lambda$9$lambda$7((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)class_2338.field_25064.fieldOf("placed_position").forGetter(arg_0 -> PlacedBlueprint.CODEC$lambda$9$lambda$8((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, PlacedBlueprint::new);
    }

    static {
        Codec codec = RecordCodecBuilder.create(PlacedBlueprint::CODEC$lambda$9);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/mcbrawls/blueprint/structure/PlacedBlueprint$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lnet/mcbrawls/blueprint/structure/PlacedBlueprint;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "blueprint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<PlacedBlueprint> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

