/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.blueprint.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.mcbrawls.blueprint.BlueprintModKt;
import net.mcbrawls.blueprint.command.BlueprintCommand;
import net.mcbrawls.blueprint.resource.BlueprintManager;
import net.mcbrawls.blueprint.structure.Blueprint;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lnet/mcbrawls/blueprint/command/BlueprintCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "executeSave", "(Lcom/mojang/brigadier/context/CommandContext;)I", "executePlace", "execute", "", "BLUEPRINT_KEY", "Ljava/lang/String;", "POSITION_KEY", "START_POSITION_KEY", "END_POSITION_KEY", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "INVALID_BLUEPRINT_EXCEPTION_TYPE", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "blueprint"})
public final class BlueprintCommand {
    @NotNull
    public static final BlueprintCommand INSTANCE = new BlueprintCommand();
    @NotNull
    public static final String BLUEPRINT_KEY = "blueprint";
    @NotNull
    public static final String POSITION_KEY = "position";
    @NotNull
    public static final String START_POSITION_KEY = "start_position";
    @NotNull
    public static final String END_POSITION_KEY = "end_position";
    @NotNull
    private static final DynamicCommandExceptionType INVALID_BLUEPRINT_EXCEPTION_TYPE = new DynamicCommandExceptionType(BlueprintCommand::INVALID_BLUEPRINT_EXCEPTION_TYPE$lambda$0);

    private BlueprintCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)BLUEPRINT_KEY).executes(this::execute)).requires(BlueprintCommand::register$lambda$1)).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)START_POSITION_KEY, (ArgumentType)((ArgumentType)class_2262.method_9698())).then(class_2170.method_9244((String)END_POSITION_KEY, (ArgumentType)((ArgumentType)class_2262.method_9698())).then(class_2170.method_9244((String)BLUEPRINT_KEY, (ArgumentType)((ArgumentType)class_2232.method_9441())).suggests(BlueprintCommand::register$lambda$2).executes(this::executeSave)))))).then(class_2170.method_9247((String)"place").then(class_2170.method_9244((String)POSITION_KEY, (ArgumentType)((ArgumentType)class_2262.method_9698())).then(class_2170.method_9244((String)BLUEPRINT_KEY, (ArgumentType)((ArgumentType)class_2232.method_9441())).suggests(BlueprintCommand::register$lambda$3).executes(this::executePlace)))));
    }

    private final int executeSave(CommandContext<class_2168> context) {
        class_2960 blueprintId = class_2232.method_9443(context, (String)BLUEPRINT_KEY);
        class_2338 inputStartPosition = class_2262.method_9696(context, (String)START_POSITION_KEY);
        class_2338 inputEndPosition = class_2262.method_9696(context, (String)END_POSITION_KEY);
        Intrinsics.checkNotNull((Object)inputStartPosition);
        Intrinsics.checkNotNull((Object)inputEndPosition);
        Pair<class_2338, class_2338> pair = BlueprintModKt.asExtremeties(inputStartPosition, inputEndPosition);
        class_2338 min = (class_2338)pair.component1();
        class_2338 max = (class_2338)pair.component2();
        class_2168 source = (class_2168)context.getSource();
        class_3218 class_32182 = source.method_9225();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"getWorld(...)");
        Blueprint blueprint = Blueprint.Companion.save(class_32182, min, max);
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        Intrinsics.checkNotNull((Object)blueprintId);
        String pathString = BlueprintManager.INSTANCE.saveGenerated(minecraftServer, blueprintId, blueprint);
        ((class_2168)context.getSource()).method_9226(() -> BlueprintCommand.executeSave$lambda$4(pathString), true);
        return 1;
    }

    private final int executePlace(CommandContext<class_2168> context) {
        class_2960 blueprintId = class_2232.method_9443(context, (String)BLUEPRINT_KEY);
        Intrinsics.checkNotNull((Object)blueprintId);
        Blueprint blueprint = BlueprintManager.INSTANCE.get(blueprintId);
        if (blueprint == null) {
            throw INVALID_BLUEPRINT_EXCEPTION_TYPE.create((Object)blueprintId);
        }
        Blueprint blueprint2 = blueprint;
        class_2338 position = class_2262.method_9696(context, (String)POSITION_KEY);
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNull((Object)position);
        Blueprint.place$default(blueprint2, world, position, null, 4, null);
        ((class_2168)context.getSource()).method_9226(() -> BlueprintCommand.executePlace$lambda$5(position), true);
        return 1;
    }

    private final int execute(CommandContext<class_2168> context) {
        FabricLoader loader = FabricLoader.getInstance();
        Optional container = loader.getModContainer(BLUEPRINT_KEY);
        Optional<String> optionalVersion2 = container.map(arg_0 -> BlueprintCommand.execute$lambda$6(execute.optionalVersion.1.INSTANCE, arg_0)).map(arg_0 -> BlueprintCommand.execute$lambda$7(execute.optionalVersion.2.INSTANCE, arg_0)).map(arg_0 -> BlueprintCommand.execute$lambda$8(execute.optionalVersion.3.INSTANCE, arg_0));
        String version = optionalVersion2.orElseGet(BlueprintCommand::execute$lambda$9);
        ((class_2168)context.getSource()).method_9226(() -> BlueprintCommand.execute$lambda$10(version), false);
        return 1;
    }

    private static final Message INVALID_BLUEPRINT_EXCEPTION_TYPE$lambda$0(Object id) {
        return (Message)class_2561.method_43470((String)("There is no blueprint with id \"" + id + "\""));
    }

    private static final boolean register$lambda$1(class_2168 it) {
        return it.method_9259(2);
    }

    private static final CompletableFuture register$lambda$2(CommandContext commandContext, SuggestionsBuilder suggestions) {
        Intrinsics.checkNotNull((Object)suggestions);
        return BlueprintManager.INSTANCE.suggestBlueprints(suggestions);
    }

    private static final CompletableFuture register$lambda$3(CommandContext commandContext, SuggestionsBuilder suggestions) {
        Intrinsics.checkNotNull((Object)suggestions);
        return BlueprintManager.INSTANCE.suggestBlueprints(suggestions);
    }

    private static final class_2561 executeSave$lambda$4(String $pathString) {
        return (class_2561)class_2561.method_43470((String)("Saved blueprint to \"" + $pathString + "\""));
    }

    private static final class_2561 executePlace$lambda$5(class_2338 $position) {
        return (class_2561)class_2561.method_43470((String)("Placed blueprint at " + $position));
    }

    private static final ModMetadata execute$lambda$6(Function1 $tmp0, Object p0) {
        return (ModMetadata)$tmp0.invoke(p0);
    }

    private static final Version execute$lambda$7(Function1 $tmp0, Object p0) {
        return (Version)$tmp0.invoke(p0);
    }

    private static final String execute$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String execute$lambda$9() {
        return "Unknown";
    }

    private static final class_2561 execute$lambda$10(String $version) {
        return (class_2561)class_2561.method_43470((String)("[Blueprint] Version " + $version)).method_27692(class_124.field_1075);
    }
}

