/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.blueprint.editor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.mcbrawls.blueprint.region.serialization.SerializableRegion;
import net.mcbrawls.blueprint.resource.BlueprintManager;
import net.mcbrawls.blueprint.structure.Blueprint;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010%\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0001BB-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110!\u00a2\u0006\u0004\b\"\u0010#J\u0019\u0010&\u001a\u00020%2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010*\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010.R\u0013\u00102\u001a\u0004\u0018\u00010/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00103\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0016\u00106\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00104R\u0016\u00107\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00104R\u0016\u00108\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00104R\u0016\u00109\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00104R\u0011\u0010<\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010>\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b=\u0010;R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010A\u00a8\u0006C"}, d2={"Lnet/mcbrawls/blueprint/editor/BlueprintEditorWorld;", "Lxyz/nucleoid/fantasy/RuntimeWorld;", "Lnet/minecraft/class_2960;", "blueprintId", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "key", "Lxyz/nucleoid/fantasy/RuntimeWorldConfig;", "config", "<init>", "(Lnet/minecraft/class_2960;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_5321;Lxyz/nucleoid/fantasy/RuntimeWorldConfig;)V", "", "initializeBlueprint$blueprint", "()Z", "initializeBlueprint", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2680;", "state", "", "flags", "maxUpdateDepth", "setBlockState", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;II)Z", "Ljava/util/function/BooleanSupplier;", "shouldKeepTicking", "", "tick", "(Ljava/util/function/BooleanSupplier;)V", "updateExpectedSize", "(Lnet/minecraft/class_2338;)V", "Lkotlin/Pair;", "getRoughBlueprintBoundingBox", "()Lkotlin/Pair;", "id", "", "saveBlueprint", "(Lnet/minecraft/class_2960;)Ljava/lang/String;", "Lnet/mcbrawls/blueprint/region/serialization/SerializableRegion;", "region", "addRegion", "(Ljava/lang/String;Lnet/mcbrawls/blueprint/region/serialization/SerializableRegion;)V", "Lnet/minecraft/class_2960;", "getBlueprintId", "()Lnet/minecraft/class_2960;", "Lnet/mcbrawls/blueprint/structure/Blueprint;", "getSourceBlueprint", "()Lnet/mcbrawls/blueprint/structure/Blueprint;", "sourceBlueprint", "minX", "I", "minY", "minZ", "maxX", "maxY", "maxZ", "getMinPos", "()Lnet/minecraft/class_2338;", "minPos", "getMaxPos", "maxPos", "", "regions", "Ljava/util/Map;", "Companion", "blueprint"})
@SourceDebugExtension(value={"SMAP\nBlueprintEditorWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlueprintEditorWorld.kt\nnet/mcbrawls/blueprint/editor/BlueprintEditorWorld\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1869#2,2:172\n1869#2,2:174\n*S KotlinDebug\n*F\n+ 1 BlueprintEditorWorld.kt\nnet/mcbrawls/blueprint/editor/BlueprintEditorWorld\n*L\n77#1:172,2\n130#1:174,2\n*E\n"})
public final class BlueprintEditorWorld
extends RuntimeWorld {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2960 blueprintId;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    @NotNull
    private final Map<String, SerializableRegion> regions;
    @NotNull
    private static final class_2338 BLUEPRINT_PLACEMENT_POS = new class_2338(0, 64, 0);

    public BlueprintEditorWorld(@NotNull class_2960 blueprintId, @NotNull MinecraftServer server, @NotNull class_5321<class_1937> key, @NotNull RuntimeWorldConfig config) {
        Intrinsics.checkNotNullParameter((Object)blueprintId, (String)"blueprintId");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(server, key, config, RuntimeWorld.Style.TEMPORARY);
        this.blueprintId = blueprintId;
        this.minX = BLUEPRINT_PLACEMENT_POS.method_10263();
        this.minY = BLUEPRINT_PLACEMENT_POS.method_10264();
        this.minZ = BLUEPRINT_PLACEMENT_POS.method_10260();
        this.maxX = this.minX;
        this.maxY = this.minY;
        this.maxZ = this.minZ;
        this.regions = new LinkedHashMap();
    }

    @NotNull
    public final class_2960 getBlueprintId() {
        return this.blueprintId;
    }

    @Nullable
    public final Blueprint getSourceBlueprint() {
        return BlueprintManager.INSTANCE.get(this.blueprintId);
    }

    @NotNull
    public final class_2338 getMinPos() {
        return new class_2338(this.minX, this.minY, this.minZ);
    }

    @NotNull
    public final class_2338 getMaxPos() {
        return new class_2338(this.maxX, this.maxY, this.maxZ);
    }

    public final boolean initializeBlueprint$blueprint() {
        boolean bl;
        Blueprint blueprint = this.getSourceBlueprint();
        if (blueprint != null) {
            class_2382 size = blueprint.getSize();
            this.maxX += size.method_10263();
            this.maxY += size.method_10264();
            this.maxZ += size.method_10260();
            Blueprint.place$default(blueprint, (class_3218)this, BLUEPRINT_PLACEMENT_POS, null, 4, null);
            blueprint.placeCreatorMarkers((class_3218)this, BLUEPRINT_PLACEMENT_POS);
            this.regions.putAll(blueprint.getRegions());
            bl = false;
        } else {
            this.method_8501(this.getMinPos(), class_2246.field_10340.method_9564());
            bl = true;
        }
        return bl;
    }

    public boolean method_30092(@NotNull class_2338 pos, @NotNull class_2680 state, int flags, int maxUpdateDepth) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (super.method_30092(pos, state, flags, maxUpdateDepth)) {
            if (!state.method_26215()) {
                this.updateExpectedSize(pos);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void method_18765(@NotNull BooleanSupplier shouldKeepTicking) {
        Intrinsics.checkNotNullParameter((Object)shouldKeepTicking, (String)"shouldKeepTicking");
        super.method_18765(shouldKeepTicking);
        List list = this.method_18456();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            class_2338 class_23382 = player.method_24515();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
            this.updateExpectedSize(class_23382);
        }
    }

    private final void updateExpectedSize(class_2338 pos) {
        int n;
        int it = n = pos.method_10263();
        boolean bl = false;
        this.minX = Math.min(this.minX, it);
        this.maxX = Math.max(this.maxX, it);
        it = n = pos.method_10264();
        boolean bl2 = false;
        this.minY = Math.min(this.minY, it);
        this.maxY = Math.max(this.maxY, it);
        it = n = pos.method_10260();
        boolean bl3 = false;
        this.minZ = Math.min(this.minZ, it);
        this.maxZ = Math.max(this.maxZ, it);
    }

    @NotNull
    public final Pair<class_2338, class_2338> getRoughBlueprintBoundingBox() {
        class_2338 furthestMin = null;
        furthestMin = new class_2338(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        class_2338 furthestMax = null;
        furthestMax = new class_2338(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        Iterable iterable = class_2338.method_10097((class_2338)this.getMinPos(), (class_2338)this.getMaxPos());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterate(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2338 pos = (class_2338)element$iv;
            boolean bl = false;
            class_2680 state = this.method_8320(pos);
            if (state.method_26215()) continue;
            furthestMin = new class_2338(Math.min(furthestMin.method_10263(), pos.method_10263()), Math.min(furthestMin.method_10264(), pos.method_10264()), Math.min(furthestMin.method_10260(), pos.method_10260()));
            furthestMax = new class_2338(Math.max(furthestMax.method_10263(), pos.method_10263()), Math.max(furthestMax.method_10264(), pos.method_10264()), Math.max(furthestMax.method_10260(), pos.method_10260()));
        }
        return new Pair((Object)furthestMin, (Object)furthestMax);
    }

    @NotNull
    public final String saveBlueprint(@Nullable class_2960 id) {
        Pair<class_2338, class_2338> pair = this.getRoughBlueprintBoundingBox();
        class_2338 min = (class_2338)pair.component1();
        class_2338 max = (class_2338)pair.component2();
        Blueprint it = Blueprint.Companion.save((class_3218)this, min, max);
        boolean bl = false;
        Blueprint blueprint = Blueprint.copy$default(it, null, null, null, MapsKt.plus(it.getRegions(), this.regions), null, 23, null);
        MinecraftServer minecraftServer = this.method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        class_2960 class_29602 = id;
        if (class_29602 == null) {
            class_29602 = this.blueprintId;
        }
        return BlueprintManager.INSTANCE.saveGenerated(minecraftServer, class_29602, blueprint);
    }

    public static /* synthetic */ String saveBlueprint$default(BlueprintEditorWorld blueprintEditorWorld, class_2960 class_29602, int n, Object object) {
        if ((n & 1) != 0) {
            class_29602 = null;
        }
        return blueprintEditorWorld.saveBlueprint(class_29602);
    }

    public final void addRegion(@NotNull String id, @NotNull SerializableRegion region) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.regions.put(id, region);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/mcbrawls/blueprint/editor/BlueprintEditorWorld$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2338;", "BLUEPRINT_PLACEMENT_POS", "Lnet/minecraft/class_2338;", "getBLUEPRINT_PLACEMENT_POS", "()Lnet/minecraft/class_2338;", "blueprint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2338 getBLUEPRINT_PLACEMENT_POS() {
            return BLUEPRINT_PLACEMENT_POS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

