/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.defencez;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class DefenceZ
extends JavaPlugin
implements Listener {
    private Economy economy = null;
    private Map<String, Gang> gangs = new HashMap<String, Gang>();
    private Map<Block, DefenseBlock> defenseBlocks = new HashMap<Block, DefenseBlock>();
    private File gangsFile;
    private YamlConfiguration gangsConfig;
    private NamespacedKey defenseKey;
    private NamespacedKey defenseLevelKey;
    private NamespacedKey defenseHealthKey;
    private NamespacedKey bombTypeKey;
    private NamespacedKey gangDoorKey;
    private Map<Integer, Integer> defenseHealthByLevel = new HashMap<Integer, Integer>();
    private Map<Integer, Material> defenseBlockByLevel = new HashMap<Integer, Material>();
    private Map<Integer, Double> upgradeVaultCostByLevel = new HashMap<Integer, Double>();
    private Map<String, Integer> bombDamageByType = new HashMap<String, Integer>();
    private Map<UUID, Long> upgradeTimers = new HashMap<UUID, Long>();
    private static final long UPGRADE_COOLDOWN = 3000L;
    private Map<UUID, String> gangInvites = new HashMap<UUID, String>();

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.gangsFile = new File(this.getDataFolder(), "gangs.yml");
        this.defenseKey = new NamespacedKey(this, "defense");
        this.defenseLevelKey = new NamespacedKey(this, "defense_level");
        this.defenseHealthKey = new NamespacedKey(this, "defense_health");
        this.bombTypeKey = new NamespacedKey(this, "bomb_type");
        this.gangDoorKey = new NamespacedKey(this, "gang_door");
        if (!this.setupEconomy()) {
            this.getLogger().severe("Disabled due to no Vault dependency found!");
            this.getServer().getPluginManager().disablePlugin(this);
            return;
        }
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("givedefense").setExecutor(this);
        this.getCommand("givebomb").setExecutor(this);
        this.getCommand("givedoor").setExecutor(this);
        this.getCommand("givetrapdoor").setExecutor(this);
        this.getCommand("gang").setExecutor(this);
        this.getCommand("gangchat").setExecutor(this);
        this.loadConfig();
        this.loadGangsFromFile();
        this.getLogger().info("DefenceZ enabled with gang persistence!");
    }

    private void loadGangsFromFile() {
        if (!this.gangsFile.exists()) {
            this.saveGangsToFile();
            return;
        }
        this.gangsConfig = YamlConfiguration.loadConfiguration(this.gangsFile);
        if (this.gangsConfig.getConfigurationSection("gangs") == null) {
            return;
        }
        for (String gangName : this.gangsConfig.getConfigurationSection("gangs").getKeys(false)) {
            String path = "gangs." + gangName;
            String ownerUUIDString = this.gangsConfig.getString(path + ".owner");
            if (ownerUUIDString == null) continue;
            UUID ownerUUID = UUID.fromString(ownerUUIDString);
            Gang gang = new Gang(this, gangName, ownerUUID);
            List<String> memberUUIDs = this.gangsConfig.getStringList(path + ".members");
            gang.getMembers().clear();
            for (String memberUUIDString : memberUUIDs) {
                UUID memberUUID = UUID.fromString(memberUUIDString);
                gang.addMember(memberUUID);
            }
            this.gangs.put(gangName.toLowerCase(), gang);
        }
        this.getLogger().info("Loaded " + this.gangs.size() + " gangs from file.");
    }

    private void saveGangsToFile() {
        if (this.gangsConfig == null) {
            this.gangsConfig = new YamlConfiguration();
        }
        this.gangsConfig.set("gangs", null);
        for (Gang gang : this.gangs.values()) {
            String path = "gangs." + gang.getName();
            this.gangsConfig.set(path + ".owner", gang.getOwner().toString());
            ArrayList<String> memberUUIDs = new ArrayList<String>();
            for (UUID memberUUID : gang.getMembers()) {
                memberUUIDs.add(memberUUID.toString());
            }
            this.gangsConfig.set(path + ".members", memberUUIDs);
        }
        try {
            this.gangsConfig.save(this.gangsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save gangs.yml: " + e.getMessage());
        }
    }

    @Override
    public void onDisable() {
        this.saveData();
        this.getLogger().info("DefenceZ has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider<Economy> rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = rsp.getProvider();
        return this.economy != null;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.defenseHealthByLevel.put(1, config.getInt("defense.level1.health", 1000));
        this.defenseHealthByLevel.put(2, config.getInt("defense.level2.health", 1500));
        this.defenseHealthByLevel.put(3, config.getInt("defense.level3.health", 2000));
        this.defenseHealthByLevel.put(4, config.getInt("defense.level4.health", 2500));
        this.defenseHealthByLevel.put(5, config.getInt("defense.level5.health", 3000));
        this.defenseHealthByLevel.put(6, config.getInt("defense.level6.health", 3500));
        this.defenseHealthByLevel.put(7, config.getInt("defense.level7.health", 4000));
        this.defenseHealthByLevel.put(8, config.getInt("defense.level8.health", 4500));
        this.defenseHealthByLevel.put(9, config.getInt("defense.level9.health", 4500));
        this.defenseHealthByLevel.put(10, config.getInt("defense.level10.health", 5000));
        for (int i = 1; i <= 10; ++i) {
            this.upgradeVaultCostByLevel.put(i, config.getDouble("defense.level" + i + ".upgrade_cost", i * 1000));
            String materialName = config.getString("defense.level" + i + ".material", "STONE");
            try {
                Material material = Material.valueOf(materialName);
                this.defenseBlockByLevel.put(i, material);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid material for level " + i + ": " + materialName);
                this.defenseBlockByLevel.put(i, Material.STONE);
            }
        }
        this.bombDamageByType.put("small", config.getInt("bombs.small.damage", 1500));
        this.bombDamageByType.put("medium", config.getInt("bombs.medium.damage", 2500));
        this.bombDamageByType.put("large", config.getInt("bombs.large.damage", 3500));
        this.getLogger().info("Loaded HIGH DAMAGE bomb values: Small=" + String.valueOf(this.bombDamageByType.get("small")) + ", Medium=" + String.valueOf(this.bombDamageByType.get("medium")) + ", Large=" + String.valueOf(this.bombDamageByType.get("large")));
    }

    private void saveData() {
        this.saveGangsToFile();
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        boolean isConsole = !(sender instanceof Player);
        Player player2 = player = isConsole ? null : (Player)sender;
        if ((isConsole || !command.getName().equalsIgnoreCase("gang") && !command.getName().equalsIgnoreCase("gangchat")) && isConsole && (command.getName().equalsIgnoreCase("gang") || command.getName().equalsIgnoreCase("gangchat"))) {
            sender.sendMessage("\u00a7cGang commands cannot be used by console.");
            return true;
        }
        if (command.getName().equalsIgnoreCase("givedefense")) {
            if (!isConsole && !player.hasPermission("defencez.admin")) {
                player.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /givedefense <player> <level>");
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            try {
                int level = Integer.parseInt(args[1]);
                if (level < 1 || level > 10) {
                    sender.sendMessage("\u00a7cLevel must be between 1 and 10.");
                    return true;
                }
                ItemStack defenseItem = this.createDefenseItem(level);
                target.getInventory().addItem(defenseItem);
                if (!isConsole) {
                    target.sendMessage("\u00a7aYou have been given a Level " + level + " Defense Block.");
                    if (!target.equals(player)) {
                        player.sendMessage("\u00a7aGave " + target.getName() + " a Level " + level + " Defense Block.");
                    }
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid level. Please use a number between 1 and 10.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("givebomb")) {
            if (!isConsole && !player.hasPermission("defencez.admin")) {
                player.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /givebomb <player> <small|medium|large>");
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            String type = args[1].toLowerCase();
            if (!(type.equals("small") || type.equals("medium") || type.equals("large"))) {
                sender.sendMessage("\u00a7cInvalid bomb type. Use: small, medium, or large.");
                return true;
            }
            ItemStack bombItem = this.createBombItem(type);
            target.getInventory().addItem(bombItem);
            int damage = this.bombDamageByType.get(type);
            String bombName = type.substring(0, 1).toUpperCase() + type.substring(1);
            if (!isConsole) {
                target.sendMessage("\u00a7aYou have been given a " + bombName + " Bomb (" + damage + " DMG).");
                if (!target.equals(player)) {
                    player.sendMessage("\u00a7aGave " + target.getName() + " a " + bombName + " Bomb (" + damage + " DMG).");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("givedoor")) {
            if (!isConsole && !player.hasPermission("defencez.admin")) {
                player.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage("\u00a7cUsage: /givedoor <player>");
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            ItemStack doorItem = this.createGangDoorItem();
            target.getInventory().addItem(doorItem);
            if (!isConsole) {
                target.sendMessage("\u00a7aYou have been given a Gang Iron Door.");
                if (!target.equals(player)) {
                    player.sendMessage("\u00a7aGave " + target.getName() + " a Gang Iron Door.");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("givetrapdoor")) {
            if (!isConsole && !player.hasPermission("defencez.admin")) {
                player.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage("\u00a7cUsage: /givetrapdoor <player>");
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            ItemStack trapdoorItem = this.createGangTrapdoorItem();
            target.getInventory().addItem(trapdoorItem);
            if (!isConsole) {
                target.sendMessage("\u00a7aYou have been given a Gang Iron Trapdoor.");
                if (!target.equals(player)) {
                    player.sendMessage("\u00a7aGave " + target.getName() + " a Gang Iron Trapdoor.");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("gang")) {
            if (args.length < 1) {
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a7e/gang create <name> \u00a77- Create gang     \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a7b/gang invite <player> \u00a77- Invite player \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a7a/gang accept \u00a77- Accept invitation      \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a7c/gang leave \u00a77- Leave gang              \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a7d/gang kick <player> \u00a77- Kick player    \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a79/gang list \u00a77- List all gangs          \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a76/gang info \u00a77- View gang info          \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a74/gang disband \u00a77- Disband gang         \u00a78\u00a7l\u2551");
                player.sendMessage("\u00a78\u00a7l\u2551 \u00a72/gang updateblocks \u00a77- Update doors    \u00a78\u00a7l\u2551");
                return true;
            }
            String subCommand = args[0].toLowerCase();
            if (subCommand.equals("create")) {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /gang create <name>");
                    return true;
                }
                String gangName = args[1];
                return this.handleGangCreate(player, gangName);
            }
            if (subCommand.equals("updateblocks")) {
                return this.handleGangUpdateBlocks(player);
            }
            if (subCommand.equals("invite")) {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /gang invite <player>");
                    return true;
                }
                String targetName = args[1];
                return this.handleGangInvite(player, targetName);
            }
            if (subCommand.equals("accept")) {
                return this.handleGangAccept(player);
            }
            if (subCommand.equals("leave")) {
                return this.handleGangLeave(player);
            }
            if (subCommand.equals("kick")) {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /gang kick <player>");
                    return true;
                }
                String targetName = args[1];
                return this.handleGangKick(player, targetName);
            }
            if (subCommand.equals("list")) {
                return this.handleGangList(player);
            }
            if (subCommand.equals("info")) {
                return this.handleGangInfo(player);
            }
            if (subCommand.equals("disband")) {
                return this.handleGangDisband(player);
            }
            player.sendMessage("\u00a7cUnknown gang command. Use: create, invite, accept, leave, kick, list, info, disband");
            return true;
        }
        if (command.getName().equalsIgnoreCase("gangchat") || command.getName().equalsIgnoreCase("gc")) {
            if (args.length < 1) {
                player.sendMessage("\u00a7cUsage: /gc <message>");
                return true;
            }
            StringBuilder message = new StringBuilder();
            for (String arg : args) {
                message.append(arg).append(" ");
            }
            return this.handleGangChat(player, message.toString().trim());
        }
        return false;
    }

    private boolean handleGangUpdateBlocks(Player player) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        if (!playerGang.getOwner().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the gang owner can update blocks!");
            return true;
        }
        int updatedBlocks = 0;
        UUID playerUUID = player.getUniqueId();
        for (Map.Entry<Block, DefenseBlock> entry : this.defenseBlocks.entrySet()) {
            GangProtectedBlock gangBlock;
            DefenseBlock defenseBlock = entry.getValue();
            if (!(defenseBlock instanceof GangProtectedBlock) || !(gangBlock = (GangProtectedBlock)defenseBlock).getOwner().equals(playerUUID)) continue;
            gangBlock.setGangName(playerGang.getName());
            ++updatedBlocks;
        }
        player.sendMessage("\u00a7aUpdated " + updatedBlocks + " blocks to use your current gang!");
        return true;
    }

    private ItemStack createDefenseItem(int level) {
        Material material = this.defenseBlockByLevel.get(level);
        if (material == null) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a76Level " + level + " Defense Block");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Health: \u00a7a" + String.valueOf(this.defenseHealthByLevel.get(level)));
        lore.add("\u00a77Level: \u00a7b" + level);
        if (level < 10) {
            lore.add("\u00a77Shift-click to upgrade (Cost: \u00a7e$" + String.valueOf(this.upgradeVaultCostByLevel.get(level)) + "\u00a77)");
        } else {
            lore.add("\u00a77\u00a7lMAX LEVEL REACHED!");
        }
        lore.add("\u00a78DefenceZ-Defense");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.defenseKey, PersistentDataType.STRING, "defense");
        container.set(this.defenseLevelKey, PersistentDataType.INTEGER, level);
        container.set(this.defenseHealthKey, PersistentDataType.INTEGER, this.defenseHealthByLevel.get(level));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createBombItem(String type) {
        String displayName;
        Material material = Material.TNT;
        String colorCode = switch (type) {
            case "small" -> {
                displayName = "\u00a7cSmall Bomb";
                yield "\u00a7c";
            }
            case "medium" -> {
                displayName = "\u00a76Medium Bomb";
                yield "\u00a76";
            }
            case "large" -> {
                displayName = "\u00a74Large Bomb";
                yield "\u00a74";
            }
            default -> {
                displayName = "\u00a7cSmall Bomb";
                yield "\u00a7c";
            }
        };
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        int damage = this.bombDamageByType.get(type);
        lore.add("\u00a77Damage: " + colorCode + damage + " DMG");
        lore.add("\u00a77Right-click on a defense block to damage it.");
        lore.add("\u00a77Can destroy gang doors/trapdoors!");
        lore.add("\u00a78DefenceZ-Bomb");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.bombTypeKey, PersistentDataType.STRING, type);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGangDoorItem() {
        ItemStack item = new ItemStack(Material.IRON_DOOR);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a7bGang Iron Door");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Only gang members can open");
        lore.add("\u00a77If no gang, only owner can open");
        lore.add("\u00a77Hold Door Opener + Shift + Right-click to open/close");
        lore.add("\u00a77HP: \u00a7c1250 \u00a77(Can be bombed)");
        lore.add("\u00a78DefenceZ-GangDoor");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.gangDoorKey, PersistentDataType.STRING, "gang_door");
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createGangTrapdoorItem() {
        ItemStack item = new ItemStack(Material.IRON_TRAPDOOR);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a7bGang Iron Trapdoor");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Only gang members can open");
        lore.add("\u00a77If no gang, only owner can open");
        lore.add("\u00a77Hold Door Opener + Shift + Right-click to open/close");
        lore.add("\u00a77HP: \u00a7c1250 \u00a77(Can be bombed)");
        lore.add("\u00a78DefenceZ-GangTrapdoor");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.gangDoorKey, PersistentDataType.STRING, "gang_trapdoor");
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createDoorOpener() {
        ItemStack doorOpener = new ItemStack(Material.COBWEB);
        ItemMeta meta = doorOpener.getItemMeta();
        meta.setDisplayName("\u00a76\u00a7lDoor Opener");
        meta.setUnbreakable(true);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Special tool for opening doors/trapdoors");
        lore.add("\u00a77Hold this and Shift + Right-click doors");
        lore.add("\u00a77Works on gang doors and regular iron doors");
        lore.add("\u00a7c\u00a7lCANNOT BE PLACED, DROPPED, OR STORED");
        lore.add("\u00a78DefenceZ-DoorOpener");
        meta.setLore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey(this, "door_opener"), PersistentDataType.STRING, "true");
        doorOpener.setItemMeta(meta);
        return doorOpener;
    }

    private boolean hasDoorOpener(Player player) {
        ItemStack[] contents;
        for (ItemStack item : contents = player.getInventory().getContents()) {
            ItemMeta meta;
            PersistentDataContainer container;
            if (item == null || !item.hasItemMeta() || !(container = (meta = item.getItemMeta()).getPersistentDataContainer()).has(new NamespacedKey(this, "door_opener"), PersistentDataType.STRING)) continue;
            return true;
        }
        return false;
    }

    private boolean isDoorOpener(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(new NamespacedKey(this, "door_opener"), PersistentDataType.STRING);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.defenseBlocks.containsKey(block)) {
            DefenseBlock defenseBlock = this.defenseBlocks.get(block);
            if (defenseBlock instanceof GangProtectedBlock) {
                event.setCancelled(true);
                event.setDropItems(false);
                Player player = event.getPlayer();
                player.sendMessage("\u00a7cThis door/trapdoor can only be damaged with bombs!");
                return;
            }
            event.setCancelled(true);
            event.setDropItems(false);
            Player player = event.getPlayer();
            player.sendMessage("\u00a7cThis is a defense block! It can only be destroyed with bombs.");
            return;
        }
        if (block.getType() == Material.IRON_DOOR) {
            Block bottomBlock = block;
            Block topBlock = block;
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Door) {
                Door door = (Door)blockData;
                if (door.getHalf() == Bisected.Half.TOP) {
                    topBlock = block;
                    bottomBlock = block.getRelative(BlockFace.DOWN);
                } else {
                    bottomBlock = block;
                    topBlock = block.getRelative(BlockFace.UP);
                }
            }
            if (this.defenseBlocks.containsKey(bottomBlock) || this.defenseBlocks.containsKey(topBlock)) {
                event.setCancelled(true);
                event.setDropItems(false);
                Player player = event.getPlayer();
                player.sendMessage("\u00a7cThis door can only be damaged with bombs!");
                return;
            }
        }
        if (block.getType() == Material.IRON_TRAPDOOR && this.defenseBlocks.containsKey(block)) {
            event.setCancelled(true);
            event.setDropItems(false);
            Player player = event.getPlayer();
            player.sendMessage("\u00a7cThis trapdoor can only be damaged with bombs!");
            return;
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (this.isDoorOpener(item)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cYou cannot place the Door Opener!");
            return;
        }
        if (container.has(this.bombTypeKey, PersistentDataType.STRING)) {
            event.setCancelled(true);
            return;
        }
        if (container.has(this.defenseKey, PersistentDataType.STRING)) {
            int level = container.get(this.defenseLevelKey, PersistentDataType.INTEGER);
            int health = container.get(this.defenseHealthKey, PersistentDataType.INTEGER);
            DefenseBlock defenseBlock = new DefenseBlock(this, event.getBlock(), level, health, event.getPlayer().getUniqueId());
            this.defenseBlocks.put(event.getBlock(), defenseBlock);
            event.getPlayer().sendMessage("\u00a7aDefense block placed! (Level: " + level + ", Health: " + health + ")");
        }
        if (container.has(this.gangDoorKey, PersistentDataType.STRING)) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            Gang playerGang = this.getPlayerGang(playerUUID);
            GangProtectedBlock gangProtectedBlock = new GangProtectedBlock(this, event.getBlock(), playerGang != null ? playerGang.getName() : null, event.getPlayer().getUniqueId(), 1250);
            this.defenseBlocks.put(event.getBlock(), gangProtectedBlock);
            if (item.getType() == Material.IRON_DOOR) {
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                    Block topBlock = event.getBlock().getRelative(BlockFace.UP);
                    if (topBlock.getType() == Material.IRON_DOOR) {
                        GangProtectedBlock topGangBlock = new GangProtectedBlock(this, topBlock, playerGang != null ? playerGang.getName() : null, event.getPlayer().getUniqueId(), 1250);
                        this.defenseBlocks.put(topBlock, topGangBlock);
                        this.getLogger().info("Protected both door parts for " + event.getPlayer().getName());
                    }
                }, 1L);
            }
            String itemType = item.getType() == Material.IRON_DOOR ? "door" : "trapdoor";
            event.getPlayer().sendMessage("\u00a7aGang-protected " + itemType + " placed! (Right-click to open/close)");
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        if (this.isDoorOpener(droppedItem)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cYou cannot drop the Door Opener!");
            return;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.hasDoorOpener(player)) {
            ItemStack doorOpener = this.createDoorOpener();
            if (player.getInventory().getItem(8) == null) {
                player.getInventory().setItem(8, doorOpener);
            } else {
                player.getInventory().addItem(doorOpener);
            }
            player.sendMessage("\u00a7aYou have been given a Door Opener! Use it to open doors and trapdoors.");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && player.isSneaking()) {
            block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if ((block.getType() == Material.IRON_DOOR || block.getType() == Material.IRON_TRAPDOOR) && this.isDoorOpener(item)) {
                DefenseBlock defenseBlock;
                Door door;
                BlockData blockData;
                Block checkBlock = block;
                if (block.getType() == Material.IRON_DOOR && (blockData = block.getBlockData()) instanceof Door && (door = (Door)blockData).getHalf() == Bisected.Half.TOP) {
                    checkBlock = block.getRelative(BlockFace.DOWN);
                }
                if ((defenseBlock = this.defenseBlocks.get(checkBlock)) instanceof GangProtectedBlock) {
                    GangProtectedBlock gangBlock = (GangProtectedBlock)defenseBlock;
                    UUID playerUUID = player.getUniqueId();
                    if (gangBlock.getOwner().equals(playerUUID)) {
                        event.setCancelled(true);
                        if (block.getType() == Material.IRON_DOOR) {
                            this.toggleIronDoor(block);
                        } else if (block.getType() == Material.IRON_TRAPDOOR) {
                            this.toggleIronTrapdoor(block);
                        }
                        return;
                    }
                    if (gangBlock.getGangName() != null) {
                        Gang playerGang = this.getPlayerGang(playerUUID);
                        if (playerGang != null && playerGang.getName().equals(gangBlock.getGangName())) {
                            event.setCancelled(true);
                            if (block.getType() == Material.IRON_DOOR) {
                                this.toggleIronDoor(block);
                            } else if (block.getType() == Material.IRON_TRAPDOOR) {
                                this.toggleIronTrapdoor(block);
                            }
                        } else {
                            event.setCancelled(true);
                            player.sendMessage("\u00a7cThis door/trapdoor belongs to another gang!");
                        }
                    } else {
                        event.setCancelled(true);
                        player.sendMessage("\u00a7cThis door/trapdoor belongs to another player!");
                    }
                    return;
                }
                event.setCancelled(true);
                if (block.getType() == Material.IRON_DOOR) {
                    this.toggleIronDoor(block);
                } else if (block.getType() == Material.IRON_TRAPDOOR) {
                    this.toggleIronTrapdoor(block);
                }
                return;
            }
            if (block.getType() != Material.IRON_DOOR && block.getType() != Material.IRON_TRAPDOOR && this.defenseBlocks.containsKey(block)) {
                long lastUpgradeTime;
                UUID playerUUID = player.getUniqueId();
                long currentTime = System.currentTimeMillis();
                if (this.upgradeTimers.containsKey(playerUUID) && currentTime - (lastUpgradeTime = this.upgradeTimers.get(playerUUID).longValue()) < 3000L) {
                    long remainingTime = (3000L - (currentTime - lastUpgradeTime)) / 1000L;
                    player.sendMessage("\u00a7cUpgrade cooldown! Wait " + remainingTime + " more seconds.");
                    event.setCancelled(true);
                    return;
                }
                DefenseBlock defenseBlock = this.defenseBlocks.get(block);
                if (!(defenseBlock instanceof GangProtectedBlock)) {
                    int currentLevel = defenseBlock.getLevel();
                    if (currentLevel < 10) {
                        double upgradeCost = this.upgradeVaultCostByLevel.get(currentLevel);
                        if (this.economy.has((OfflinePlayer)player, upgradeCost)) {
                            this.upgradeTimers.put(playerUUID, currentTime);
                            this.economy.withdrawPlayer((OfflinePlayer)player, upgradeCost);
                            int newLevel = currentLevel + 1;
                            Material newMaterial = this.defenseBlockByLevel.get(newLevel);
                            int newHealth = this.defenseHealthByLevel.get(newLevel);
                            block.setType(newMaterial);
                            defenseBlock.setLevel(newLevel);
                            defenseBlock.setMaxHealth(newHealth);
                            defenseBlock.setCurrentHealth(newHealth);
                            player.sendMessage("\u00a7aDefense block upgraded to level " + newLevel + "! Health: " + newHealth);
                            event.setCancelled(true);
                        } else {
                            player.sendMessage("\u00a7cYou don't have enough money to upgrade this defense block! You need: $" + upgradeCost);
                            event.setCancelled(true);
                        }
                    } else {
                        player.sendMessage("\u00a7cThis defense block is already at maximum level!");
                        event.setCancelled(true);
                    }
                }
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemMeta meta;
            PersistentDataContainer container;
            ItemStack itemInHand;
            block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (this.defenseBlocks.containsKey(block) && (itemInHand = event.getItem()) != null && itemInHand.hasItemMeta() && (container = (meta = itemInHand.getItemMeta()).getPersistentDataContainer()).has(this.bombTypeKey, PersistentDataType.STRING)) {
                String bombType = container.get(this.bombTypeKey, PersistentDataType.STRING);
                int damage = this.bombDamageByType.get(bombType);
                DefenseBlock defenseBlock = this.defenseBlocks.get(block);
                int remainingHealth = defenseBlock.damage(damage);
                block.getWorld().createExplosion(block.getLocation(), 0.0f, false, false);
                if (remainingHealth <= 0) {
                    block.setType(Material.AIR);
                    this.defenseBlocks.remove(block);
                    if (defenseBlock instanceof GangProtectedBlock) {
                        Block topBlock = block.getRelative(BlockFace.UP);
                        Block bottomBlock = block.getRelative(BlockFace.DOWN);
                        if (this.defenseBlocks.containsKey(topBlock)) {
                            topBlock.setType(Material.AIR);
                            this.defenseBlocks.remove(topBlock);
                        }
                        if (this.defenseBlocks.containsKey(bottomBlock)) {
                            bottomBlock.setType(Material.AIR);
                            this.defenseBlocks.remove(bottomBlock);
                        }
                    }
                    String bombName = bombType.substring(0, 1).toUpperCase() + bombType.substring(1);
                    event.getPlayer().sendMessage("\u00a7c" + bombName + " Bomb (" + damage + " DMG) destroyed the defense block!");
                } else {
                    String bombName = bombType.substring(0, 1).toUpperCase() + bombType.substring(1);
                    event.getPlayer().sendMessage("\u00a7e" + bombName + " Bomb (" + damage + " DMG) hit! Remaining health: \u00a7c" + remainingHealth);
                }
                if (itemInHand.getAmount() > 1) {
                    itemInHand.setAmount(itemInHand.getAmount() - 1);
                } else {
                    event.getPlayer().getInventory().setItemInMainHand(null);
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        ItemStack firstItem = event.getInventory().getItem(0);
        ItemStack secondItem = event.getInventory().getItem(1);
        if (firstItem != null && this.isDefenseItem(firstItem)) {
            event.setResult(null);
        }
        if (secondItem != null && this.isDefenseItem(secondItem)) {
            event.setResult(null);
        }
    }

    private boolean isDefenseItem(ItemStack item) {
        ItemMeta meta;
        List<String> lore;
        if (item.hasItemMeta() && (lore = (meta = item.getItemMeta()).getLore()) != null) {
            for (String line : lore) {
                if (!line.contains("DefenceZ-Defense") && !line.contains("DefenceZ-Bomb") && !line.contains("DefenceZ-GangDoor") && !line.contains("DefenceZ-GangTrapdoor")) continue;
                return true;
            }
        }
        return false;
    }

    private void toggleIronDoor(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door;
            door.setOpen(!(door = (Door)blockData).isOpen());
            block.setBlockData(door);
            if (door.isOpen()) {
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
            } else {
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 1.0f);
            }
        }
    }

    private void toggleIronTrapdoor(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof TrapDoor) {
            TrapDoor trapdoor;
            trapdoor.setOpen(!(trapdoor = (TrapDoor)blockData).isOpen());
            block.setBlockData(trapdoor);
            if (trapdoor.isOpen()) {
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_OPEN, 1.0f, 1.0f);
            } else {
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_IRON_TRAPDOOR_CLOSE, 1.0f, 1.0f);
            }
        }
    }

    private boolean handleGangCreate(Player player, String gangName) {
        if (this.getPlayerGang(player.getUniqueId()) != null) {
            player.sendMessage("\u00a7cYou are already in a gang!");
            return true;
        }
        if (this.gangs.containsKey(gangName.toLowerCase())) {
            player.sendMessage("\u00a7cA gang with that name already exists!");
            return true;
        }
        Gang gang = new Gang(this, gangName, player.getUniqueId());
        this.gangs.put(gangName.toLowerCase(), gang);
        this.saveGangsToFile();
        player.sendMessage("\u00a7aCreated gang: " + gangName);
        return true;
    }

    private boolean handleGangInvite(Player player, String targetName) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        if (!playerGang.getOwner().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the gang owner can invite new members!");
            return true;
        }
        Player target = Bukkit.getPlayer(targetName);
        if (target == null) {
            player.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        if (this.getPlayerGang(target.getUniqueId()) != null) {
            player.sendMessage("\u00a7cThat player is already in a gang!");
            return true;
        }
        this.gangInvites.put(target.getUniqueId(), playerGang.getName().toLowerCase());
        player.sendMessage("\u00a7aYou have invited " + target.getName() + " to join your gang!");
        target.sendMessage("\u00a7aYou have been invited to join the gang: " + playerGang.getName());
        target.sendMessage("\u00a7aType /gang accept to join!");
        return true;
    }

    private boolean handleGangAccept(Player player) {
        String gangName = this.gangInvites.get(player.getUniqueId());
        if (gangName == null) {
            player.sendMessage("\u00a7cNo gang invites!");
            return true;
        }
        Gang gang = this.gangs.get(gangName);
        if (gang == null) {
            player.sendMessage("\u00a7cGang no longer exists!");
            this.gangInvites.remove(player.getUniqueId());
            return true;
        }
        gang.addMember(player.getUniqueId());
        this.gangInvites.remove(player.getUniqueId());
        this.saveGangsToFile();
        player.sendMessage("\u00a7aJoined gang: " + gang.getName());
        for (UUID memberUUID : gang.getMembers()) {
            Player member = Bukkit.getPlayer(memberUUID);
            if (member == null || member.equals(player)) continue;
            member.sendMessage("\u00a7a" + player.getName() + " joined the gang!");
        }
        return true;
    }

    private boolean handleGangLeave(Player player) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        if (playerGang.getOwner().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou're the owner! Disband or transfer ownership first!");
            return true;
        }
        playerGang.removeMember(player.getUniqueId());
        this.saveGangsToFile();
        player.sendMessage("\u00a7aLeft gang: " + playerGang.getName());
        for (UUID memberUUID : playerGang.getMembers()) {
            Player member = Bukkit.getPlayer(memberUUID);
            if (member == null) continue;
            member.sendMessage("\u00a7c" + player.getName() + " left the gang!");
        }
        return true;
    }

    private boolean handleGangKick(Player player, String targetName) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        if (!playerGang.getOwner().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the owner can kick members!");
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer(targetName);
        UUID targetUUID = null;
        if (targetPlayer != null) {
            targetUUID = targetPlayer.getUniqueId();
        } else {
            for (UUID memberUUID : playerGang.getMembers()) {
                String memberName = Bukkit.getOfflinePlayer(memberUUID).getName();
                if (memberName == null || !memberName.equalsIgnoreCase(targetName)) continue;
                targetUUID = memberUUID;
                break;
            }
        }
        if (targetUUID == null) {
            player.sendMessage("\u00a7cPlayer not found in your gang!");
            return true;
        }
        if (targetUUID.equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou cannot kick yourself! Use /gang disband instead.");
            return true;
        }
        playerGang.removeMember(targetUUID);
        this.saveGangsToFile();
        player.sendMessage("\u00a7aKicked " + targetName + " from your gang!");
        if (targetPlayer != null) {
            targetPlayer.sendMessage("\u00a7cKicked from gang: " + playerGang.getName());
        }
        for (UUID memberUUID : playerGang.getMembers()) {
            Player member = Bukkit.getPlayer(memberUUID);
            if (member == null || member.equals(player)) continue;
            member.sendMessage("\u00a7c" + targetName + " was kicked from the gang!");
        }
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if (this.isDoorOpener(clickedItem) || this.isDoorOpener(cursorItem)) {
            if (event.getView().getType() == InventoryType.CRAFTING || event.getView().getType() == InventoryType.PLAYER) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot move the Door Opener to chests or other containers!");
            return;
        }
    }

    private boolean handleGangList(Player player) {
        if (this.gangs.isEmpty()) {
            player.sendMessage("\u00a7cNo gangs exist yet!");
            return true;
        }
        player.sendMessage("\u00a76\u00a7lGangs:");
        for (Gang gang : this.gangs.values()) {
            String ownerName = Bukkit.getOfflinePlayer(gang.getOwner()).getName();
            player.sendMessage("\u00a7e" + gang.getName() + " \u00a77- Owner: \u00a7f" + ownerName + " \u00a77- Members: \u00a7f" + gang.getMembers().size());
        }
        return true;
    }

    private boolean handleGangInfo(Player player) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        player.sendMessage("\u00a76\u00a7lGang Info:");
        player.sendMessage("\u00a7eName: \u00a7f" + playerGang.getName());
        String ownerName = Bukkit.getOfflinePlayer(playerGang.getOwner()).getName();
        player.sendMessage("\u00a7cOwner: \u00a7f" + ownerName);
        player.sendMessage("\u00a7aMembers (" + playerGang.getMembers().size() + "):");
        for (UUID memberUUID : playerGang.getMembers()) {
            String memberName = Bukkit.getOfflinePlayer(memberUUID).getName();
            if (memberUUID.equals(playerGang.getOwner())) {
                player.sendMessage("\u00a7f\u2022 " + memberName + " \u00a74(Owner)");
                continue;
            }
            player.sendMessage("\u00a7f\u2022 " + memberName);
        }
        return true;
    }

    private boolean handleGangDisband(Player player) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        if (!playerGang.getOwner().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cOnly the owner can disband the gang!");
            return true;
        }
        String gangName = playerGang.getName();
        this.gangs.remove(gangName.toLowerCase());
        this.saveGangsToFile();
        player.sendMessage("\u00a7aDisbanded gang: " + gangName);
        for (UUID memberUUID : playerGang.getMembers()) {
            Player member;
            if (memberUUID.equals(player.getUniqueId()) || (member = Bukkit.getPlayer(memberUUID)) == null) continue;
            member.sendMessage("\u00a7cYour gang was disbanded by the owner!");
        }
        return true;
    }

    private boolean handleGangChat(Player player, String message) {
        Gang playerGang = this.getPlayerGang(player.getUniqueId());
        if (playerGang == null) {
            player.sendMessage("\u00a7cYou are not in a gang!");
            return true;
        }
        String formattedMessage = "\u00a78[\u00a7aGang\u00a78] \u00a7f" + player.getName() + "\u00a78: \u00a7f" + message;
        for (UUID memberUUID : playerGang.getMembers()) {
            Player member = Bukkit.getPlayer(memberUUID);
            if (member == null) continue;
            member.sendMessage(formattedMessage);
        }
        return true;
    }

    private Gang getPlayerGang(UUID playerUUID) {
        for (Gang gang : this.gangs.values()) {
            if (!gang.getMembers().contains(playerUUID)) continue;
            return gang;
        }
        return null;
    }

    public class Gang {
        private String name;
        private UUID owner;
        private List<UUID> members = new ArrayList<UUID>();

        public Gang(DefenceZ this$0, String name, UUID owner) {
            this.name = name;
            this.owner = owner;
            this.members.add(owner);
        }

        public String getName() {
            return this.name;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public void setOwner(UUID owner) {
            this.owner = owner;
        }

        public List<UUID> getMembers() {
            return this.members;
        }

        public void addMember(UUID uuid) {
            if (!this.members.contains(uuid)) {
                this.members.add(uuid);
            }
        }

        public void removeMember(UUID uuid) {
            this.members.remove(uuid);
        }
    }

    public class DefenseBlock {
        private Block block;
        private int level;
        private int maxHealth;
        private int currentHealth;
        private UUID owner;

        public DefenseBlock(DefenceZ this$0, Block block, int level, int maxHealth, UUID owner) {
            this.block = block;
            this.level = level;
            this.maxHealth = maxHealth;
            this.currentHealth = maxHealth;
            this.owner = owner;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getMaxHealth() {
            return this.maxHealth;
        }

        public void setMaxHealth(int maxHealth) {
            this.maxHealth = maxHealth;
        }

        public int getCurrentHealth() {
            return this.currentHealth;
        }

        public void setCurrentHealth(int currentHealth) {
            this.currentHealth = currentHealth;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public int damage(int damage) {
            this.currentHealth -= damage;
            return this.currentHealth;
        }
    }

    public class GangProtectedBlock
    extends DefenseBlock {
        private String gangName;

        public GangProtectedBlock(DefenceZ this$0, Block block, String gangName, UUID owner, int health) {
            super(this$0, block, 1, health, owner);
            this.gangName = gangName;
        }

        public String getGangName() {
            return this.gangName;
        }

        public void setGangName(String gangName) {
            this.gangName = gangName;
        }
    }
}

