/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.damage;

import com.google.common.base.Preconditions;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface DamageEffect {
    public static final DamageEffect HURT = DamageEffect.getDamageEffect("hurt");
    public static final DamageEffect THORNS = DamageEffect.getDamageEffect("thorns");
    public static final DamageEffect DROWNING = DamageEffect.getDamageEffect("drowning");
    public static final DamageEffect BURNING = DamageEffect.getDamageEffect("burning");
    public static final DamageEffect POKING = DamageEffect.getDamageEffect("poking");
    public static final DamageEffect FREEZING = DamageEffect.getDamageEffect("freezing");

    @NotNull
    private static DamageEffect getDamageEffect(@NotNull String key) {
        return Preconditions.checkNotNull(Bukkit.getUnsafe().getDamageEffect(key), "No DamageEffect found for %s. This is a bug.", (Object)key);
    }

    @NotNull
    public Sound getSound();
}

