/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.entrydenied.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.entrydenied.init.EntryDeniedModScreens;
import net.mcreator.entrydenied.network.ForgeryTableGUIButtonMessage;
import net.mcreator.entrydenied.world.inventory.ForgeryTableGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ForgeryTableGUIScreen
extends AbstractContainerScreen<ForgeryTableGUIMenu>
implements EntryDeniedModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox username;
    ImageButton imagebutton_forgerybutton;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"entry_denied:textures/screens/forgery_table_gui.png");

    public ForgeryTableGUIScreen(ForgeryTableGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("username")) {
                this.username.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.username.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (mouseX > this.leftPos + 68 && mouseX < this.leftPos + 168 && mouseY > this.topPos + 20 && mouseY < this.topPos + 43) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.entry_denied.forgery_table_gui.tooltip_username"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (mouseX > this.leftPos + 27 && mouseX < this.leftPos + 51 && mouseY > this.topPos + 20 && mouseY < this.topPos + 44) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.entry_denied.forgery_table_gui.tooltip_pink_passport_only111"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.username.isFocused()) {
            return this.username.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String usernameValue = this.username.getValue();
        super.resize(minecraft, width, height);
        this.username.setValue(usernameValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.username = new EditBox(this.font, this.leftPos + 70, this.topPos + 23, 96, 18, (Component)Component.translatable((String)"gui.entry_denied.forgery_table_gui.username"));
        this.username.setMaxLength(8192);
        this.username.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((ForgeryTableGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "username", content, false);
            }
        });
        this.username.setHint((Component)Component.translatable((String)"gui.entry_denied.forgery_table_gui.username"));
        this.addWidget((GuiEventListener)this.username);
        this.imagebutton_forgerybutton = new ImageButton(this, this.leftPos + 55, this.topPos + 56, 69, 24, new WidgetSprites(ResourceLocation.parse((String)"entry_denied:textures/screens/forgerybutton.png"), ResourceLocation.parse((String)"entry_denied:textures/screens/forgerybuttonselected.png")), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new ForgeryTableGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ForgeryTableGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_forgerybutton);
    }
}

