/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.entrydenied.network;

import net.mcreator.entrydenied.EntryDeniedMod;
import net.mcreator.entrydenied.procedures.IDIssuingProcedureProcedure;
import net.mcreator.entrydenied.procedures.OpenAccessPermitIssuerGUIProcedure;
import net.mcreator.entrydenied.procedures.OpenPassportIssuerGUIProcedure;
import net.mcreator.entrydenied.procedures.OpenVaxCertificateIssuerGUIProcedure;
import net.mcreator.entrydenied.procedures.OpenWorkPassIssuerGUIProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record IDIssuerGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<IDIssuerGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entry_denied", (String)"id_issuer_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, IDIssuerGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new IDIssuerGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<IDIssuerGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(IDIssuerGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> IDIssuerGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            IDIssuingProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            OpenPassportIssuerGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenAccessPermitIssuerGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenWorkPassIssuerGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenVaxCertificateIssuerGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EntryDeniedMod.addNetworkMessage(TYPE, STREAM_CODEC, IDIssuerGUIButtonMessage::handleData);
    }
}

