/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.entrydenied.network;

import net.mcreator.entrydenied.EntryDeniedMod;
import net.mcreator.entrydenied.procedures.AlarmProcedureProcedure;
import net.mcreator.entrydenied.procedures.FoghornProcedureProcedure;
import net.mcreator.entrydenied.procedures.NextCallProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SirenGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SirenGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entry_denied", (String)"siren_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SirenGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SirenGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SirenGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SirenGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SirenGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NextCallProcedureProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            FoghornProcedureProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            AlarmProcedureProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EntryDeniedMod.addNetworkMessage(TYPE, STREAM_CODEC, SirenGUIButtonMessage::handleData);
    }
}

