/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import io.github.fabricators_of_create.porting_lib.models.geometry.RegisterGeometryLoadersCallback;
import javax.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.common.CommonEventHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.CompatRegistry;
import net.p3pp3rf1y.sophisticatedcore.init.ModCompat;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.util.model.DynamicFluidContainerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SophisticatedCore
implements ModInitializer {
    public static final String MOD_ID = "sophisticatedcore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sophisticatedcore");
    public final CommonEventHandler commonEventHandler = new CommonEventHandler();
    private static MinecraftServer currentServer = null;

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean isLogicalServerThread() {
        String name = Thread.currentThread().getName();
        return name.startsWith("Server") || name.startsWith("Netty");
    }

    public void onInitialize() {
        NeoForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        NeoForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        this.commonEventHandler.registerHandlers();
        ModCompat.register();
        CompatRegistry.getRegistry(MOD_ID).initCompats();
        Config.COMMON.initListeners();
        ModCoreDataComponents.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            currentServer = server;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(SophisticatedCore::serverStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(SophisticatedCore::serverStopped);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)DatapackSettingsTemplateManager.Loader.INSTANCE);
        CompatRegistry.getRegistry(MOD_ID).setupCompats();
        RegisterGeometryLoadersCallback.EVENT.register(loaders -> loaders.put(SophisticatedCore.getRL("fluid_container"), DynamicFluidContainerModel.Loader.INSTANCE));
    }

    private static void serverStarted(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        if (world != null) {
            RecipeHelper.setLevel((class_1937)world);
            StorageWrapperRepository.clearCache();
            Config.COMMON.saveIfChanged();
        }
    }

    private static void serverStopped(MinecraftServer server) {
        StorageWrapperRepository.clearCache();
        currentServer = null;
    }

    public static class_2960 getRL(String regName) {
        return class_2960.method_60654((String)SophisticatedCore.getRegistryName(regName));
    }

    public static String getRegistryName(String regName) {
        return "sophisticatedcore:" + regName;
    }
}

