/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class CraftingContainerRecipeTransferHandlerServer {
    private CraftingContainerRecipeTransferHandlerServer() {
    }

    public static void setItems(class_1657 player, class_2960 recipeId, class_3956<?> recipeType, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase container = (StorageContainerMenuBase)class_17032;
        HashMap<Integer, class_1799> slotMap = new HashMap<Integer, class_1799>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            class_1735 slot = container.method_7611(entry.getValue());
            class_1799 slotStack = slot.method_7677();
            if (slotStack.method_7960()) {
                return;
            }
            class_1799 stack = slotStack.method_7972();
            stack.method_7939(1);
            slotMap.put(entry.getKey(), stack);
        }
        Map<Integer, class_1799> toTransfer = CraftingContainerRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        List<class_1799> clearedCraftingItems = CraftingContainerRecipeTransferHandlerServer.clearAndPutItemsIntoGrid(player, recipeId, recipeType, craftingSlots, container, toTransfer);
        CraftingContainerRecipeTransferHandlerServer.putIntoInventory(player, inventorySlots, container, clearedCraftingItems);
        container.method_7623();
    }

    private static void putIntoInventory(class_1657 player, List<Integer> inventorySlots, StorageContainerMenuBase<?> container, List<class_1799> clearedCraftingItems) {
        for (class_1799 oldCraftingItem : clearedCraftingItems) {
            int added = CraftingContainerRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.method_7947() || player.method_31548().method_7394(oldCraftingItem)) continue;
            player.method_7328(oldCraftingItem, false);
        }
    }

    private static List<class_1799> clearAndPutItemsIntoGrid(class_1657 player, class_2960 recipeId, class_3956<?> recipeType, List<Integer> craftingSlots, class_1703 container, Map<Integer, class_1799> toTransfer) {
        ArrayList<class_1799> clearedCraftingItems = new ArrayList<class_1799>();
        int minSlotStackLimit = Integer.MAX_VALUE;
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            class_1799 transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            class_1735 craftingSlot = container.method_7611(craftingSlotNumber);
            if (!craftingSlot.method_7674(player)) continue;
            if (craftingSlot.method_7681()) {
                class_1799 craftingItem = craftingSlot.method_7671(craftingSlot.method_7677().method_7947());
                clearedCraftingItems.add(craftingItem);
            }
            if ((transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.method_7676(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        CraftingContainerRecipeTransferHandlerServer.putItemIntoGrid(container, toTransfer, clearedCraftingItems, minSlotStackLimit);
        if (container instanceof StorageContainerMenuBase) {
            StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)container;
            storageContainerMenu.getOpenOrFirstCraftingContainer(recipeType).ifPresent(c -> ((ICraftingContainer)((Object)c)).setRecipeUsed(recipeId));
        }
        return clearedCraftingItems;
    }

    private static void putItemIntoGrid(class_1703 container, Map<Integer, class_1799> toTransfer, List<class_1799> clearedCraftingItems, int minSlotStackLimit) {
        for (Map.Entry<Integer, class_1799> entry : toTransfer.entrySet()) {
            class_1799 stack;
            Integer craftingSlotIndex = entry.getKey();
            class_1735 slot = container.method_7611(craftingSlotIndex.intValue());
            if (slot.method_7680(stack = entry.getValue())) {
                if (stack.method_7947() > minSlotStackLimit) {
                    class_1799 remainder = stack.method_7971(stack.method_7947() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.method_7673(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
    }

    private static Map<Integer, class_1799> removeItemsFromInventory(class_1657 player, StorageContainerMenuBase<?> container, Map<Integer, class_1799> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
        HashMap<Integer, class_1799> result;
        block7: {
            boolean noItemsFound;
            result = new HashMap<Integer, class_1799>(required.size());
            do {
                HashMap<class_1735, class_1799> originalSlotContents = new HashMap<class_1735, class_1799>();
                HashMap<Integer, class_1799> foundItemsInSet = new HashMap<Integer, class_1799>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, class_1799> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    class_1799 requiredStack = entry.getValue().method_7972();
                    class_1735 slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.method_7677().method_7960() && slot.method_7674(player);
                    class_1799 resultItemStack = (class_1799)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.method_7947() == resultItemStack.method_7914();
                    if (!itemFound || resultItemStackLimitReached) {
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            class_1799 stack = (class_1799)slotEntry.getValue();
                            ((class_1735)slotEntry.getKey()).method_7673(stack);
                        }
                        break block7;
                    }
                    if (!originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.method_7677().method_7972());
                    }
                    class_1799 removedItemStack = slot.method_7671(1);
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    class_1799 resultItemStack = (class_1799)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (class_1799)entry.getValue());
                        continue;
                    }
                    resultItemStack.method_7933(1);
                }
            } while (maxTransfer && !noItemsFound);
        }
        return result;
    }

    @Nullable
    private static class_1735 getSlotWithStack(StorageContainerMenuBase<?> container, class_1799 stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        class_1735 slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = CraftingContainerRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(StorageContainerMenuBase<?> container, Collection<Integer> slotIndexes, class_1799 stack) {
        class_1735 slot;
        class_1799 inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || (inventoryStack = (slot = container.method_7611(slotIndex)).method_7677()).method_7960() || !inventoryStack.method_7946() || !class_1799.method_31577((class_1799)inventoryStack, (class_1799)stack)) continue;
            int remain = stack.method_7947() - added;
            int maxStackSize = slot.method_7676(inventoryStack);
            int space = maxStackSize - inventoryStack.method_7947();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.method_7933(remain);
                return stack.method_7947();
            }
            inventoryStack.method_7939(maxStackSize);
            added += space;
        }
        if (added >= stack.method_7947()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !(inventoryStack = (slot = container.method_7611(slotIndex)).method_7677()).method_7960()) continue;
            class_1799 stackToAdd = stack.method_7972();
            stackToAdd.method_7939(stack.method_7947() - added);
            slot.method_7673(stackToAdd);
            return stack.method_7947();
        }
        return added;
    }

    @Nullable
    private static class_1735 getSlotWithStack(StorageContainerMenuBase<?> container, Iterable<Integer> slotNumbers, class_1799 itemStack) {
        for (Integer slotNumber : slotNumbers) {
            class_1735 slot;
            class_1799 slotStack;
            if (slotNumber < 0 || slotNumber >= CraftingContainerRecipeTransferHandlerServer.getTotalSlotsSize(container) || !class_1799.method_31577((class_1799)itemStack, (class_1799)(slotStack = (slot = container.method_7611(slotNumber)).method_7677()))) continue;
            return slot;
        }
        return null;
    }

    private static int getTotalSlotsSize(StorageContainerMenuBase<?> container) {
        return container.upgradeSlots.size() + container.realInventorySlots.size();
    }
}

