/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public record TransferItemsPayload(boolean transferToInventory, boolean filterByContents) implements class_8710
{
    public static final class_8710.class_9154<TransferItemsPayload> TYPE = new class_8710.class_9154(SophisticatedCore.getRL("transfer_items"));
    public static final class_9139<ByteBuf, TransferItemsPayload> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48547, TransferItemsPayload::transferToInventory, (class_9139)class_9135.field_48547, TransferItemsPayload::filterByContents, TransferItemsPayload::new);

    public static void handlePayload(TransferItemsPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)class_17032;
        Object storageWrapper = storageMenu.getStorageWrapper();
        if (payload.transferToInventory) {
            if (payload.filterByContents) {
                TransferItemsPayload.mergeToPlayersInventoryFiltered((class_1657)player, storageWrapper);
            } else {
                TransferItemsPayload.mergeToPlayersInventory(storageWrapper, (class_1657)player);
            }
        } else {
            InventoryHelper.transfer(new PlayerMainInvWithoutHotbarWrapper(player.method_31548()), new FilteredStorageItemHandler((IStorageWrapper)storageWrapper, payload.filterByContents), s -> {});
        }
    }

    private static void mergeToPlayersInventory(IStorageWrapper storageWrapper, class_1657 player) {
        InventoryHelper.iterate(storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            class_1799 result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 9);
            if (result.method_7947() != stack.method_7947()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    private static void mergeToPlayersInventoryFiltered(class_1657 player, IStorageWrapper storageWrapper) {
        Set<ItemStackKey> uniqueStacks = InventoryHelper.getUniqueStacks((Storage<ItemVariant>)new PlayerMainInvWrapper(player.method_31548()));
        InventoryHelper.iterate(storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.method_7960() || !uniqueStacks.contains(ItemStackKey.of(stack))) {
                return;
            }
            class_1799 result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 0);
            if (result.method_7947() != stack.method_7947()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    private static class PlayerMainInvWithoutHotbarWrapper
    extends RangedWrapper {
        private final class_1661 inventoryPlayer;

        public PlayerMainInvWithoutHotbarWrapper(class_1661 inv) {
            super(inv, 9, inv.field_7547.size());
            this.inventoryPlayer = inv;
        }

        @Override
        public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
            class_1799 inSlot;
            class_1799 rest = super.insertItem(slot, stack, simulate);
            if (rest.method_7947() != stack.method_7947() && !(inSlot = this.getStackInSlot(slot)).method_7960()) {
                if (this.getInventoryPlayer().field_7546.method_37908().field_9236) {
                    inSlot.method_7912(5);
                } else if (this.getInventoryPlayer().field_7546 instanceof class_3222) {
                    this.getInventoryPlayer().field_7546.field_7512.method_7623();
                }
            }
            return rest;
        }

        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1799 inSlot;
            long inserted = super.insertSlot(slot, resource, maxAmount, transaction);
            if (inserted != maxAmount && !(inSlot = this.getStackInSlot(slot)).method_7960()) {
                if (this.getInventoryPlayer().field_7546.method_37908().field_9236) {
                    inSlot.method_7912(5);
                } else if (this.getInventoryPlayer().field_7546 instanceof class_3222) {
                    this.getInventoryPlayer().field_7546.field_7512.method_7623();
                }
            }
            return 0L;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != maxAmount && !this.getInventoryPlayer().field_7546.method_37908().field_9236 && this.getInventoryPlayer().field_7546 instanceof class_3222) {
                this.getInventoryPlayer().field_7546.field_7512.method_7623();
            }
            return inserted;
        }

        public class_1661 getInventoryPlayer() {
            return this.inventoryPlayer;
        }
    }

    private static class FilteredStorageItemHandler
    extends FilteredItemHandler<ITrackedContentsItemHandler>
    implements IItemHandlerSimpleInserter {
        private final IStorageWrapper storageWrapper;

        public FilteredStorageItemHandler(IStorageWrapper storageWrapper, boolean smart) {
            super(storageWrapper.getInventoryHandler(), smart);
            this.storageWrapper = storageWrapper;
        }

        @Override
        protected Set<ItemStackKey> getUniqueStacks(ITrackedContentsItemHandler itemHandler) {
            return itemHandler.getTrackedStacks();
        }

        @Override
        protected boolean matchesFilter(class_1799 stack) {
            return super.matchesFilter(stack) || this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(stack);
        }

        @Override
        @Nonnull
        public class_1799 insertItem(class_1799 stack, boolean simulate) {
            if (!this.matchContents || this.matchesFilter(stack)) {
                return ((ITrackedContentsItemHandler)this.itemHandler).insertItem(stack, simulate);
            }
            return stack;
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack) {
            ((ITrackedContentsItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    private static class PlayerMainInvWrapper
    extends RangedWrapper {
        private final class_1661 inventoryPlayer;

        public PlayerMainInvWrapper(class_1661 inv) {
            super(inv, 0, inv.field_7547.size());
            this.inventoryPlayer = inv;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != maxAmount && !this.getInventoryPlayer().field_7546.method_37908().field_9236 && this.getInventoryPlayer().field_7546 instanceof class_3222) {
                this.getInventoryPlayer().field_7546.field_7512.method_7623();
            }
            return inserted;
        }

        public class_1661 getInventoryPlayer() {
            return this.inventoryPlayer;
        }
    }

    private static class RangedWrapper
    implements IItemHandlerSimpleInserter {
        private final InventoryStorageImpl inventoryStorage;

        public RangedWrapper(class_1661 inv, int start, int end) {
            this.inventoryStorage = (InventoryStorageImpl)InventoryStorage.of((class_1263)inv, null);
            this.inventoryStorage.parts = Collections.unmodifiableList(this.inventoryStorage.parts.subList(start, end));
        }

        public int getSlotCount() {
            return this.inventoryStorage.getSlotCount();
        }

        public SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return this.inventoryStorage.getSlot(slot);
        }

        public List<SingleSlotStorage<ItemVariant>> getSlots() {
            return this.inventoryStorage.parts;
        }

        public class_1799 getStackInSlot(int slot) {
            SingleSlotStorage<ItemVariant> s = this.getSlot(slot);
            return ((ItemVariant)s.getResource()).toStack((int)s.getAmount());
        }

        public void setStackInSlot(int slot, class_1799 stack) {
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.inventoryStorage.insert((Object)resource, maxAmount, transaction);
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.inventoryStorage.extract((Object)resource, maxAmount, transaction);
        }
    }

    private static class FilteredItemHandler<T extends IItemHandlerSimpleInserter>
    implements IItemHandlerSimpleInserter {
        protected final T itemHandler;
        protected final boolean matchContents;
        private final Set<ItemStackKey> uniqueStacks;

        public FilteredItemHandler(T itemHandler, boolean matchContents) {
            this.itemHandler = itemHandler;
            this.matchContents = matchContents;
            this.uniqueStacks = this.getUniqueStacks(itemHandler);
        }

        protected Set<ItemStackKey> getUniqueStacks(T itemHandler) {
            return InventoryHelper.getUniqueStacks(itemHandler);
        }

        public int getSlotCount() {
            return this.itemHandler.getSlotCount();
        }

        public SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return this.itemHandler.getSlot(slot);
        }

        @Nonnull
        public class_1799 getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, class_1799 stack) {
        }

        @Override
        @Nonnull
        public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
            if (!this.matchContents || this.matchesFilter(stack)) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected boolean matchesFilter(class_1799 stack) {
            return this.uniqueStacks.contains(ItemStackKey.of(stack));
        }

        @Override
        @Nonnull
        public class_1799 extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        @Override
        public boolean isItemValid(int slot, class_1799 stack) {
            return this.itemHandler.isItemValid(slot, stack);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }
    }
}

