/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.nosort;

import net.minecraft.class_1767;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;

public class NoSortSettingsContainer
extends SettingsContainerBase<NoSortSettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String COLOR_TAG = "color";

    public NoSortSettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, NoSortSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handlePacket(class_2487 data) {
        if (data.method_10545(ACTION_TAG)) {
            switch (data.method_10558(ACTION_TAG)) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        } else if (data.method_10545(SELECT_SLOT_TAG)) {
            this.selectSlot(data.method_10550(SELECT_SLOT_TAG));
        } else if (data.method_10545(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.method_10550(UNSELECT_SLOT_TAG));
        } else if (data.method_10545(COLOR_TAG)) {
            this.setColor(class_1767.method_7791((int)data.method_10550(COLOR_TAG)));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectSlot(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectAllSlots();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public void setColor(class_1767 color) {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.method_7789());
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((NoSortSettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }

    public class_1767 getColor() {
        return ((NoSortSettingsCategory)this.getCategory()).getColor();
    }
}

