/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.infinity;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartRegistry;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityInventoryPart;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;

public class InfinityUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(i -> true, 0, TranslationHelper.INSTANCE.translError("add.any_upgrade_exists", new Object[0]), TranslationHelper.INSTANCE.translError("add.no_upgrade_can_be_added", new Object[0])));
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);
    private final boolean admin;

    public InfinityUpgradeItem(IUpgradeCountLimitConfig upgradeTypeLimitConfig, boolean admin) {
        super(upgradeTypeLimitConfig);
        this.admin = admin;
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    @Override
    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide, class_1657 player) {
        if (player.method_5687(this.getPermissionLevel())) {
            return super.canRemoveUpgradeFrom(storageWrapper, isClientSide, player);
        }
        return UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("remove.infinity_upgrade_only_admin", new Object[0]), Set.of(), Set.of(), Set.of());
    }

    public int getPermissionLevel() {
        return this.admin ? 2 : 0;
    }

    public IInventoryPartHandler createInventoryPartHandler(InventoryHandler parent, SlotRange slotRange) {
        return this.admin ? new InfinityInventoryPart.Admin(parent, slotRange) : new InfinityInventoryPart.Survival(parent, slotRange);
    }

    static {
        InventoryPartRegistry.registerFactory("infinity", (parent, slotRange, getMemorySettings) -> new InfinityInventoryPart.Admin(parent, slotRange));
        InventoryPartRegistry.registerFactory("survival_infinity", (parent, slotRange, getMemorySettings) -> new InfinityInventoryPart.Survival(parent, slotRange));
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, InfinityUpgradeItem> {
        protected Wrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }

        @Override
        public boolean canBeDisabled() {
            return false;
        }

        @Override
        public void onAdded() {
            super.onAdded();
            InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
            inventoryHandler.getInventoryPartitioner().addInventoryPart(0, Integer.MAX_VALUE, ((InfinityUpgradeItem)this.upgradeItem).createInventoryPartHandler(inventoryHandler, new SlotRange(0, inventoryHandler.getSlotCount())));
            this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemsChanged();
        }

        @Override
        public void onBeforeRemoved() {
            super.onBeforeRemoved();
            this.storageWrapper.getInventoryHandler().getInventoryPartitioner().removeInventoryPart(0);
            this.save();
        }

        public int getPermissionLevel() {
            return ((InfinityUpgradeItem)this.upgradeItem).getPermissionLevel();
        }
    }
}

