/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.rei.subtypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyBasedSubtypeInterpreter
implements EntryComparator<class_1799> {
    private final List<IPropertyDefinition<?>> propertyDefinitions = new ArrayList();

    protected <T> void addOptionalProperty(Function<class_1799, Optional<T>> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        Function<class_1799, @Nullable Object> nullableGetter = propertyGetter.andThen(i -> i.orElse(null));
        this.addDefinition(nullableGetter, propertyName, propertyValueSerializer);
    }

    private <T> void addDefinition(final Function<class_1799, @Nullable T> getter, final String propertyName, final Function<T, String> propertyValueSerializer) {
        this.propertyDefinitions.add(new IPropertyDefinition<T>(){

            @Override
            @Nullable
            public T getPropertyValue(class_1799 itemStack) {
                return getter.apply(itemStack);
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }

            @Override
            public String serializePropertyValue(@Nullable T property) {
                return property != null ? (String)propertyValueSerializer.apply(property) : "";
            }
        });
    }

    protected <T> void addProperty(Function<class_1799, @Nullable T> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        this.addDefinition(propertyGetter, propertyName, propertyValueSerializer);
    }

    private <T> String getSerializedPropertyValue(IPropertyDefinition<T> definition, Object value) {
        return definition.serializePropertyValue(value);
    }

    public String getRegistrySanitizedItemString(class_1799 stack) {
        StringBuilder result = new StringBuilder();
        for (IPropertyDefinition<?> definition : this.propertyDefinitions) {
            @Nullable ? value = definition.getPropertyValue(stack);
            if (value == null) continue;
            String serializedValue = this.sanitize(this.getSerializedPropertyValue(definition, value));
            if (!result.isEmpty()) {
                result.append('_');
            }
            result.append(definition.getPropertyName().toLowerCase(Locale.ROOT)).append('_').append(serializedValue);
        }
        return PropertyBasedSubtypeInterpreter.getItemPath(stack) + "_" + String.valueOf(result);
    }

    private String sanitize(String value) {
        return value.replaceAll(":", "_").toLowerCase(Locale.ROOT);
    }

    @NotNull
    private static String getItemPath(class_1799 stack) {
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
    }

    public long hash(ComparisonContext context, class_1799 stack) {
        long hashCode = 1L;
        for (IPropertyDefinition<?> definition : this.propertyDefinitions) {
            @Nullable ? value = definition.getPropertyValue(stack);
            hashCode = 31L * hashCode + (long)(value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public static interface IPropertyDefinition<T> {
        @Nullable
        public T getPropertyValue(class_1799 var1);

        public String getPropertyName();

        public String serializePropertyValue(@Nullable T var1);
    }
}

