/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import org.jetbrains.annotations.Nullable;

public class RecipeHelper {
    private static final int MAX_FOLLOW_UP_COMPACTING_RECIPES = 30;
    private static RecipeCache clientCache;
    private static RecipeCache serverCache;

    private RecipeHelper() {
    }

    public static void setLevel(class_1937 l) {
        if (l instanceof class_3218) {
            serverCache = new RecipeCache(l);
        } else {
            clientCache = new RecipeCache(l);
        }
    }

    private static void runOnCache(Consumer<RecipeCache> consumer) {
        if (SophisticatedCore.isLogicalServerThread()) {
            if (serverCache != null) {
                consumer.accept(serverCache);
            }
        } else if (clientCache != null) {
            consumer.accept(clientCache);
        }
    }

    private static <T> T getFromCache(Function<RecipeCache, T> getter, T defaultValue) {
        if (SophisticatedCore.isLogicalServerThread()) {
            return serverCache == null ? defaultValue : getter.apply(serverCache);
        }
        return clientCache == null ? defaultValue : getter.apply(clientCache);
    }

    public static void addRecipeChangeListener(Runnable runnable) {
        RecipeHelper.runOnCache(cache -> cache.addRecipeChangeListener(runnable));
    }

    public static void onRecipesUpdated(class_1863 manager) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
    }

    public static void onDataPackSync(class_3222 serverPlayer, boolean b) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
    }

    private static Optional<class_1937> getLevel() {
        return RecipeHelper.getFromCache(cache -> Optional.ofNullable((class_1937)cache.level.get()), Optional.empty());
    }

    private static Set<CompactingShape> getCompactingShapes(class_1799 stack) {
        return RecipeHelper.getLevel().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            RecipeHelper.getCompactingShape(stack, w, 2, 2, CompactingShape.TWO_BY_TWO_UNCRAFTABLE, CompactingShape.TWO_BY_TWO).ifPresent(compactingShapes::add);
            RecipeHelper.getCompactingShape(stack, w, 3, 3, CompactingShape.THREE_BY_THREE_UNCRAFTABLE, CompactingShape.THREE_BY_THREE).ifPresent(compactingShapes::add);
            if (compactingShapes.isEmpty()) {
                compactingShapes.add(CompactingShape.NONE);
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static Optional<CompactingShape> getCompactingShape(class_1799 stack, class_1937 w, int width, int height, CompactingShape uncraftableShape, CompactingShape shape) {
        CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, w, width, height);
        if (!compactingResult.getResult().method_7960()) {
            if (class_1799.method_31577((class_1799)stack, (class_1799)compactingResult.getResult())) {
                return Optional.empty();
            }
            if (RecipeHelper.isPartOfCompactingLoop(stack, compactingResult.getResult(), w)) {
                return Optional.empty();
            }
            if (RecipeHelper.uncompactMatchesItem(compactingResult.getResult(), w, stack, width * height)) {
                return Optional.of(uncraftableShape);
            }
            return Optional.of(shape);
        }
        return Optional.empty();
    }

    private static boolean isPartOfCompactingLoop(class_1799 firstCompacted, class_1799 firstCompactResult, class_1937 w) {
        int iterations = 0;
        HashSet<Integer> compactedItemHashes = new HashSet<Integer>();
        LinkedList<class_1799> itemsToCompact = new LinkedList<class_1799>();
        itemsToCompact.add(firstCompactResult);
        while (!itemsToCompact.isEmpty()) {
            class_1799 itemToCompact = (class_1799)itemsToCompact.poll();
            class_1799 compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 2, 2).getResult();
            if (!compactingResultStack.method_7960()) {
                if (class_1799.method_31577((class_1799)compactingResultStack, (class_1799)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(class_1799.method_57355((class_1799)compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            if (!(compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 3, 3).getResult()).method_7960()) {
                if (class_1799.method_31577((class_1799)compactingResultStack, (class_1799)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(class_1799.method_57355((class_1799)compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            compactedItemHashes.add(class_1799.method_57355((class_1799)itemToCompact));
            if (++iterations <= 30) continue;
            return true;
        }
        return false;
    }

    private static boolean uncompactMatchesItem(class_1799 itemToUncompact, class_1937 w, class_1799 itemToMatch, int count) {
        for (class_1799 uncompactResult : RecipeHelper.getUncompactResultItems(w, itemToUncompact)) {
            if (!class_1799.method_31577((class_1799)uncompactResult, (class_1799)itemToMatch) || uncompactResult.method_7947() != count) continue;
            return true;
        }
        return false;
    }

    public static UncompactingResult getUncompactingResult(class_1799 uncompactedItem) {
        return RecipeHelper.getFromCache(cache -> cache.getUncompactingResults().computeIfAbsent(class_1799.method_57355((class_1799)uncompactedItem), k -> RecipeHelper.getLevel().map(w -> {
            for (class_1799 uncompactResultItem : RecipeHelper.getUncompactResultItems(w, uncompactedItem)) {
                if (uncompactResultItem.method_7947() == 9) {
                    if (!class_1799.method_31577((class_1799)RecipeHelper.getCompactingResult(uncompactResultItem, 3, 3).getResult(), (class_1799)uncompactedItem)) continue;
                    return new UncompactingResult(uncompactResultItem, CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
                }
                if (uncompactResultItem.method_7947() != 4 || !class_1799.method_31577((class_1799)RecipeHelper.getCompactingResult(uncompactResultItem, 2, 2).getResult(), (class_1799)uncompactedItem)) continue;
                return new UncompactingResult(uncompactResultItem, CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
            }
            return UncompactingResult.EMPTY;
        }).orElse(UncompactingResult.EMPTY)), UncompactingResult.EMPTY);
    }

    private static List<class_1799> getUncompactResultItems(class_1937 w, class_1799 itemToUncompact) {
        class_8566 craftingInventory = RecipeHelper.getFilledCraftingInventory(itemToUncompact, 1, 1);
        return RecipeHelper.safeGetRecipesFor(class_3956.field_17545, craftingInventory.method_59961(), w).stream().map(r -> ((class_3955)r.comp_1933()).method_8116((class_9695)craftingInventory.method_59961(), (class_7225.class_7874)w.method_30349())).toList();
    }

    public static CompactingResult getCompactingResult(class_1799 stack, CompactingShape shape) {
        if (shape == CompactingShape.TWO_BY_TWO_UNCRAFTABLE || shape == CompactingShape.TWO_BY_TWO) {
            return RecipeHelper.getCompactingResult(stack, 2, 2);
        }
        if (shape == CompactingShape.THREE_BY_THREE_UNCRAFTABLE || shape == CompactingShape.THREE_BY_THREE) {
            return RecipeHelper.getCompactingResult(stack, 3, 3);
        }
        return CompactingResult.EMPTY;
    }

    public static CompactingResult getCompactingResult(class_1799 stack, int width, int height) {
        return RecipeHelper.getLevel().map(w -> RecipeHelper.getCompactingResult(stack, w, width, height)).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(class_1799 stack, class_1937 level, int width, int height) {
        return RecipeHelper.getFromCache(cache -> RecipeHelper.getCompactingResult(stack, level, width, height, cache.getCompactingResults()), CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(class_1799 stack, class_1937 level, int width, int height, Map<CompactedItem, CompactingResult> cachedCompactingResults) {
        CompactedItem compactedItem = new CompactedItem(stack, width, height);
        if (cachedCompactingResults.containsKey(compactedItem)) {
            return cachedCompactingResults.get(compactedItem);
        }
        class_8566 craftingInventory = RecipeHelper.getFilledCraftingInventory(stack, width, height);
        List compactingRecipes = RecipeHelper.safeGetRecipesFor(class_3956.field_17545, craftingInventory.method_59961(), level);
        if (compactingRecipes.isEmpty()) {
            cachedCompactingResults.put(compactedItem, CompactingResult.EMPTY);
            return CompactingResult.EMPTY;
        }
        if (compactingRecipes.size() == 1) {
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, (class_3955)compactingRecipes.getFirst().comp_1933(), craftingInventory);
        }
        for (class_8786 recipeHolder : compactingRecipes) {
            class_3955 recipe = (class_3955)recipeHolder.comp_1933();
            class_1799 result = recipe.method_8116((class_9695)craftingInventory.method_59961(), (class_7225.class_7874)level.method_30349());
            if (!RecipeHelper.uncompactMatchesItem(result, level, stack, width * height)) continue;
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, result);
        }
        return RecipeHelper.cacheAndGetCompactingResult(compactedItem, (class_3955)compactingRecipes.getFirst().comp_1933(), craftingInventory);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, class_3955 recipe, class_8566 craftingInventory) {
        return RecipeHelper.getLevel().map(level -> RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, recipe.method_8116((class_9695)craftingInventory.method_59961(), (class_7225.class_7874)level.method_30349()))).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, class_3955 recipe, class_8566 craftingInventory, class_1799 result) {
        ArrayList<class_1799> remainingItems = new ArrayList<class_1799>();
        recipe.method_8111((class_9695)craftingInventory.method_59961()).forEach(stack -> {
            if (!stack.method_7960()) {
                remainingItems.add((class_1799)stack);
            }
        });
        CompactingResult compactingResult = new CompactingResult(result, remainingItems);
        return RecipeHelper.getFromCache(cache -> {
            if (!result.method_7960()) {
                cache.getCompactingResults().put(compactedItem, compactingResult);
            }
            return compactingResult;
        }, compactingResult);
    }

    private static class_8566 getFilledCraftingInventory(class_1799 stack, int width, int height) {
        class_1715 craftinginventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int index) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.method_5439(); ++i) {
            craftinginventory.method_5447(i, stack.method_46651(1));
        }
        return craftinginventory;
    }

    public static <T extends class_1874> Optional<class_8786<T>> getCookingRecipe(class_1799 stack, class_3956<T> recipeType) {
        return RecipeHelper.getLevel().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, new class_9696(stack), w, null));
    }

    public static Set<CompactingShape> getItemCompactingShapes(class_1799 stack) {
        return RecipeHelper.getFromCache(cache -> cache.getItemCompactingShapes(stack), Collections.emptySet());
    }

    public static <I extends class_9695, T extends class_1860<I>> List<class_8786<T>> getRecipesOfType(class_3956<T> recipeType, I inventory) {
        return RecipeHelper.getLevel().map(w -> w.method_8433().method_17877(recipeType, inventory, w)).orElse(Collections.emptyList());
    }

    public static <I extends class_9695, T extends class_1860<I>> Optional<class_8786<T>> safeGetRecipeFor(class_3956<T> recipeType, I inventory, @Nullable class_2960 recipeId) {
        return RecipeHelper.getLevel().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, inventory, w, recipeId));
    }

    public static <I extends class_9695, T extends class_1860<I>> Optional<class_8786<T>> safeGetRecipeFor(class_3956<T> recipeType, I inventory, class_1937 level, @Nullable class_2960 recipeId) {
        try {
            return level.method_8433().method_42299(recipeType, inventory, level, recipeId);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <I extends class_9694, T extends class_1860<I>> List<class_8786<T>> safeGetRecipesFor(class_3956<T> recipeType, I inventory, class_1937 level) {
        try {
            return level.method_8433().method_17877(recipeType, inventory, level);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static class RecipeCache {
        private final Cache<Integer, Set<CompactingShape>> itemCompactingShapes = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        private final Map<CompactedItem, CompactingResult> compactingResults = new HashMap<CompactedItem, CompactingResult>();
        private final Map<Integer, UncompactingResult> uncompactingResults = new HashMap<Integer, UncompactingResult>();
        private final RecipeChangeListenerList recipeChangeListeners = new RecipeChangeListenerList();
        private final WeakReference<class_1937> level;

        public RecipeCache(class_1937 level) {
            this.level = new WeakReference<class_1937>(level);
        }

        public void addRecipeChangeListener(Runnable runnable) {
            this.recipeChangeListeners.add(runnable);
        }

        public Map<Integer, UncompactingResult> getUncompactingResults() {
            return this.uncompactingResults;
        }

        public Map<CompactedItem, CompactingResult> getCompactingResults() {
            return this.compactingResults;
        }

        public Set<CompactingShape> getItemCompactingShapes(class_1799 stack) {
            int hash = class_1799.method_57355((class_1799)stack);
            Set<CompactingShape> compactingShapes = (Set<CompactingShape>)this.itemCompactingShapes.getIfPresent((Object)hash);
            if (compactingShapes == null) {
                SophisticatedCore.LOGGER.debug("Compacting shapes not found in cache for \"{}\" - querying recipes to get these", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()));
                compactingShapes = RecipeHelper.getCompactingShapes(stack);
                this.itemCompactingShapes.put((Object)hash, compactingShapes);
            }
            return compactingShapes;
        }

        private void clearCache() {
            this.compactingResults.clear();
            this.uncompactingResults.clear();
            this.itemCompactingShapes.invalidateAll();
        }
    }

    public static class CompactingResult {
        public static final CompactingResult EMPTY = new CompactingResult(class_1799.field_8037, Collections.emptyList());
        private final class_1799 result;
        private final List<class_1799> remainingItems;

        public CompactingResult(class_1799 result, List<class_1799> remainingItems) {
            this.result = result;
            this.remainingItems = remainingItems;
        }

        public class_1799 getResult() {
            return this.result;
        }

        public List<class_1799> getRemainingItems() {
            return this.remainingItems;
        }
    }

    public static class UncompactingResult {
        public static final UncompactingResult EMPTY = new UncompactingResult(class_1799.field_8037, CompactingShape.NONE);
        private final class_1799 result;
        private final CompactingShape compactUsingShape;

        public UncompactingResult(class_1799 result, CompactingShape compactUsingShape) {
            this.result = result.method_46651(1);
            this.compactUsingShape = compactUsingShape;
        }

        public class_1799 getResult() {
            return this.result;
        }

        public CompactingShape getCompactUsingShape() {
            return this.compactUsingShape;
        }
    }

    public static enum CompactingShape {
        NONE(false, 0),
        THREE_BY_THREE(false, 9),
        TWO_BY_TWO(false, 4),
        THREE_BY_THREE_UNCRAFTABLE(true, 9),
        TWO_BY_TWO_UNCRAFTABLE(true, 4);

        private final int numberOfIngredients;
        private final boolean uncraftable;

        private CompactingShape(boolean uncraftable, int numberOfIngredients) {
            this.uncraftable = uncraftable;
            this.numberOfIngredients = numberOfIngredients;
        }

        public boolean isUncraftable() {
            return this.uncraftable;
        }

        public int getNumberOfIngredients() {
            return this.numberOfIngredients;
        }
    }

    private static class CompactedItem {
        private final class_1799 item;
        private final int itemHash;
        private final int width;
        private final int height;

        private CompactedItem(class_1799 item, int width, int height) {
            this.item = item.method_46651(1);
            this.width = width;
            this.height = height;
            this.itemHash = class_1799.method_57355((class_1799)item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactedItem that = (CompactedItem)o;
            return this.width == that.width && this.height == that.height && class_1799.method_31577((class_1799)this.item, (class_1799)that.item);
        }

        public int hashCode() {
            return Objects.hash(this.itemHash, this.width, this.height);
        }
    }

    private static class RecipeChangeListenerList {
        private final List<WeakReference<Runnable>> list = Collections.synchronizedList(new ArrayList());

        private RecipeChangeListenerList() {
        }

        public void add(Runnable runnable) {
            this.list.add(new WeakReference<Runnable>(runnable));
        }

        public void notifyAllListeners() {
            this.list.removeIf(ref -> {
                Runnable runnable = (Runnable)ref.get();
                if (runnable != null) {
                    runnable.run();
                    return false;
                }
                return true;
            });
        }
    }
}

