/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.mojang.datafixers.util.Function9;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_8703;
import net.minecraft.class_9139;
import net.p3pp3rf1y.sophisticatedcore.util.EnumStreamCodec;
import org.jetbrains.annotations.Nullable;

public class StreamCodecHelper {
    public static final class_9139<ByteBuf, class_2680> BLOCKSTATE = new class_9139<ByteBuf, class_2680>(){

        public void encode(ByteBuf buffer, class_2680 state) {
            class_8703.method_53017((ByteBuf)buffer, (int)class_2248.method_9507((class_2680)state));
        }

        public class_2680 decode(ByteBuf pBuffer) {
            return class_2248.method_9531((int)class_8703.method_53016((ByteBuf)pBuffer));
        }
    };

    private StreamCodecHelper() {
    }

    public static <B extends class_2540, T> class_9139<B, class_6862<T>> ofTagkey(final class_5321<? extends class_2378<T>> registry) {
        return new class_9139<B, class_6862<T>>(){

            public void encode(B buffer, class_6862<T> value) {
                buffer.method_10812(value.comp_327());
            }

            public class_6862<T> decode(B buffer) {
                return class_6862.method_40092((class_5321)registry, (class_2960)buffer.method_10810());
            }
        };
    }

    public static <B extends ByteBuf, V> class_9139<B, V> ofNullable(final class_9139<B, V> streamCodec) {
        return new class_9139<B, V>(){

            @Nullable
            public V decode(B buf) {
                return buf.readBoolean() ? streamCodec.decode(buf) : null;
            }

            public void encode(B buf, @Nullable V value) {
                buf.writeBoolean(value != null);
                if (value != null) {
                    streamCodec.encode(buf, value);
                }
            }
        };
    }

    public static <B extends ByteBuf, V> class_9139<B, V> singleton(final Supplier<V> instantiator) {
        return new class_9139<B, V>(){

            public V decode(B p_320376_) {
                return instantiator.get();
            }

            public void encode(B p_320158_, V p_320396_) {
            }
        };
    }

    public static <B extends ByteBuf, E, V extends Collection<E>> class_9139<B, V> ofCollection(final class_9139<B, E> elementStreamCodec, final Supplier<V> instantiator) {
        return new class_9139<B, V>(){

            public V decode(B buf) {
                int size = buf.readInt();
                Collection collection = (Collection)instantiator.get();
                for (int i = 0; i < size; ++i) {
                    collection.add(elementStreamCodec.decode(buf));
                }
                return collection;
            }

            public void encode(B buf, V collection) {
                buf.writeInt(collection.size());
                for (Object element : collection) {
                    elementStreamCodec.encode(buf, element);
                }
            }
        };
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> class_9139<B, M> ofMap(final class_9139<? super B, K> keyStreamCodec, final class_9139<? super B, V> valueStreamCodec, final Supplier<M> instantiator) {
        return new class_9139<B, M>(){

            public M decode(B buf) {
                int size = buf.readInt();
                Map map = (Map)instantiator.get();
                for (int i = 0; i < size; ++i) {
                    map.put(keyStreamCodec.decode(buf), valueStreamCodec.decode(buf));
                }
                return map;
            }

            public void encode(B buf, M map) {
                buf.writeInt(map.size());
                map.forEach((k, v) -> {
                    keyStreamCodec.encode(buf, k);
                    valueStreamCodec.encode(buf, v);
                });
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> class_9139<B, C> composite(final class_9139<? super B, T1> pCodec1, final Function<C, T1> pGetter1, final class_9139<? super B, T2> pCodec2, final Function<C, T2> pGetter2, final class_9139<? super B, T3> pCodec3, final Function<C, T3> pGetter3, final class_9139<? super B, T4> pCodec4, final Function<C, T4> pGetter4, final class_9139<? super B, T5> pCodec5, final Function<C, T5> pGetter5, final class_9139<? super B, T6> pCodec6, final Function<C, T6> pGetter6, final class_9139<? super B, T7> pCodec7, final Function<C, T7> pGetter7, final class_9139<? super B, T8> pCodec8, final Function<C, T8> pGetter8, final class_9139<? super B, T9> pCodec9, final Function<C, T9> pGetter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> pFactory) {
        return new class_9139<B, C>(){

            public C decode(B buffer) {
                Object t1 = pCodec1.decode(buffer);
                Object t2 = pCodec2.decode(buffer);
                Object t3 = pCodec3.decode(buffer);
                Object t4 = pCodec4.decode(buffer);
                Object t5 = pCodec5.decode(buffer);
                Object t6 = pCodec6.decode(buffer);
                Object t7 = pCodec7.decode(buffer);
                Object t8 = pCodec8.decode(buffer);
                Object t9 = pCodec9.decode(buffer);
                return pFactory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            public void encode(B buffer, C value) {
                pCodec1.encode(buffer, pGetter1.apply(value));
                pCodec2.encode(buffer, pGetter2.apply(value));
                pCodec3.encode(buffer, pGetter3.apply(value));
                pCodec4.encode(buffer, pGetter4.apply(value));
                pCodec5.encode(buffer, pGetter5.apply(value));
                pCodec6.encode(buffer, pGetter6.apply(value));
                pCodec7.encode(buffer, pGetter7.apply(value));
                pCodec8.encode(buffer, pGetter8.apply(value));
                pCodec9.encode(buffer, pGetter9.apply(value));
            }
        };
    }

    public static <T extends Enum<T>> EnumStreamCodec<T> enumCodec(Class<T> enumClass) {
        return new EnumStreamCodec<T>(enumClass);
    }
}

