/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import java.util.Collections;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5632;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.compat.litematica.network.LitematicaPacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientEventHandler
implements ClientModInitializer {
    public void onInitializeClient() {
        ModParticles.registerFactories();
        ModFluids.registerFluids();
        ServerWorldEvents.UNLOAD.register(StorageSoundHandler::onWorldUnload);
        ClientTickEvents.END_WORLD_TICK.register(StorageSoundHandler::tick);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> RecipeHelper.setWorld((class_1937)client.field_1687));
        ScreenEvents.BEFORE_INIT.register((client, screen, windowWidth, windowHeight) -> {
            block3: {
                block2: {
                    if (!(screen instanceof class_465)) break block2;
                    class_465 containerGui = (class_465)screen;
                    if (!(screen instanceof class_481) && client.field_1724 != null) break block3;
                }
                return;
            }
            ScreenEvents.afterRender((class_437)screen).register(ClientEventHandler::onDrawScreen);
        });
        PacketHandler.getChannel().initClientListener();
        LitematicaPacketHandler.getChannel().initClientListener();
    }

    private static void onDrawScreen(class_437 screen, class_4587 poseStack, int mouseX, int mouseY, float tickDelta) {
        class_310 mc = Screens.getClient((class_437)screen);
        class_465 containerGui = (class_465)screen;
        class_1703 menu = containerGui.method_17577();
        class_1799 held = menu.method_34255();
        if (!held.method_7960()) {
            class_1735 under = GuiHelper.getSlotUnderMouse(containerGui).orElse(null);
            for (class_1735 s : menu.field_7761) {
                Optional<StashResultAndTooltip> stashResultAndTooltip;
                class_1799 stack = s.method_7677();
                if (!s.method_7674((class_1657)mc.field_1724) || stack.method_7960() || (stashResultAndTooltip = ClientEventHandler.getStashResultAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(mc, containerGui, poseStack, mouseX, mouseY, stashResultAndTooltip.get());
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, poseStack, s, stack, stashResultAndTooltip.get().stashResult());
            }
        }
    }

    private static void renderStashSign(class_310 mc, class_465<?> containerGui, class_4587 poseStack, class_1735 s, class_1799 stack, IStashStorageItem.StashResult stashResult) {
        int color;
        int x = containerGui.getGuiLeft() + s.field_7873;
        int y = containerGui.getGuiTop() + s.field_7872;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 300.0f);
        int n = color = stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? class_124.field_1060.method_532() : 0xFFFF00;
        if (stack.method_7909() instanceof IStashStorageItem) {
            mc.field_1772.method_1720(poseStack, "+", (float)x + 10.0f, (float)y + 8.0f, color);
        } else {
            mc.field_1772.method_1720(poseStack, "-", (float)(x + 1), (float)y, color);
        }
        poseStack.method_22909();
    }

    private static void renderSpecialTooltip(class_310 mc, class_465<?> containerGui, class_4587 poseStack, int mouseX, int mouseY, StashResultAndTooltip stashResultAndTooltip) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, containerGui instanceof StorageScreenBase ? -100.0f : 100.0f);
        containerGui.method_32634(poseStack, Collections.singletonList(class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashResultAndTooltip.tooltip(), mouseX, mouseY);
        poseStack.method_22909();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(class_1799 inInventory, class_1799 held) {
        class_1792 class_17922;
        if (inInventory.method_7947() == 1 && (class_17922 = inInventory.method_7909()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)class_17922;
            return ClientEventHandler.getStashResultAndTooltip(inInventory, held, stashStorageItem);
        }
        class_17922 = held.method_7909();
        if (class_17922 instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)class_17922;
            return ClientEventHandler.getStashResultAndTooltip(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(class_1799 potentialStashStorage, class_1799 potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable(potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(new StashResultAndTooltip(stashResult, stashStorageItem.getInventoryTooltip(potentialStashStorage)));
    }

    private record StashResultAndTooltip(IStashStorageItem.StashResult stashResult, Optional<class_5632> tooltip) {
    }
}

