/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.TemplatePersistanceControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.settings.StorageSettingsTabControlBase;

public abstract class SettingsScreen
extends class_465<SettingsContainerMenu<?>>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private StorageSettingsTabControlBase settingsTabControl;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private TemplatePersistanceControl templatePersistanceControl = null;
    private StorageBackgroundProperties storageBackgroundProperties;
    private boolean mouseDragHandledByOther = false;

    protected SettingsScreen(SettingsContainerMenu<?> screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.updateDimensionsAndSlotPositions(class_310.method_1551().method_22683().method_4502());
    }

    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        this.updateDimensionsAndSlotPositions(pHeight);
        super.method_25410(pMinecraft, pWidth, pHeight);
    }

    private void updateDimensionsAndSlotPositions(int pHeight) {
        int displayableNumberOfRows = Math.min((pHeight - 114) / 18, ((SettingsContainerMenu)this.method_17577()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((SettingsContainerMenu)this.method_17577()).getNumberOfStorageInventorySlots() + ((SettingsContainerMenu)this.method_17577()).getColumnsTaken() * ((SettingsContainerMenu)this.method_17577()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.field_2792 = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((SettingsContainerMenu)this.method_17577()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.field_2792 += 6;
        }
        this.field_2779 = newImageHeight;
        this.field_25270 = this.field_2779 - 94;
        this.field_25269 = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.method_37066((class_364)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((SettingsContainerMenu)this.method_17577()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(class_310.method_1551(), this, 0, ((SettingsContainerMenu)this.method_17577()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.method_37063((class_364)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsYPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.field_2779 - 114) / 18, ((SettingsContainerMenu)this.method_17577()).getNumberOfRows());
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        int slotIndex = 0;
        while (slotIndex < ((SettingsContainerMenu)this.method_17577()).getNumberOfStorageInventorySlots()) {
            class_1735 slot = ((SettingsContainerMenu)this.method_17577()).method_7611(slotIndex);
            int lineIndex = slotIndex % this.getSlotsOnLine();
            slot.field_7873 = 8 + lineIndex * 18;
            slot.field_7872 = yPosition;
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((SettingsContainerMenu)this.method_17577()).getColumnsTaken();
    }

    protected void method_25426() {
        super.method_25426();
        this.updateInventoryScrollPanel();
        this.settingsTabControl = this.initializeTabControl();
        this.templatePersistanceControl = this.initializeTemplatePersistanceControl();
        this.method_25429(this.settingsTabControl);
        this.method_25429(this.templatePersistanceControl);
    }

    private TemplatePersistanceControl initializeTemplatePersistanceControl() {
        return new TemplatePersistanceControl(new Position(this.field_2776 + this.field_25269 - 29, this.field_2800 + this.field_25270 + 29), ((SettingsContainerMenu)this.method_17577()).getTemplatePersistanceContainer());
    }

    protected abstract StorageSettingsTabControlBase initializeTabControl();

    protected void method_2389(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        StorageGuiHelper.renderStorageBackground(new Position(x, y), matrixStack, this.storageBackgroundProperties.getTextureName(), this.field_2792, this.getStorageInventoryHeight(this.getNumberOfVisibleRows()));
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(matrixStack, x, y);
        }
    }

    protected void drawSlotBg(class_4587 matrixStack, int x, int y) {
        int inventorySlots = ((SettingsContainerMenu)this.method_17577()).getStorageInventorySlots().size();
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = inventorySlots / slotsOnLine;
        int remainingSlots = inventorySlots % slotsOnLine;
        GuiHelper.renderSlotsBackground(matrixStack, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((SettingsContainerMenu)this.field_2797).detectSettingsChangeAndReload();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, -20.0f);
        this.method_25420(matrixStack);
        matrixStack.method_22909();
        this.settingsTabControl.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.templatePersistanceControl.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((class_437)this, matrixStack, mouseX, mouseY);
        this.templatePersistanceControl.renderTooltip((class_437)this, matrixStack, mouseX, mouseY);
        this.method_2380(matrixStack, mouseX, mouseY);
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        super.method_2388(matrixStack, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderInventorySlots(matrixStack, mouseX, mouseY, true);
        }
    }

    @Override
    public void renderInventorySlots(class_4587 matrixStack, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((SettingsContainerMenu)this.field_2797).ghostSlots.size(); ++slotId) {
            class_1735 slot = ((SettingsContainerMenu)this.field_2797).ghostSlots.get(slotId);
            this.method_2385(matrixStack, slot);
            this.settingsTabControl.renderSlotOverlays(matrixStack, slot, this::renderSlotOverlay, this.isTemplateLoadHovered());
            if (canShowHover && this.method_2387(slot, mouseX, mouseY) && slot.method_7682()) {
                this.field_2787 = slot;
                this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
            }
            this.settingsTabControl.renderSlotExtra(matrixStack, slot);
        }
    }

    protected void method_2385(class_4587 poseStack, class_1735 slot) {
        class_1799 itemstack = slot.method_7677() != class_1799.field_8037 ? slot.method_7677() : this.settingsTabControl.getSlotStackDisplayOverride(slot.method_34266(), this.isTemplateLoadHovered());
        RenderSystem.enableDepthTest();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        if (!this.settingsTabControl.renderGuiItem(poseStack, this.field_22788, itemstack, slot, this.isTemplateLoadHovered())) {
            if (!((SettingsContainerMenu)this.method_17577()).getSlotFilterItem(slot.method_34266()).method_7960()) {
                this.field_22788.method_4023(poseStack, ((SettingsContainerMenu)this.method_17577()).getSlotFilterItem(slot.method_34266()), slot.field_7873, slot.field_7872);
            } else {
                Pair pair = slot.method_7679();
                if (pair != null) {
                    class_1058 textureatlassprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)textureatlassprite.method_45852());
                    SettingsScreen.method_25298((class_4587)poseStack, (int)slot.field_7873, (int)slot.field_7872, (int)0, (int)16, (int)16, (class_1058)textureatlassprite);
                }
            }
        }
        poseStack.method_22909();
        this.settingsTabControl.drawSlotStackOverlay(poseStack, slot, this.isTemplateLoadHovered());
    }

    private boolean isTemplateLoadHovered() {
        return this.templatePersistanceControl.isTemplateLoadHovered();
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, mouseButton);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.mouseDragHandledByOther) {
            return false;
        }
        class_1735 slot = this.method_2386(mouseX, mouseY);
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, button);
        }
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Nullable
    public class_1735 method_2386(double mouseX, double mouseY) {
        for (int i = 0; i < ((SettingsContainerMenu)this.field_2797).ghostSlots.size(); ++i) {
            class_1735 slot = ((SettingsContainerMenu)this.field_2797).ghostSlots.get(i);
            if (!this.method_2387(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.method_3318((int)mouseX, (int)mouseY));
    }

    private void renderSlotOverlay(class_4587 matrixStack, class_1735 slot, int slotColor) {
        this.renderSlotOverlay(matrixStack, slot.field_7873, slot.field_7872, 16, slotColor);
    }

    private void renderSlotOverlay(class_4587 matrixStack, int xPos, int yPos, int height, int slotColor) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        SettingsScreen.method_25296((class_4587)matrixStack, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + height), (int)slotColor, (int)slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.sendStorageInventoryScreenOpenMessage();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected abstract void sendStorageInventoryScreenOpenMessage();

    public StorageSettingsTabControlBase getSettingsTabControl() {
        return this.settingsTabControl;
    }

    @Override
    public boolean isMouseOverSlot(class_1735 pSlot, double pMouseX, double pMouseY) {
        return this.method_2387(pSlot, pMouseX, pMouseY);
    }

    @Override
    public void drawSlotBg(class_4587 matrixStack) {
        this.drawSlotBg(matrixStack, (this.field_22789 - this.field_2792) / 2, (this.field_22790 - this.field_2779) / 2);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    @Override
    public class_1735 getSlot(int slotIndex) {
        return ((SettingsContainerMenu)this.method_17577()).method_7611(slotIndex);
    }

    public void startMouseDragHandledByOther() {
        this.mouseDragHandledByOther = true;
    }

    public void stopMouseDragHandledByOther() {
        this.mouseDragHandledByOther = false;
    }
}

