/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;

public abstract class Tab
extends CompositeWidgetBase<WidgetBase> {
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    public static final int DEFAULT_HEIGHT = 24;
    protected static final int DEFAULT_WIDTH = 21;
    private int width = 21;
    private int height = 24;
    private final List<class_2561> tooltip;
    private BooleanSupplier shouldShowTooltip = () -> true;
    protected BooleanSupplier shouldRender = () -> true;

    protected Tab(Position position, List<class_2561> tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position, new Dimension(0, 0));
        this.tooltip = tooltip;
        this.addChild(getTabButton.apply(this::onTabIconClicked));
    }

    protected Tab(Position position, class_2561 tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        this(position, List.of(tooltip), getTabButton);
    }

    public void setHandlers(BooleanSupplier shouldShowTooltip, BooleanSupplier shouldRender) {
        this.shouldShowTooltip = shouldShowTooltip;
        this.shouldRender = shouldRender;
    }

    @Override
    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.getAsBoolean()) {
            return;
        }
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderTooltip(class_437 screen, class_4587 poseStack, int mouseX, int mouseY) {
        super.renderTooltip(screen, poseStack, mouseX, mouseY);
        if (this.shouldRender.getAsBoolean() && this.isClosedTooltipVisible(mouseX, mouseY)) {
            screen.method_32634(poseStack, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Optional<class_768> getTabRectangle() {
        return GuiHelper.getPositiveRectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected void renderBg(class_4587 matrixStack, class_310 minecraft, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)GuiHelper.GUI_CONTROLS);
        int halfHeight = this.height / 2;
        Tab.method_25290((class_4587)matrixStack, (int)this.x, (int)this.y, (float)(256.0f - (float)this.width), (float)0.0f, (int)this.width, (int)halfHeight, (int)256, (int)256);
        Tab.method_25290((class_4587)matrixStack, (int)this.x, (int)(this.y + halfHeight), (float)(256.0f - (float)this.width), (float)(256.0f - (float)halfHeight), (int)this.width, (int)halfHeight, (int)256, (int)256);
        Tab.method_25302((class_4587)matrixStack, (int)(this.x - 3), (int)this.y, (int)128, (int)(256 - this.height), (int)3, (int)this.height);
    }

    protected boolean isClosedTooltipVisible(int mouseX, int mouseY) {
        return this.shouldShowTooltip.getAsBoolean() && this.method_25405(mouseX, mouseY);
    }

    public int getTopY() {
        return this.y;
    }

    public int getBottomY() {
        return this.y + this.getHeight();
    }

    protected abstract void onTabIconClicked(int var1);

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 pNarrationElementOutput) {
    }
}

