/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ScrollPanel;

public class InventoryScrollPanel
extends ScrollPanel {
    private static final int TOP_Y_OFFSET = 1;
    private final IInventoryScreen screen;
    private final int firstSlotIndex;
    private final int numberOfSlots;
    private final int slotsInARow;

    public InventoryScrollPanel(class_310 client, IInventoryScreen screen, int firstSlotIndex, int numberOfSlots, int slotsInARow, int height, int top, int left) {
        super(client, slotsInARow * 18 + 6, height, top, left, 0);
        this.screen = screen;
        this.firstSlotIndex = firstSlotIndex;
        this.numberOfSlots = numberOfSlots;
        this.slotsInARow = slotsInARow;
    }

    @Override
    protected int getScrollAmount() {
        return 18;
    }

    @Override
    protected int getContentHeight() {
        int rows = this.numberOfSlots / this.slotsInARow + (this.numberOfSlots % this.slotsInARow > 0 ? 1 : 0);
        return rows * 18;
    }

    @Override
    protected void drawBackground(class_4587 poseStack, class_289 tess, float partialTick) {
        this.screen.drawSlotBg(poseStack);
    }

    @Override
    protected void drawPanel(class_4587 poseStack, int entryRight, int relativeY, class_289 tess, int mouseX, int mouseY) {
        poseStack.method_22903();
        poseStack.method_22904((double)this.screen.getLeftX(), (double)this.screen.getTopY(), 0.0);
        this.screen.renderInventorySlots(poseStack, mouseX, mouseY, this.method_25405(mouseX, mouseY));
        poseStack.method_22909();
    }

    public Optional<class_1735> findSlot(double mouseX, double mouseY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return Optional.empty();
        }
        for (int slotIndex = this.firstSlotIndex; slotIndex < this.firstSlotIndex + this.numberOfSlots; ++slotIndex) {
            class_1735 slot = this.screen.getSlot(slotIndex);
            if (!this.screen.isMouseOverSlot(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 pNarrationElementOutput) {
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        boolean ret = super.method_25401(mouseX, mouseY, scroll);
        this.updateSlotsYPosition();
        return ret;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean ret = super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        this.updateSlotsYPosition();
        return ret;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public void updateSlotsYPosition() {
        int i = this.firstSlotIndex;
        int row = 0;
        while (i < this.firstSlotIndex + this.numberOfSlots) {
            int newY = this.top - this.screen.getTopY() - (int)this.scrollDistance / 18 * 18 + row * 18 + 1;
            if (newY < -17 || newY > this.height) {
                newY = -100;
            }
            this.screen.getSlot((int)i).field_7872 = newY;
            row = ++i / this.slotsInARow;
        }
    }

    public static interface IInventoryScreen {
        public void renderInventorySlots(class_4587 var1, int var2, int var3, boolean var4);

        public boolean isMouseOverSlot(class_1735 var1, double var2, double var4);

        public void drawSlotBg(class_4587 var1);

        public int getTopY();

        public int getLeftX();

        public class_1735 getSlot(int var1);
    }
}

