/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public abstract class ScrollPanel
extends class_362
implements class_4068,
class_6379 {
    private final class_310 client;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    private boolean scrolling;
    protected float scrollDistance;
    protected boolean captureMouse = true;
    protected final int border;
    private final int barWidth;
    private final int barLeft;
    private final int bgColorFrom;
    private final int bgColorTo;
    private final int barBgColor;
    private final int barColor;
    private final int barBorderColor;

    public ScrollPanel(class_310 client, int width, int height, int top, int left) {
        this(client, width, height, top, left, 4);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border) {
        this(client, width, height, top, left, border, 6);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth) {
        this(client, width, height, top, left, border, barWidth, -1072689136, -804253680);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth, int bgColor) {
        this(client, width, height, top, left, border, barWidth, bgColor, bgColor);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth, int bgColorFrom, int bgColorTo) {
        this(client, width, height, top, left, border, barWidth, bgColorFrom, bgColorTo, -16777216, -8355712, -4144960);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth, int bgColorFrom, int bgColorTo, int barBgColor, int barColor, int barBorderColor) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - barWidth;
        this.border = border;
        this.barWidth = barWidth;
        this.bgColorFrom = bgColorFrom;
        this.bgColorTo = bgColorTo;
        this.barBgColor = barBgColor;
        this.barColor = barColor;
        this.barBorderColor = barBorderColor;
    }

    protected abstract int getContentHeight();

    protected void drawBackground(class_4587 matrix, class_289 tess, float partialTick) {
        class_287 worldr = tess.method_1349();
        if (this.client.field_1687 != null) {
            this.drawGradientRect(matrix, this.left, this.top, this.right, this.bottom, this.bgColorFrom, this.bgColorTo);
        } else {
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22735);
            float texScale = 32.0f;
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            worldr.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            worldr.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            worldr.method_22912((double)this.right, (double)this.top, 0.0).method_22913((float)this.right / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            worldr.method_22912((double)this.left, (double)this.top, 0.0).method_22913((float)this.left / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tess.method_1350();
        }
    }

    protected abstract void drawPanel(class_4587 var1, int var2, int var3, class_289 var4, int var5, int var6);

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        return false;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    private void applyScrollLimits() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0) {
            this.scrollDistance = (float)((double)this.scrollDistance + -scroll * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + this.barWidth);
        if (this.scrolling) {
            return true;
        }
        int mouseListY = (int)mouseY - this.top - this.getContentHeight() + (int)this.scrollDistance - this.border;
        if (mouseX >= (double)this.left && mouseX <= (double)this.right && mouseListY < 0) {
            return this.clickPanel(mouseX - (double)this.left, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        boolean ret = this.scrolling;
        this.scrolling = false;
        return ret;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - this.border * 2) {
            barHeight = this.height - this.border * 2;
        }
        return barHeight;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTick) {
        class_289 tess = class_289.method_1348();
        class_287 worldr = tess.method_1349();
        double scale = this.client.method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.method_22683().method_4506() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        this.drawBackground(matrix, tess, partialTick);
        int baseY = this.top + this.border - (int)this.scrollDistance;
        this.drawPanel(matrix, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        int extraHeight = this.getContentHeight() + this.border - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            int barBgAlpha = this.barBgColor >> 24 & 0xFF;
            int barBgRed = this.barBgColor >> 16 & 0xFF;
            int barBgGreen = this.barBgColor >> 8 & 0xFF;
            int barBgBlue = this.barBgColor & 0xFF;
            RenderSystem.setShader(class_757::method_34540);
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)this.bottom, 0.0).method_1336(barBgRed, barBgGreen, barBgBlue, barBgAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth), (double)this.bottom, 0.0).method_1336(barBgRed, barBgGreen, barBgBlue, barBgAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth), (double)this.top, 0.0).method_1336(barBgRed, barBgGreen, barBgBlue, barBgAlpha).method_1344();
            worldr.method_22912((double)this.barLeft, (double)this.top, 0.0).method_1336(barBgRed, barBgGreen, barBgBlue, barBgAlpha).method_1344();
            tess.method_1350();
            int barAlpha = this.barColor >> 24 & 0xFF;
            int barRed = this.barColor >> 16 & 0xFF;
            int barGreen = this.barColor >> 8 & 0xFF;
            int barBlue = this.barColor & 0xFF;
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)(barTop + barHeight), 0.0).method_1336(barRed, barGreen, barBlue, barAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth), (double)(barTop + barHeight), 0.0).method_1336(barRed, barGreen, barBlue, barAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth), (double)barTop, 0.0).method_1336(barRed, barGreen, barBlue, barAlpha).method_1344();
            worldr.method_22912((double)this.barLeft, (double)barTop, 0.0).method_1336(barRed, barGreen, barBlue, barAlpha).method_1344();
            tess.method_1350();
            int barBorderAlpha = this.barBorderColor >> 24 & 0xFF;
            int barBorderRed = this.barBorderColor >> 16 & 0xFF;
            int barBorderGreen = this.barBorderColor >> 8 & 0xFF;
            int barBorderBlue = this.barBorderColor & 0xFF;
            worldr.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            worldr.method_22912((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).method_1336(barBorderRed, barBorderGreen, barBorderBlue, barBorderAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth - 1), (double)(barTop + barHeight - 1), 0.0).method_1336(barBorderRed, barBorderGreen, barBorderBlue, barBorderAlpha).method_1344();
            worldr.method_22912((double)(this.barLeft + this.barWidth - 1), (double)barTop, 0.0).method_1336(barBorderRed, barBorderGreen, barBorderBlue, barBorderAlpha).method_1344();
            worldr.method_22912((double)this.barLeft, (double)barTop, 0.0).method_1336(barBorderRed, barBorderGreen, barBorderBlue, barBorderAlpha).method_1344();
            tess.method_1350();
        }
        RenderSystem.disableBlend();
        RenderSystem.disableScissor();
    }

    protected void drawGradientRect(class_4587 poseStack, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)right, (float)top, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(matrix, (float)left, (float)top, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(matrix, (float)left, (float)bottom, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        buffer.method_22918(matrix, (float)right, (float)bottom, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

