/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8001;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import org.joml.Matrix4f;

public class GuiHelper {
    public static final class_2960 GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    private static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    private static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final class_2960 ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final class_2960 SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();

    private GuiHelper() {
    }

    public static void renderItemInGUI(class_4587 matrixStack, class_310 minecraft, class_1799 stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(class_4587 matrixStack, int x, int y, int slotWidth, int slotHeight) {
        int currentY = y;
        for (int remainingSlotHeight = slotHeight; remainingSlotHeight > 0; remainingSlotHeight -= Math.min(slotHeight, 12)) {
            int finalRemainingSlotHeight = remainingSlotHeight;
            int key = GuiHelper.getSlotsBackgroundKey(slotWidth, remainingSlotHeight);
            GuiHelper.blit(matrixStack, x, currentY, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, finalRemainingSlotHeight * 18))));
            currentY += 216;
        }
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(class_4587 matrixStack, class_310 minecraft, class_1799 stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(class_4587 matrixStack, class_310 minecraft, class_1799 stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        RenderSystem.enableDepthTest();
        class_918 itemRenderer = minecraft.method_1480();
        itemRenderer.method_4023(matrixStack, stack, xPosition, yPosition);
        if (renderOverlay) {
            itemRenderer.method_4022(matrixStack, minecraft.field_1772, stack, xPosition, yPosition, countText);
        }
    }

    public static void blit(class_4587 matrixStack, int x, int y, TextureBlitData texData) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)texData.getTextureName());
        class_332.method_25290((class_4587)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset()), (float)texData.getU(), (float)texData.getV(), (int)texData.getWidth(), (int)texData.getHeight(), (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
    }

    public static void blit(class_4587 matrixStack, int x, int y, TextureBlitData texData, int width, int height) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)texData.getTextureName());
        int halfWidth = width / 2;
        int secondHalfWidth = width - halfWidth;
        int halfHeight = height / 2;
        int secondHalfHeight = height - halfHeight;
        class_332.method_25290((class_4587)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset()), (float)texData.getU(), (float)texData.getV(), (int)halfWidth, (int)halfHeight, (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
        class_332.method_25290((class_4587)matrixStack, (int)(x + texData.getXOffset() + halfWidth), (int)(y + texData.getYOffset()), (float)((float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth), (float)texData.getV(), (int)secondHalfWidth, (int)halfHeight, (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
        class_332.method_25290((class_4587)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset() + halfHeight), (float)texData.getU(), (float)((float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight), (int)halfWidth, (int)secondHalfHeight, (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
        class_332.method_25290((class_4587)matrixStack, (int)(x + texData.getXOffset() + halfWidth), (int)(y + texData.getYOffset() + halfHeight), (float)((float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth), (float)((float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight), (int)secondHalfWidth, (int)secondHalfHeight, (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderSystem.setShader(class_757::method_34541);
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferbuilder.method_22918(matrix, (float)xMin, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(minU, maxV).method_1344();
        bufferbuilder.method_22918(matrix, (float)xMax, (float)yMax, 0.0f).method_22915(red, green, blue, alpha).method_22913(maxU, maxV).method_1344();
        bufferbuilder.method_22918(matrix, (float)xMax, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(maxU, minV).method_1344();
        bufferbuilder.method_22918(matrix, (float)xMin, (float)yMin, 0.0f).method_22915(red, green, blue, alpha).method_22913(minU, minV).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void writeTooltipLines(List<? extends class_5348> textLines, class_327 font, float leftX, int topY, Matrix4f matrix4f, class_4597.class_4598 renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            class_5348 line = textLines.get(i);
            if (line != null) {
                font.method_22942(class_2477.method_10517().method_30934(line), leftX, (float)topY, color, true, matrix4f, (class_4597)renderTypeBuffer, class_327.class_6415.field_33993, 0, 0xF000F0);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    private static void fillGradient(Matrix4f matrix, class_287 builder, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.method_22918(matrix, (float)x2, (float)y1, 400.0f).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y1, 400.0f).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y2, 400.0f).method_22915(f5, f6, f7, f4).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, 400.0f).method_22915(f5, f6, f7, f4).method_1344();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, class_2561 ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new class_2561[]{class_2561.method_43471((String)tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<class_2561> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(class_4587 matrixStack, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(matrixStack, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(matrixStack, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledFluidTextureAtlas(class_4587 matrixStack, class_1058 sprite, int color, int x, int y, int height) {
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        float u1 = sprite.method_4594();
        float v1 = sprite.method_4593();
        int spriteHeight = sprite.method_45851().method_45815();
        int spriteWidth = sprite.method_45851().method_45807();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.method_4570((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            float u2 = sprite.method_4580((double)(256.0f / (float)spriteWidth));
            builder.method_22918(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).method_22913(u1, v2).method_22915(red, green, blue, 1.0f).method_1344();
            builder.method_22918(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).method_22913(u2, v2).method_22915(red, green, blue, 1.0f).method_1344();
            builder.method_22918(matrix, (float)x + 16.0f, (float)startY, 100.0f).method_22913(u2, v1).method_22915(red, green, blue, 1.0f).method_1344();
            builder.method_22918(matrix, (float)x, (float)startY, 100.0f).method_22913(u1, v1).method_22915(red, green, blue, 1.0f).method_1344();
            startY += renderHeight;
        } while (height > 0);
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    public static void renderControlBackground(class_4587 matrixStack, int x, int y, int renderWidth, int renderHeight) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_CONTROLS);
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)u, (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        class_332.method_25290((class_4587)matrixStack, (int)x, (int)(y + halfHeight), (float)u, (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        class_332.method_25290((class_4587)matrixStack, (int)(x + halfWidth), (int)y, (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        class_332.method_25290((class_4587)matrixStack, (int)(x + halfWidth), (int)(y + halfHeight), (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
    }

    public static void tryRenderGuiItem(class_4587 poseStack, class_918 itemRenderer, class_1060 textureManager, @Nullable class_1309 livingEntity, class_1799 stack, int x, int y, int rotation) {
        if (!stack.method_7960()) {
            class_1087 bakedmodel = itemRenderer.method_4019(stack, null, livingEntity, 0);
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 50.0f);
            try {
                GuiHelper.renderGuiItem(poseStack, itemRenderer, textureManager, stack, x, y, bakedmodel, rotation);
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
                class_129 crashreportcategory = crashreport.method_562("Item being rendered");
                crashreportcategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashreportcategory.method_577("Registry Name", () -> String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909())));
                crashreportcategory.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
                crashreportcategory.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
                crashreportcategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashreport);
            }
            poseStack.method_22909();
        }
    }

    private static void renderGuiItem(class_4587 poseStack, class_918 itemRenderer, class_1060 textureManager, class_1799 stack, int x, int y, class_1087 bakedModel, int rotation) {
        boolean flag;
        textureManager.method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22903();
        poseStack.method_46416((float)(x + 8), (float)(y + 8), 100.0f);
        if (rotation != 0) {
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)rotation));
        }
        poseStack.method_22905(1.0f, -1.0f, 1.0f);
        poseStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 posestack1 = new class_4587();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flag = !bakedModel.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_811.field_4317, false, posestack1, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static Optional<class_1735> getSlotUnderMouse(class_465<?> containerScreen) {
        class_1735 slot = containerScreen.field_2787;
        return Optional.ofNullable(slot);
    }

    public static void renderTooltip(class_437 screen, class_4587 poseStack, List<class_2561> components, int x, int y) {
        List<class_5684> list = GuiHelper.gatherTooltipComponents(components, x, screen.field_22789, screen.field_22790, screen.field_22793);
        screen.method_32633(poseStack, list, x, y, class_8001.field_41687);
    }

    public static List<class_5684> gatherTooltipComponents(List<? extends class_5348> textElements, int mouseX, int screenWidth, int screenHeight, class_327 font) {
        int tooltipX = mouseX + 12;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return elements.stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, tooltipTextWidthF).stream().map(class_5684::method_32662), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
    }

    public static Optional<class_768> getPositiveRectangle(int x, int y, int width, int height) {
        if (x + width <= 0 || y + height <= 0) {
            return Optional.empty();
        }
        int positiveX = Math.max(0, x);
        int positiveY = Math.max(0, y);
        int positiveWidth = width + Math.min(0, x);
        int positiveHeight = height + Math.min(0, y);
        return Optional.of(new class_768(positiveX, positiveY, positiveWidth, positiveHeight));
    }
}

