/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5250;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.TransferRecipeMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;

public abstract class CraftingContainerRecipeTransferHandlerBase<C extends StorageContainerMenuBase<?>>
implements IRecipeTransferHandler<C, class_3955> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IStackHelper stackHelper;

    protected CraftingContainerRecipeTransferHandlerBase(IRecipeTransferHandlerHelper handlerHelper, IStackHelper stackHelper) {
        this.handlerHelper = handlerHelper;
        this.stackHelper = stackHelper;
    }

    public Optional<class_3917<C>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<class_3955> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, class_3955 recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        List<Object> list;
        Optional potentialCraftingContainer = ((StorageContainerMenuBase)container).getOpenOrFirstCraftingContainer();
        if (potentialCraftingContainer.isEmpty()) {
            return this.handlerHelper.createInternalError();
        }
        UpgradeContainerBase openOrFirstCraftingContainer = (UpgradeContainerBase)potentialCraftingContainer.get();
        if (openOrFirstCraftingContainer instanceof ICraftingContainer) {
            ICraftingContainer cc = (ICraftingContainer)((Object)openOrFirstCraftingContainer);
            list = cc.getRecipeSlots();
        } else {
            list = Collections.emptyList();
        }
        List<class_1735> craftingSlots = Collections.unmodifiableList(list);
        List<class_1735> inventorySlots = ((StorageContainerMenuBase)container).realInventorySlots.stream().filter(s -> s.method_7674(player)).toList();
        if (!this.validateTransferInfo(container, craftingSlots, inventorySlots)) {
            return this.handlerHelper.createInternalError();
        }
        List inputItemSlotViews = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        if (!this.validateRecipeView(container, craftingSlots, inputItemSlotViews)) {
            return this.handlerHelper.createInternalError();
        }
        InventoryState inventoryState = this.getInventoryState(craftingSlots, inventorySlots, player, container);
        if (inventoryState == null) {
            return this.handlerHelper.createInternalError();
        }
        int inputCount = inputItemSlotViews.size();
        if (!inventoryState.hasRoom(inputCount)) {
            class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)message);
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.stackHelper, inventoryState.availableItemStacks, (List)inputItemSlotViews, craftingSlots);
        if (!transferOperations.missingItems.isEmpty()) {
            class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForMissingSlots((class_2561)message, (Collection)transferOperations.missingItems);
        }
        if (!RecipeTransferUtil.validateSlots((class_1657)player, (Collection)transferOperations.results, craftingSlots, inventorySlots)) {
            return this.handlerHelper.createInternalError();
        }
        List<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.field_7874).sorted().toList();
        List<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.field_7874).sorted().toList();
        if (doTransfer) {
            if (!openOrFirstCraftingContainer.isOpen()) {
                ((StorageContainerMenuBase)container).getOpenContainer().ifPresent(c -> {
                    c.setIsOpen(false);
                    container.setOpenTabId(-1);
                });
                openOrFirstCraftingContainer.setIsOpen(true);
                ((StorageContainerMenuBase)container).setOpenTabId(openOrFirstCraftingContainer.getUpgradeContainerId());
            }
            TransferRecipeMessage message = new TransferRecipeMessage(this.toMap(transferOperations.results), craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            PacketHandler.sendToServer(message);
        }
        return null;
    }

    private Map<Integer, Integer> toMap(List<TransferOperation> transferOperations) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        transferOperations.forEach(to -> ret.put(to.craftingSlot().field_7874, to.inventorySlot().field_7874));
        return ret;
    }

    private boolean validateTransferInfo(C container, List<class_1735> craftingSlots, List<class_1735> inventorySlots) {
        Set<Integer> craftingSlotIndexes = this.slotIndexes(craftingSlots);
        Set<Integer> inventorySlotIndexes = this.slotIndexes(inventorySlots);
        ArrayList<class_1735> allSlots = new ArrayList<class_1735>(((StorageContainerMenuBase)container).realInventorySlots);
        allSlots.addAll(((StorageContainerMenuBase)container).upgradeSlots);
        Set<Integer> containerSlotIndexes = this.slotIndexes(allSlots);
        if (!containerSlotIndexes.containsAll(craftingSlotIndexes)) {
            SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references crafting slot indexes [{}] that are not found in the inventory container slots [{}]", new Object[]{this.getClass(), container.getClass(), StringUtil.intsToString(craftingSlotIndexes), StringUtil.intsToString(containerSlotIndexes)});
            return false;
        }
        if (!containerSlotIndexes.containsAll(inventorySlotIndexes)) {
            SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references inventory slot indexes [{}] that are not found in the inventory container slots [{}]", new Object[]{this.getClass(), container.getClass(), StringUtil.intsToString(inventorySlotIndexes), StringUtil.intsToString(containerSlotIndexes)});
            return false;
        }
        return true;
    }

    private boolean validateRecipeView(C container, List<class_1735> craftingSlots, List<IRecipeSlotView> inputSlots) {
        if (inputSlots.size() > craftingSlots.size()) {
            SophisticatedCore.LOGGER.error("Recipe View {} does not work for container {}. The Recipe View has more input slots ({}) than the number of inventory crafting slots ({})", new Object[]{this.getClass(), container.getClass(), inputSlots.size(), craftingSlots.size()});
            return false;
        }
        return true;
    }

    @Nullable
    private InventoryState getInventoryState(Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots, class_1657 player, C container) {
        class_1799 stack;
        HashMap<class_1735, class_1799> availableItemStacks = new HashMap<class_1735, class_1799>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (class_1735 slot : craftingSlots) {
            stack = slot.method_7677();
            if (stack.method_7960()) continue;
            if (!slot.method_7674(player)) {
                SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Crafting Slot number {}", new Object[]{this.getClass(), container.getClass(), slot.field_7874});
                return null;
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot, stack.method_7972());
        }
        for (class_1735 slot : inventorySlots) {
            stack = slot.method_7677();
            if (!stack.method_7960()) {
                if (!slot.method_7674(player)) {
                    SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Inventory Slot number {}", new Object[]{this.getClass(), container.getClass(), slot.field_7874});
                    return null;
                }
                availableItemStacks.put(slot, stack.method_7972());
                continue;
            }
            ++emptySlotCount;
        }
        return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
    }

    private Set<Integer> slotIndexes(Collection<class_1735> slots) {
        return slots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
    }

    private int getEmptySlotCount(Map<Integer, class_1735> inventorySlots, Map<Integer, class_1799> availableItemStacks) {
        int emptySlotCount = 0;
        for (class_1735 slot : inventorySlots.values()) {
            class_1799 stack = slot.method_7677();
            if (!stack.method_7960()) {
                availableItemStacks.put(slot.field_7874, stack.method_7972());
                continue;
            }
            ++emptySlotCount;
        }
        return emptySlotCount;
    }

    public record InventoryState(Map<class_1735, class_1799> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        public boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }
}

