/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public abstract class ControllerBlockEntityBase
extends class_2586
implements SlottedStackStorage {
    public static final int SEARCH_RANGE = 15;
    private List<class_2338> storagePositions = new ArrayList<class_2338>();
    private List<Integer> baseIndexes = new ArrayList<Integer>();
    private int totalSlots = 0;
    private final Map<ItemStackKey, Set<class_2338>> stackStorages = new HashMap<ItemStackKey, Set<class_2338>>();
    private final Map<class_2338, Set<ItemStackKey>> storageStacks = new HashMap<class_2338, Set<ItemStackKey>>();
    private final Map<class_1792, Set<ItemStackKey>> itemStackKeys = new HashMap<class_1792, Set<ItemStackKey>>();
    private final Set<class_2338> emptySlotsStorages = new LinkedHashSet<class_2338>();
    private final Map<class_1792, Set<class_2338>> memorizedItemStorages = new HashMap<class_1792, Set<class_2338>>();
    private final Map<class_2338, Set<class_1792>> storageMemorizedItems = new HashMap<class_2338, Set<class_1792>>();
    private final Map<Integer, Set<class_2338>> memorizedStackStorages = new HashMap<Integer, Set<class_2338>>();
    private final Map<class_2338, Set<Integer>> storageMemorizedStacks = new HashMap<class_2338, Set<Integer>>();
    private final Map<class_1792, Set<class_2338>> filterItemStorages = new HashMap<class_1792, Set<class_2338>>();
    private final Map<class_2338, Set<class_1792>> storageFilterItems = new HashMap<class_2338, Set<class_1792>>();
    private Set<class_2338> linkedBlocks = new LinkedHashSet<class_2338>();
    @Nullable
    private SlottedStackStorage itemHandlerCap;
    private boolean unloaded = false;

    protected ControllerBlockEntityBase(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        ServerChunkEvents.CHUNK_LOAD.register((level, chunk) -> {
            if (chunk.method_12214().containsValue((Object)this)) {
                this.unloaded = false;
            }
        });
        ServerChunkEvents.CHUNK_UNLOAD.register((level, chunk) -> {
            if (this.unloaded) {
                return;
            }
            if (chunk.method_12214().containsValue((Object)this)) {
                this.onChunkUnloaded();
            }
        });
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((be, world) -> {
            if (be == this) {
                this.invalidateCaps();
            }
        });
    }

    public boolean addLinkedBlock(class_2338 linkedPos) {
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.isWithinRange(linkedPos) && !this.linkedBlocks.contains(linkedPos) && !this.storagePositions.contains(linkedPos)) {
            this.linkedBlocks.add(linkedPos);
            this.method_5431();
            WorldHelper.getBlockEntity((class_1922)this.field_11863, linkedPos, ILinkable.class).ifPresent(l -> {
                if (l.connectLinkedSelf()) {
                    LinkedHashSet<class_2338> positionsToCheck = new LinkedHashSet<class_2338>();
                    positionsToCheck.add(linkedPos);
                    this.searchAndAddStorages(positionsToCheck, true);
                }
                this.searchAndAddStorages(new LinkedHashSet<class_2338>(l.getConnectablePositions()), false);
            });
            WorldHelper.notifyBlockUpdate(this);
            return true;
        }
        return false;
    }

    public void removeLinkedBlock(class_2338 storageBlockPos) {
        this.linkedBlocks.remove(storageBlockPos);
        this.method_5431();
        this.verifyStoragesConnected();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.stackStorages.clear();
            this.storageStacks.clear();
            this.itemStackKeys.clear();
            this.emptySlotsStorages.clear();
            this.storagePositions.forEach(this::addStorageStacksAndRegisterListeners);
        }
    }

    public void searchAndAddStorages() {
        HashSet<class_2338> positionsToCheck = new HashSet<class_2338>();
        for (class_2350 dir : class_2350.values()) {
            positionsToCheck.add(this.method_11016().method_10081(dir.method_10163()));
        }
        this.searchAndAddStorages(positionsToCheck, false);
    }

    public void changeSlots(class_2338 storagePos, int newSlots, boolean hasEmptySlots) {
        this.updateBaseIndexesAndTotalSlots(storagePos, newSlots);
        this.updateEmptySlots(storagePos, hasEmptySlots);
    }

    public void updateEmptySlots(class_2338 storagePos, boolean hasEmptySlots) {
        if (this.emptySlotsStorages.contains(storagePos) && !hasEmptySlots) {
            this.emptySlotsStorages.remove(storagePos);
        } else if (!this.emptySlotsStorages.contains(storagePos) && hasEmptySlots) {
            this.emptySlotsStorages.add(storagePos);
        }
    }

    private void updateBaseIndexesAndTotalSlots(class_2338 storagePos, int newSlots) {
        int index = this.storagePositions.indexOf(storagePos);
        int originalSlots = this.getStorageSlots(index);
        int diff = newSlots - originalSlots;
        for (int i = index; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) + diff);
        }
        this.totalSlots += diff;
        WorldHelper.notifyBlockUpdate(this);
    }

    private int getStorageSlots(int index) {
        int previousBaseIndex = index == 0 ? 0 : this.baseIndexes.get(index - 1);
        return this.baseIndexes.get(index) - previousBaseIndex;
    }

    public int getSlots(int storageIndex) {
        if (storageIndex < 0 || storageIndex >= this.baseIndexes.size()) {
            return 0;
        }
        return this.getStorageSlots(storageIndex);
    }

    private void searchAndAddStorages(Set<class_2338> positionsToCheck, boolean addingLinkedSelf) {
        HashSet positionsChecked = new HashSet();
        boolean first = true;
        while (!positionsToCheck.isEmpty()) {
            Iterator<class_2338> it = positionsToCheck.iterator();
            class_2338 posToCheck = it.next();
            it.remove();
            boolean finalFirst = first;
            WorldHelper.getLoadedBlockEntity(this.field_11863, posToCheck, IControllableStorage.class).ifPresentOrElse(storage -> this.tryToConnectStorageAndAddPositionsToCheckAround(positionsToCheck, addingLinkedSelf, positionsChecked, posToCheck, finalFirst, (IControllableStorage)storage), () -> positionsChecked.add(posToCheck));
            first = false;
        }
    }

    private void tryToConnectStorageAndAddPositionsToCheckAround(Set<class_2338> positionsToCheck, boolean addingLinkedSelf, Set<class_2338> positionsChecked, class_2338 posToCheck, boolean finalFirst, IControllableStorage storage) {
        if (storage.canBeConnected() || addingLinkedSelf && finalFirst) {
            ILinkable linkable;
            if (storage instanceof ILinkable && (linkable = (ILinkable)((Object)storage)).isLinked() && (!addingLinkedSelf || !finalFirst)) {
                this.linkedBlocks.remove(posToCheck);
                linkable.setNotLinked();
            } else {
                this.addStorageData(posToCheck);
            }
            if (storage.canConnectStorages()) {
                this.addUncheckedPositionsAround(positionsToCheck, positionsChecked, posToCheck);
            }
        }
    }

    private void addUncheckedPositionsAround(Set<class_2338> positionsToCheck, Set<class_2338> positionsChecked, class_2338 currentPos) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 pos = currentPos.method_10081(dir.method_10163());
            if (positionsChecked.contains(pos) || this.storagePositions.contains(pos) && !this.linkedBlocks.contains(pos) || !this.isWithinRange(pos)) continue;
            positionsToCheck.add(pos);
        }
    }

    private boolean isWithinRange(class_2338 pos) {
        return Math.abs(pos.method_10263() - this.method_11016().method_10263()) <= 15 && Math.abs(pos.method_10264() - this.method_11016().method_10264()) <= 15 && Math.abs(pos.method_10260() - this.method_11016().method_10260()) <= 15;
    }

    public void addStorage(class_2338 storagePos) {
        if (this.storagePositions.contains(storagePos)) {
            this.removeStorageInventoryData(storagePos);
        }
        if (this.isWithinRange(storagePos)) {
            LinkedHashSet<class_2338> positionsToCheck = new LinkedHashSet<class_2338>();
            positionsToCheck.add(storagePos);
            this.searchAndAddStorages(positionsToCheck, false);
        }
    }

    private void addStorageData(class_2338 storagePos) {
        this.storagePositions.add(storagePos);
        this.totalSlots += this.getInventoryHandlerValueFromHolder(storagePos, SlottedStorage::getSlotCount).orElse(0).intValue();
        this.baseIndexes.add(this.totalSlots);
        this.addStorageStacksAndRegisterListeners(storagePos);
        this.method_5431();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void addStorageStacksAndRegisterListeners(class_2338 storagePos) {
        WorldHelper.getLoadedBlockEntity(this.field_11863, storagePos, IControllableStorage.class).ifPresent(storage -> {
            ITrackedContentsItemHandler handler = storage.getStorageWrapper().getInventoryForInputOutput();
            handler.getTrackedStacks().forEach(k -> this.addStorageStack(storagePos, (ItemStackKey)k));
            if (handler.hasEmptySlots()) {
                this.emptySlotsStorages.add(storagePos);
            }
            MemorySettingsCategory memorySettings = storage.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            memorySettings.getFilterItemSlots().keySet().forEach(i -> this.addStorageMemorizedItem(storagePos, (class_1792)i));
            memorySettings.getFilterStackSlots().keySet().forEach(stackHash -> this.addStorageMemorizedStack(storagePos, (int)stackHash));
            this.setStorageFilterItems(storagePos, storage.getStorageWrapper().getInventoryHandler().getFilterItems());
            storage.registerController(this);
        });
    }

    public void addStorageMemorizedItem(class_2338 storagePos, class_1792 item) {
        this.memorizedItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedItems.computeIfAbsent(storagePos, pos -> new HashSet()).add(item);
    }

    public void addStorageMemorizedStack(class_2338 storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfAbsent(stackHash, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(stackHash);
    }

    public void removeStorageMemorizedItem(class_2338 storagePos, class_1792 item) {
        this.memorizedItemStorages.computeIfPresent(item, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedItemStorages.containsKey(item) && this.memorizedItemStorages.get(item).isEmpty()) {
            this.memorizedItemStorages.remove(item);
        }
        this.storageMemorizedItems.remove(storagePos);
    }

    public void removeStorageMemorizedStack(class_2338 storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfPresent(stackHash, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedStackStorages.containsKey(stackHash) && this.memorizedStackStorages.get(stackHash).isEmpty()) {
            this.memorizedStackStorages.remove(stackHash);
        }
        this.storageMemorizedStacks.remove(storagePos);
    }

    private <T> Optional<T> getInventoryHandlerValueFromHolder(class_2338 storagePos, Function<IItemHandlerSimpleInserter, T> valueGetter) {
        return this.getWrapperValueFromHolder(storagePos, wrapper -> valueGetter.apply(wrapper.getInventoryForInputOutput()));
    }

    private <T> Optional<T> getWrapperValueFromHolder(class_2338 storagePos, Function<IStorageWrapper, T> valueGetter) {
        return WorldHelper.getLoadedBlockEntity(this.field_11863, storagePos, IControllableStorage.class).map(holder -> valueGetter.apply(holder.getStorageWrapper()));
    }

    public void addStorageStack(class_2338 storagePos, ItemStackKey itemStackKey) {
        this.stackStorages.computeIfAbsent(itemStackKey, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(itemStackKey);
        this.itemStackKeys.computeIfAbsent(itemStackKey.getStack().method_7909(), item -> new LinkedHashSet()).add(itemStackKey);
    }

    public void removeStorageStack(class_2338 storagePos, ItemStackKey stackKey) {
        this.stackStorages.computeIfPresent(stackKey, (sk, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.stackStorages.containsKey(stackKey) && this.stackStorages.get(stackKey).isEmpty()) {
            this.stackStorages.remove(stackKey);
            this.itemStackKeys.computeIfPresent(stackKey.getStack().method_7909(), (i, stackKeys) -> {
                stackKeys.remove(stackKey);
                return stackKeys;
            });
            if (this.itemStackKeys.containsKey(stackKey.getStack().method_7909()) && this.itemStackKeys.get(stackKey.getStack().method_7909()).isEmpty()) {
                this.itemStackKeys.remove(stackKey.getStack().method_7909());
            }
        }
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.storageStacks.containsKey(storagePos) && this.storageStacks.get(storagePos).isEmpty()) {
            this.storageStacks.remove(storagePos);
        }
    }

    public void removeStorageStacks(class_2338 storagePos) {
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.forEach(stackKey -> {
                Set<class_2338> storages = this.stackStorages.get(stackKey);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.stackStorages.remove(stackKey);
                        this.itemStackKeys.computeIfPresent(stackKey.getStack().method_7909(), (i, positions) -> {
                            positions.remove(stackKey);
                            return positions;
                        });
                        if (this.itemStackKeys.containsKey(stackKey.getStack().method_7909()) && this.itemStackKeys.get(stackKey.getStack().method_7909()).isEmpty()) {
                            this.itemStackKeys.remove(stackKey.getStack().method_7909());
                        }
                    }
                }
            });
            return stackKeys;
        });
        this.storageStacks.remove(storagePos);
    }

    protected boolean hasItem(class_1792 item) {
        return this.itemStackKeys.containsKey(item);
    }

    protected boolean isMemorizedItem(class_1799 stack) {
        return this.memorizedItemStorages.containsKey(stack.method_7909()) || this.memorizedStackStorages.containsKey(ItemStackKey.getHashCode(stack));
    }

    protected boolean isFilterItem(class_1792 item) {
        return this.filterItemStorages.containsKey(item);
    }

    public void removeStorage(class_2338 storagePos) {
        this.removeStorageInventoryDataAndUnregisterController(storagePos);
        this.verifyStoragesConnected();
    }

    private void removeStorageInventoryDataAndUnregisterController(class_2338 storagePos) {
        if (!this.storagePositions.contains(storagePos)) {
            return;
        }
        this.removeStorageInventoryData(storagePos);
        this.linkedBlocks.remove(storagePos);
        WorldHelper.getLoadedBlockEntity(this.field_11863, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
        this.method_5431();
        WorldHelper.notifyBlockUpdate(this);
    }

    private void removeStorageInventoryData(class_2338 storagePos) {
        int idx = this.storagePositions.indexOf(storagePos);
        this.totalSlots -= this.getStorageSlots(idx);
        this.removeStorageStacks(storagePos);
        this.removeStorageMemorizedItems(storagePos);
        this.removeStorageMemorizedStacks(storagePos);
        this.removeStorageWithEmptySlots(storagePos);
        this.removeStorageFilterItems(storagePos);
        this.storagePositions.remove(idx);
        this.removeBaseIndexAt(idx);
    }

    private void removeStorageFilterItems(class_2338 storagePos) {
        this.storageFilterItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<class_2338> storages = this.filterItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.filterItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageFilterItems.remove(storagePos);
    }

    private void removeStorageMemorizedItems(class_2338 storagePos) {
        this.storageMemorizedItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<class_2338> storages = this.memorizedItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedItems.remove(storagePos);
    }

    private void removeStorageMemorizedStacks(class_2338 storagePos) {
        this.storageMemorizedStacks.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(stackHash -> {
                Set<class_2338> storages = this.memorizedStackStorages.get(stackHash);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedStackStorages.remove(stackHash);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedStacks.remove(storagePos);
    }

    private void verifyStoragesConnected() {
        HashSet<class_2338> toVerify = new HashSet<class_2338>(this.storagePositions);
        HashSet<class_2338> positionsToCheck = new HashSet<class_2338>();
        for (class_2350 dir : class_2350.values()) {
            class_2338 offsetPos = this.method_11016().method_10081(dir.method_10163());
            if (!toVerify.contains(offsetPos)) continue;
            positionsToCheck.add(offsetPos);
        }
        HashSet<class_2338> positionsChecked = new HashSet<class_2338>();
        this.verifyDirectlyConnected(toVerify, positionsToCheck, positionsChecked);
        this.linkedBlocks.forEach(linkedPosition -> WorldHelper.getBlockEntity((class_1922)this.method_10997(), linkedPosition, ILinkable.class).ifPresent(l -> {
            if (l.connectLinkedSelf() && toVerify.contains(linkedPosition)) {
                positionsToCheck.add((class_2338)linkedPosition);
            }
            l.getConnectablePositions().forEach(p -> {
                if (toVerify.contains(p)) {
                    positionsToCheck.add((class_2338)p);
                }
            });
        }));
        this.verifyDirectlyConnected(toVerify, positionsToCheck, positionsChecked);
        toVerify.forEach(this::removeStorageInventoryDataAndUnregisterController);
    }

    private void verifyDirectlyConnected(HashSet<class_2338> toVerify, Set<class_2338> positionsToCheck, Set<class_2338> positionsChecked) {
        while (!positionsToCheck.isEmpty()) {
            Iterator<class_2338> it = positionsToCheck.iterator();
            class_2338 posToCheck = it.next();
            it.remove();
            positionsChecked.add(posToCheck);
            WorldHelper.getLoadedBlockEntity(this.field_11863, posToCheck, IControllableStorage.class).ifPresent(h -> {
                toVerify.remove(posToCheck);
                if (h.canConnectStorages()) {
                    for (class_2350 dir : class_2350.values()) {
                        class_2338 pos = posToCheck.method_10081(dir.method_10163());
                        if (positionsChecked.contains(pos) || !toVerify.contains(pos)) continue;
                        positionsToCheck.add(pos);
                    }
                }
            });
        }
    }

    private void removeBaseIndexAt(int idx) {
        if (idx >= this.baseIndexes.size()) {
            return;
        }
        int slotsRemoved = this.getStorageSlots(idx);
        this.baseIndexes.remove(idx);
        for (int i = idx; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) - slotsRemoved);
        }
    }

    @Nullable
    public <T, C> T getCapability(BlockApiLookup<T, C> cap, @Nullable C opt) {
        if (cap == ItemStorage.SIDED) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = new CachedFailedInsertInventoryHandler(this, () -> this.field_11863 != null ? this.field_11863.method_8510() : 0L);
            }
            return (T)this.itemHandlerCap;
        }
        return null;
    }

    public void invalidateCaps() {
        if (this.itemHandlerCap != null) {
            this.itemHandlerCap = null;
        }
    }

    public int getSlotCount() {
        return this.totalSlots;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndexes.size(); ++i) {
            if (slot - this.baseIndexes.get(i) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    protected SlottedStackStorage getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.storagePositions.size()) {
            return null;
        }
        return this.getWrapperValueFromHolder(this.storagePositions.get(index), wrapper -> wrapper.getInventoryForInputOutput()).orElse(null);
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndexes.size()) {
            return slot;
        }
        return slot - this.baseIndexes.get(index - 1);
    }

    @Nonnull
    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            throw new IndexOutOfBoundsException(slot);
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            throw new IndexOutOfBoundsException("HandlerIndex out of range: " + handlerIndex);
        }
        if (!this.validateHandlerSlotIndex(handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getStackInSlot")) {
            throw new IndexOutOfBoundsException("Slot in handler out of range: " + slot);
        }
        return handler.getSlot(slot);
    }

    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return class_1799.field_8037;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            return class_1799.field_8037;
        }
        if (this.validateHandlerSlotIndex(handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getStackInSlot")) {
            return handler.getStackInSlot(slot);
        }
        return class_1799.field_8037;
    }

    private boolean isSlotIndexInvalid(int slot) {
        return slot < 0 || slot >= this.totalSlots;
    }

    private boolean validateHandlerSlotIndex(SlottedStackStorage handler, int handlerIndex, int slot, String methodName) {
        if (slot >= 0 && slot < handler.getSlotCount()) {
            return true;
        }
        if (handlerIndex < 0 || handlerIndex >= this.storagePositions.size()) {
            SophisticatedCore.LOGGER.debug("Invalid handler index calculated {} in controller's {} method. If you see many of these messages try replacing controller at {}", new Object[]{handlerIndex, methodName, this.method_11016().method_23854()});
        } else {
            SophisticatedCore.LOGGER.debug("Invalid slot {} passed into controller's {} method for storage at {}. If you see many of these messages try replacing controller at {}", new Object[]{slot, methodName, this.storagePositions.get(handlerIndex).method_23854(), this.method_11016().method_23854()});
        }
        return false;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.isItemValid(slot, resource)) {
            return this.insert(resource, maxAmount, ctx, true);
        }
        return 0L;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.insert(resource, maxAmount, ctx, true);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx, boolean insertIntoAnyEmpty) {
        ItemStackKey stackKey = ItemStackKey.of(resource.toStack());
        long remaining = maxAmount;
        if ((remaining -= this.insertIntoStoragesThatMatchStack(resource, remaining, stackKey, ctx)) == 0L) {
            return maxAmount;
        }
        if ((remaining = this.insertIntoStoragesThatMatchItem(resource, remaining, ctx)) == 0L) {
            return maxAmount;
        }
        if (this.memorizedItemStorages.containsKey(resource.getItem()) && (remaining -= this.insertIntoStorages(this.memorizedItemStorages.get(resource.getItem()), resource, remaining, ctx, false)) == 0L) {
            return maxAmount;
        }
        int stackHash = stackKey.hashCode();
        if (this.memorizedStackStorages.containsKey(stackHash) && (remaining -= this.insertIntoStorages(this.memorizedStackStorages.get(stackHash), resource, remaining, ctx, false)) == 0L) {
            return maxAmount;
        }
        if (this.filterItemStorages.containsKey(resource.getItem()) && (remaining -= this.insertIntoStorages(this.filterItemStorages.get(resource.getItem()), resource, remaining, ctx, false)) == 0L) {
            return maxAmount;
        }
        return insertIntoAnyEmpty ? this.insertIntoStorages(this.emptySlotsStorages, resource, remaining, ctx, false) : maxAmount - remaining;
    }

    private long insertIntoStoragesThatMatchStack(ItemVariant resource, long maxAmount, ItemStackKey stackKey, TransactionContext ctx) {
        long remaining = maxAmount;
        if (this.stackStorages.containsKey(stackKey)) {
            Set<class_2338> positions = this.stackStorages.get(stackKey);
            remaining -= this.insertIntoStorages(positions, resource, remaining, ctx, false);
        }
        return maxAmount - remaining;
    }

    private long insertIntoStoragesThatMatchItem(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long remaining = maxAmount;
        if (!this.emptySlotsStorages.isEmpty() && this.itemStackKeys.containsKey(resource.getItem())) {
            for (ItemStackKey key : this.itemStackKeys.get(resource.getItem())) {
                Set<class_2338> positions;
                if (!this.stackStorages.containsKey(key) || (remaining -= this.insertIntoStorages(positions = this.stackStorages.get(key), resource, remaining, ctx, true)) != 0L) continue;
                return maxAmount;
            }
        }
        return remaining;
    }

    private long insertIntoStorages(Set<class_2338> positions, ItemVariant resource, long maxAmount, TransactionContext ctx, boolean checkHasEmptySlotFirst) {
        long remaining = maxAmount;
        LinkedHashSet<class_2338> positionsCopy = new LinkedHashSet<class_2338>(positions);
        for (class_2338 storagePos : positionsCopy) {
            if (checkHasEmptySlotFirst && !this.emptySlotsStorages.contains(storagePos) || (remaining -= this.insertIntoStorage(storagePos, resource, remaining, ctx)) != 0L) continue;
            return maxAmount;
        }
        return maxAmount - remaining;
    }

    private long insertIntoStorage(class_2338 storagePos, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.getInventoryHandlerValueFromHolder(storagePos, ins -> ins.insert(resource, maxAmount, ctx)).orElse(0L);
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        if (this.isSlotIndexInvalid(slot)) {
            return 0L;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            return 0L;
        }
        if (this.validateHandlerSlotIndex(handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "extractItem(int slot, int amount, boolean simulate)")) {
            return handler.extractSlot(slot, resource, maxAmount, ctx);
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long remaining = maxAmount;
        for (int i = 0; i < this.storagePositions.size(); ++i) {
            SlottedStackStorage handler = this.getHandlerFromIndex(i);
            if (handler == null || (remaining -= handler.extract((Object)resource, remaining, ctx)) != 0L) continue;
            return maxAmount;
        }
        return maxAmount - remaining;
    }

    public int getSlotLimit(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            return 0;
        }
        int localSlot = this.getSlotFromIndex(slot, handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, localSlot, "getSlotLimit(int slot)")) {
            return handler.getSlotLimit(localSlot);
        }
        return 0;
    }

    public boolean isItemValid(int slot, ItemVariant resource) {
        if (this.isSlotIndexInvalid(slot)) {
            return false;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            return false;
        }
        int localSlot = this.getSlotFromIndex(slot, handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, localSlot, "isItemValid(int slot, ItemStack stack)")) {
            return handler.isItemValid(localSlot, resource);
        }
        return false;
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        if (this.isSlotIndexInvalid(slot)) {
            return;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        SlottedStackStorage handler = this.getHandlerFromIndex(handlerIndex);
        if (handler == null) {
            return;
        }
        if (this.validateHandlerSlotIndex(handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "setStackInSlot(int slot, ItemStack stack)")) {
            handler.setStackInSlot(slot, stack);
        }
    }

    public void onChunkUnloaded() {
        this.detachFromStoragesAndUnlinkBlocks();
        this.unloaded = true;
    }

    public void detachFromStoragesAndUnlinkBlocks() {
        this.storagePositions.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.field_11863, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
        new HashSet<class_2338>(this.linkedBlocks).forEach(linkedPos -> WorldHelper.getLoadedBlockEntity(this.field_11863, linkedPos, ILinkable.class).ifPresent(ILinkable::unlinkFromController));
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveData(tag);
    }

    private class_2487 saveData(class_2487 tag) {
        NBTHelper.putList(tag, "storagePositions", this.storagePositions, p -> class_2503.method_23251((long)p.method_10063()));
        NBTHelper.putList(tag, "linkedBlocks", this.linkedBlocks, p -> class_2503.method_23251((long)p.method_10063()));
        NBTHelper.putList(tag, "baseIndexes", this.baseIndexes, class_2497::method_23247);
        tag.method_10569("totalSlots", this.totalSlots);
        return tag;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storagePositions = NBTHelper.getCollection(tag, "storagePositions", (byte)4, t -> Optional.of(class_2338.method_10092((long)((class_2503)t).method_10699())), ArrayList::new).orElseGet(ArrayList::new);
        this.baseIndexes = NBTHelper.getCollection(tag, "baseIndexes", (byte)3, t -> Optional.of(((class_2497)t).method_10701()), ArrayList::new).orElseGet(ArrayList::new);
        this.totalSlots = tag.method_10550("totalSlots");
        this.linkedBlocks = NBTHelper.getCollection(tag, "linkedBlocks", (byte)4, t -> Optional.of(class_2338.method_10092((long)((class_2503)t).method_10699())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
    }

    public class_2487 method_16887() {
        return this.saveData(super.method_16887());
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void addStorageWithEmptySlots(class_2338 storageBlockPos) {
        this.emptySlotsStorages.add(storageBlockPos);
    }

    public void removeStorageWithEmptySlots(class_2338 storageBlockPos) {
        this.emptySlotsStorages.remove(storageBlockPos);
    }

    public Set<class_2338> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public List<class_2338> getStoragePositions() {
        return this.storagePositions;
    }

    public void setStorageFilterItems(class_2338 storagePos, Set<class_1792> filterItems) {
        this.removeStorageFilterItems(storagePos);
        if (filterItems.isEmpty()) {
            return;
        }
        for (class_1792 item : filterItems) {
            this.filterItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        }
        this.storageFilterItems.put(storagePos, new LinkedHashSet<class_1792>(filterItems));
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        CombinedSlottedStorage combinedStorage = new CombinedSlottedStorage(new ArrayList());
        for (int i = 0; i < this.storagePositions.size(); ++i) {
            combinedStorage.parts.add(this.getHandlerFromIndex(i));
        }
        return combinedStorage.iterator();
    }
}

