/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.p3pp3rf1y.sophisticatedcore.crafting.ItemEnabledCondition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ShapeBasedRecipeBuilder {
    private final class_7800 category;
    private final class_1792 itemResult;
    @Nullable
    private final class_2487 nbt;
    private final int count;
    private final List<ConditionJsonProvider> conditions = new ArrayList<ConditionJsonProvider>();
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, class_1856> keyIngredients = Maps.newLinkedHashMap();
    private final class_1865<?> serializer;
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_707();
    @Nullable
    private String group;

    public ShapeBasedRecipeBuilder(class_7800 category, class_1935 itemResult, int count, @Nullable class_2487 nbt, class_1865<?> serializer) {
        this.category = category;
        this.itemResult = itemResult.method_8389();
        this.count = count;
        this.nbt = nbt;
        this.serializer = serializer;
    }

    public static ShapeBasedRecipeBuilder shaped(class_7800 category, class_1935 itemResult) {
        return ShapeBasedRecipeBuilder.shaped(category, itemResult, 1, class_1865.field_9035);
    }

    public static ShapeBasedRecipeBuilder shaped(class_7800 category, class_1935 itemResult, class_1865<?> serializer) {
        return ShapeBasedRecipeBuilder.shaped(category, itemResult, 1, serializer);
    }

    public static ShapeBasedRecipeBuilder shaped(class_7800 category, class_1935 itemResult, int count, class_1865<?> serializer) {
        return ShapeBasedRecipeBuilder.shaped(category, itemResult, count, null, serializer);
    }

    public static ShapeBasedRecipeBuilder shaped(class_7800 category, class_1935 itemResult, int count, @Nullable class_2487 nbt, class_1865<?> serializer) {
        return new ShapeBasedRecipeBuilder(category, itemResult, count, nbt, serializer);
    }

    public static ShapeBasedRecipeBuilder shaped(class_7800 category, class_1799 stack) {
        return ShapeBasedRecipeBuilder.shaped(category, (class_1935)stack.method_7909(), 1, stack.method_7969(), class_1865.field_9035);
    }

    public ShapeBasedRecipeBuilder define(Character symbol, class_6862<class_1792> tagIn) {
        return this.define(symbol, class_1856.method_8106(tagIn));
    }

    public ShapeBasedRecipeBuilder define(Character symbol, class_1935 itemIn) {
        return this.define(symbol, class_1856.method_8091((class_1935[])new class_1935[]{itemIn}));
    }

    public ShapeBasedRecipeBuilder define(Character symbol, class_1856 ingredientIn) {
        if (this.keyIngredients.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.keyIngredients.put(symbol, ingredientIn);
        return this;
    }

    public ShapeBasedRecipeBuilder pattern(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ShapeBasedRecipeBuilder unlockedBy(String name, class_184 criterion) {
        this.advancementBuilder.method_709(name, criterion);
        return this;
    }

    public ShapeBasedRecipeBuilder condition(ConditionJsonProvider condition) {
        this.conditions.add(condition);
        return this;
    }

    public ShapeBasedRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, RegistryHelper.getItemKey(this.itemResult));
    }

    public void save(Consumer<class_2444> consumerIn, class_2960 id) {
        this.ensureValid(id);
        this.advancementBuilder.method_708(class_5797.field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
        consumerIn.accept(new Result(id, this.itemResult, this.conditions, this.nbt, this.count, this.group == null ? "" : this.group, ShapeBasedRecipeBuilder.determineBookCategory(this.category), this.pattern, this.keyIngredients, this.advancementBuilder, new class_2960(id.method_12836(), "recipes/" + this.category.method_46203() + "/" + id.method_12832()), this.serializer));
    }

    private void ensureValid(class_2960 id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(id) + "!");
        }
        HashSet set = Sets.newHashSet(this.keyIngredients.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.keyIngredients.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(id) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(id));
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(id) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    protected static class_7710 determineBookCategory(class_7800 category) {
        return switch (category) {
            case class_7800.field_40634 -> class_7710.field_40248;
            case class_7800.field_40638, class_7800.field_40639 -> class_7710.field_40250;
            case class_7800.field_40636 -> class_7710.field_40249;
            default -> class_7710.field_40251;
        };
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final List<ConditionJsonProvider> conditions;
        private final class_1792 itemResult;
        @Nullable
        private final class_2487 nbt;
        private final int count;
        private final String group;
        private final class_7710 category;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_2960 advancementId;
        private final class_161.class_162 advancementBuilder;
        private final class_1865<?> serializer;

        public Result(class_2960 id, class_1792 itemResult, List<ConditionJsonProvider> conditions, @Nullable class_2487 nbt, int count, String group, class_7710 craftingBookCategory, List<String> pattern, Map<Character, class_1856> keyIngredients, class_161.class_162 advancementBuilder, class_2960 advancementId, class_1865<?> serializer) {
            this.id = id;
            this.conditions = conditions;
            this.itemResult = itemResult;
            this.nbt = nbt;
            this.count = count;
            this.group = group;
            this.category = craftingBookCategory;
            this.pattern = pattern;
            this.key = keyIngredients;
            this.advancementId = advancementId;
            this.advancementBuilder = advancementBuilder;
            this.serializer = serializer;
            conditions.add(new ItemEnabledCondition(itemResult));
        }

        public void method_10416(JsonObject json) {
            json.addProperty("category", this.category.method_15434());
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray conditionsArray = new JsonArray();
            this.conditions.forEach(c -> conditionsArray.add((JsonElement)c.toJson()));
            json.add("fabric:load_conditions", (JsonElement)conditionsArray);
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegistryHelper.getItemKey(this.itemResult).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            if (this.nbt != null) {
                jsonObject.addProperty("nbt", this.nbt.toString());
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public class_1865<?> method_17800() {
            return this.serializer;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

