/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class InventoryHandlerSlotTracker
implements ISlotTracker {
    private final Map<ItemStackKey, Set<Integer>> fullStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> fullSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Map<ItemStackKey, Set<Integer>> partiallyFilledStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> partiallyFilledSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Map<class_1792, Set<ItemStackKey>> itemStackKeys = new HashMap<class_1792, Set<ItemStackKey>>();
    private final Set<Integer> emptySlots = new TreeSet<Integer>();
    private final MemorySettingsCategory memorySettings;
    private final Map<class_1792, Set<Integer>> filterItemSlots;
    private Consumer<ItemStackKey> onAddStackKey = sk -> {};
    private Consumer<ItemStackKey> onRemoveStackKey = sk -> {};
    private Runnable onAddFirstEmptySlot = () -> {};
    private Runnable onRemoveLastEmptySlot = () -> {};
    private BooleanSupplier shouldInsertIntoEmpty = () -> true;

    public InventoryHandlerSlotTracker(MemorySettingsCategory memorySettings, Map<class_1792, Set<Integer>> filterItemSlots) {
        this.memorySettings = memorySettings;
        this.filterItemSlots = filterItemSlots;
    }

    @Override
    public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        this.shouldInsertIntoEmpty = shouldInsertIntoEmpty;
    }

    private void addPartiallyFilled(int slot, class_1799 stack) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        this.partiallyFilledStackSlots.computeIfAbsent(stackKey, k -> {
            if (!this.fullStackSlots.containsKey(k)) {
                this.onAddStackKey.accept((ItemStackKey)k);
            }
            return new TreeSet();
        }).add(slot);
        this.partiallyFilledSlotStacks.put(slot, stackKey);
        this.itemStackKeys.computeIfAbsent(stack.method_7909(), i -> new HashSet()).add(stackKey);
    }

    @Override
    public Set<ItemStackKey> getFullStacks() {
        return this.fullStackSlots.keySet();
    }

    @Override
    public Set<ItemStackKey> getPartialStacks() {
        return this.partiallyFilledStackSlots.keySet();
    }

    @Override
    public Set<class_1792> getItems() {
        return this.itemStackKeys.keySet();
    }

    private void addFull(int slot, class_1799 stack) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        this.fullStackSlots.computeIfAbsent(stackKey, k -> {
            if (!this.partiallyFilledStackSlots.containsKey(k)) {
                this.onAddStackKey.accept((ItemStackKey)k);
            }
            return new HashSet();
        }).add(slot);
        this.fullSlotStacks.put(slot, stackKey);
        this.itemStackKeys.computeIfAbsent(stack.method_7909(), i -> new HashSet()).add(stackKey);
    }

    private void removePartiallyFilled(int slot) {
        if (this.partiallyFilledSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.partiallyFilledSlotStacks.remove(slot);
            Set<Integer> partialSlots = this.partiallyFilledStackSlots.get(stackKey);
            if (partialSlots == null) {
                SophisticatedCore.LOGGER.error("Unstable ItemStack detected in slot tracking: {}", (Object)(stackKey != null ? stackKey.stack().toString() : "null"));
            } else {
                partialSlots.remove(slot);
            }
            if (partialSlots == null || partialSlots.isEmpty()) {
                this.partiallyFilledStackSlots.remove(stackKey);
                if (!this.fullStackSlots.containsKey(stackKey)) {
                    this.onStackKeyRemoved(stackKey);
                }
            }
        }
    }

    private void removeFull(int slot) {
        if (this.fullSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.fullSlotStacks.remove(slot);
            Set<Integer> fullSlots = this.fullStackSlots.get(stackKey);
            if (fullSlots == null) {
                SophisticatedCore.LOGGER.error("Unstable ItemStack detected in slot tracking: {}", (Object)(stackKey != null ? stackKey.stack().toString() : "null"));
            } else {
                fullSlots.remove(slot);
            }
            if (fullSlots == null || fullSlots.isEmpty()) {
                this.fullStackSlots.remove(stackKey);
                if (!this.partiallyFilledStackSlots.containsKey(stackKey)) {
                    this.onStackKeyRemoved(stackKey);
                }
            }
        }
    }

    private void onStackKeyRemoved(ItemStackKey stackKey) {
        this.itemStackKeys.computeIfPresent(stackKey.getStack().method_7909(), (i, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.itemStackKeys.containsKey(stackKey.getStack().method_7909()) && this.itemStackKeys.get(stackKey.getStack().method_7909()).isEmpty()) {
            this.itemStackKeys.remove(stackKey.getStack().method_7909());
        }
        this.onRemoveStackKey.accept(stackKey);
    }

    @Override
    public void removeAndSetSlotIndexes(InventoryHandler inventoryHandler, int slot, class_1799 stack) {
        if (stack.method_7960()) {
            this.removePartiallyFilled(slot);
            this.removeFull(slot);
            this.addEmptySlot(slot);
            return;
        }
        if (this.emptySlots.contains(slot)) {
            this.removeEmpty(slot);
        }
        if (this.isPartiallyFilled(inventoryHandler, slot, stack)) {
            this.setPartiallyFilled(slot, stack);
        } else {
            this.setFull(slot, stack);
        }
    }

    private void setFull(int slot, class_1799 stack) {
        boolean containsSlot = this.fullSlotStacks.containsKey(slot);
        if (!containsSlot || this.fullSlotStacks.get(slot).hashCodeNotEquals(stack)) {
            if (containsSlot) {
                this.removeFull(slot);
            }
            this.addFull(slot, stack);
        }
        if (this.partiallyFilledSlotStacks.containsKey(slot)) {
            this.removePartiallyFilled(slot);
        }
    }

    private void setPartiallyFilled(int slot, class_1799 stack) {
        boolean containsSlot = this.partiallyFilledSlotStacks.containsKey(slot);
        if (!containsSlot || this.partiallyFilledSlotStacks.get(slot).hashCodeNotEquals(stack)) {
            if (containsSlot) {
                this.removePartiallyFilled(slot);
            }
            this.addPartiallyFilled(slot, stack);
        }
        if (this.fullSlotStacks.containsKey(slot)) {
            this.removeFull(slot);
        }
    }

    private void removeEmpty(int slot) {
        this.emptySlots.remove(slot);
        if (this.emptySlots.isEmpty()) {
            this.onRemoveLastEmptySlot.run();
        }
    }

    private void set(InventoryHandler inventoryHandler, int slot, class_1799 stack) {
        if (stack.method_7960()) {
            this.addEmptySlot(slot);
        } else if (this.isPartiallyFilled(inventoryHandler, slot, stack)) {
            this.addPartiallyFilled(slot, stack);
        } else {
            this.addFull(slot, stack);
        }
    }

    private void addEmptySlot(int slot) {
        this.emptySlots.add(slot);
        if (this.emptySlots.size() == 1) {
            this.onAddFirstEmptySlot.run();
        }
    }

    @Override
    public void clear() {
        this.partiallyFilledStackSlots.clear();
        this.partiallyFilledSlotStacks.clear();
    }

    @Override
    public void refreshSlotIndexesFrom(InventoryHandler itemHandler) {
        this.fullStackSlots.keySet().forEach(sk -> this.onRemoveStackKey.accept((ItemStackKey)sk));
        this.fullStackSlots.clear();
        this.fullSlotStacks.clear();
        this.partiallyFilledStackSlots.keySet().forEach(sk -> this.onRemoveStackKey.accept((ItemStackKey)sk));
        this.partiallyFilledStackSlots.clear();
        this.partiallyFilledSlotStacks.clear();
        this.itemStackKeys.clear();
        this.emptySlots.clear();
        this.onRemoveLastEmptySlot.run();
        for (int slot = 0; slot < itemHandler.getSlotCount(); ++slot) {
            class_1799 stack = itemHandler.getStackInSlot(slot);
            this.set(itemHandler, slot, stack);
        }
    }

    private boolean isPartiallyFilled(InventoryHandler itemHandler, int slot, class_1799 stack) {
        return stack.method_7947() < itemHandler.getStackLimit(slot, ItemVariant.of((class_1799)stack));
    }

    @Override
    public long insertItemIntoHandler(InventoryHandler itemHandler, ISlotTracker.IItemHandlerInserter inserter, UnaryOperator<class_1799> overflowHandler, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        if (this.emptySlots.isEmpty() && !this.itemStackKeys.containsKey(resource.getItem())) {
            return maxAmount;
        }
        long remaining = maxAmount;
        ItemStackKey stackKey = ItemStackKey.of(resource.toStack());
        if ((remaining -= this.handleOverflow(overflowHandler, stackKey, resource, remaining)) <= 0L) {
            return 0L;
        }
        if ((remaining -= this.insertIntoSlotsThatMatchStack(inserter, resource, remaining, ctx, stackKey)) > 0L) {
            remaining -= this.insertIntoEmptySlots(inserter, resource, remaining, ctx);
        }
        if (remaining > 0L) {
            remaining -= this.handleOverflow(overflowHandler, stackKey, resource, remaining);
        }
        return remaining;
    }

    @Override
    public long insertItemIntoHandler(InventoryHandler itemHandler, ISlotTracker.IItemHandlerInserter inserter, UnaryOperator<class_1799> overflowHandler, int slot, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        return this.insertItemIntoHandler(itemHandler, inserter, overflowHandler, resource, maxAmount, ctx);
    }

    @Override
    public void registerListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.onAddStackKey = onAddStackKey;
        this.onRemoveStackKey = onRemoveStackKey;
        this.onAddFirstEmptySlot = onAddFirstEmptySlot;
        this.onRemoveLastEmptySlot = onRemoveLastEmptySlot;
    }

    @Override
    public void unregisterStackKeyListeners() {
        this.onAddStackKey = sk -> {};
        this.onRemoveStackKey = sk -> {};
    }

    @Override
    public boolean hasEmptySlots() {
        return this.shouldInsertIntoEmpty.getAsBoolean() && !this.emptySlots.isEmpty();
    }

    private long handleOverflow(UnaryOperator<class_1799> overflowHandler, ItemStackKey stackKey, ItemVariant resource, long maxAmount) {
        class_1799 remainingStack = resource.toStack((int)maxAmount);
        if (this.fullStackSlots.containsKey(stackKey) && !this.fullStackSlots.get(stackKey).isEmpty()) {
            remainingStack = (class_1799)overflowHandler.apply(remainingStack);
        }
        return (int)maxAmount - remainingStack.method_7947();
    }

    private long insertIntoSlotsThatMatchStack(ISlotTracker.IItemHandlerInserter inserter, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx, ItemStackKey stackKey) {
        int matchingSlot;
        long remaining = maxAmount;
        Set<Integer> slots = this.partiallyFilledStackSlots.get(stackKey);
        if (slots == null || slots.isEmpty()) {
            return 0L;
        }
        int sizeBefore = slots.size();
        int i = 0;
        while (this.partiallyFilledStackSlots.get(stackKey) != null && !this.partiallyFilledStackSlots.get(stackKey).isEmpty() && i++ < sizeBefore && (remaining -= inserter.insertItem(matchingSlot = this.partiallyFilledStackSlots.get(stackKey).iterator().next().intValue(), resource, remaining, ctx)) > 0L) {
        }
        return (long)((int)maxAmount) - remaining;
    }

    private long insertIntoEmptySlots(ISlotTracker.IItemHandlerInserter inserter, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        long remaining = maxAmount;
        remaining -= this.insertIntoEmptyMemorySlots(inserter, resource, remaining, ctx);
        remaining -= this.insertIntoEmptyFilterSlots(inserter, resource, remaining, ctx);
        if (this.shouldInsertIntoEmpty.getAsBoolean() && remaining > 0L) {
            int sizeBefore = this.emptySlots.size();
            int i = 0;
            while (!this.emptySlots.isEmpty() && i++ < sizeBefore) {
                Iterator<Integer> it = this.emptySlots.iterator();
                int slot = it.next();
                while (this.memorySettings.isSlotSelected(slot)) {
                    if (!it.hasNext()) {
                        return (long)((int)maxAmount) - remaining;
                    }
                    slot = it.next();
                }
                if ((remaining -= inserter.insertItem(slot, resource, remaining, ctx)) > 0L) continue;
                break;
            }
        }
        return (long)((int)maxAmount) - remaining;
    }

    private long insertIntoEmptyFilterSlots(ISlotTracker.IItemHandlerInserter inserter, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        long remaining;
        block1: {
            int filterSlot;
            class_1792 item = resource.getItem();
            remaining = maxAmount;
            if (!this.filterItemSlots.containsKey(item)) break block1;
            Iterator<Integer> iterator = this.filterItemSlots.get(item).iterator();
            while (iterator.hasNext() && (!this.emptySlots.contains(filterSlot = iterator.next().intValue()) || (remaining -= inserter.insertItem(filterSlot, resource, remaining, ctx)) > 0L)) {
            }
        }
        return (long)((int)maxAmount) - remaining;
    }

    private long insertIntoEmptyMemorySlots(ISlotTracker.IItemHandlerInserter inserter, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        long remaining;
        block3: {
            int memorySlot;
            int stackHash;
            Map<Integer, Set<Integer>> memoryFilterStackSlots;
            Map<class_1792, Set<Integer>> memoryFilterItemSlots = this.memorySettings.getFilterItemSlots();
            class_1792 item = resource.getItem();
            remaining = maxAmount;
            if (memoryFilterItemSlots.containsKey(item)) {
                int memorySlot2;
                Iterator<Integer> iterator = memoryFilterItemSlots.get(item).iterator();
                while (iterator.hasNext() && (!this.emptySlots.contains(memorySlot2 = iterator.next().intValue()) || (remaining -= inserter.insertItem(memorySlot2, resource, remaining, ctx)) > 0L)) {
                }
            }
            if ((memoryFilterStackSlots = this.memorySettings.getFilterStackSlots()).isEmpty() || !memoryFilterStackSlots.containsKey(stackHash = ItemStackKey.getHashCode(resource))) break block3;
            Iterator<Integer> iterator = memoryFilterStackSlots.get(stackHash).iterator();
            while (iterator.hasNext() && (!this.emptySlots.contains(memorySlot = iterator.next().intValue()) || (remaining -= inserter.insertItem(memorySlot, resource, remaining, ctx)) > 0L)) {
            }
        }
        return (long)((int)maxAmount) - remaining;
    }
}

