/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;

public class ItemDisplaySettingsContainer
extends SettingsContainerBase<ItemDisplaySettingsCategory> {
    private static final String COLOR_TAG = "color";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String ROTATE_CLOCKWISE_TAG = "rotateClockwise";
    private static final String ROTATE_COUNTER_CLOCKWISE_TAG = "rotateCounterClockwise";

    public ItemDisplaySettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, ItemDisplaySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(class_2487 data) {
        if (data.method_10545(SELECT_SLOT_TAG)) {
            this.selectSlot(data.method_10550(SELECT_SLOT_TAG));
        } else if (data.method_10545(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.method_10550(UNSELECT_SLOT_TAG));
        } else if (data.method_10545(ROTATE_CLOCKWISE_TAG)) {
            this.rotateClockwise(data.method_10550(ROTATE_CLOCKWISE_TAG));
        } else if (data.method_10545(ROTATE_COUNTER_CLOCKWISE_TAG)) {
            this.rotateCounterClockwise(data.method_10550(ROTATE_COUNTER_CLOCKWISE_TAG));
        } else if (data.method_10545(COLOR_TAG)) {
            this.setColor(class_1767.method_7791((int)data.method_10550(COLOR_TAG)));
        }
    }

    public void unselectSlot(int slotIndex) {
        if (!this.isSlotSelected(slotIndex)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot(slotIndex);
        } else {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot(slotIndex);
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotIndex);
        }
    }

    public void selectSlot(int slotIndex) {
        if (this.isSlotSelected(slotIndex)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotIndex);
        } else {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotIndex);
            this.sendIntToServer(SELECT_SLOT_TAG, slotIndex);
        }
    }

    public void rotateClockwise(int slotIndex) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(slotIndex, true);
        } else {
            this.sendIntToServer(ROTATE_CLOCKWISE_TAG, slotIndex);
        }
    }

    public void rotateCounterClockwise(int slotIndex) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(slotIndex, false);
        } else {
            this.sendIntToServer(ROTATE_COUNTER_CLOCKWISE_TAG, slotIndex);
        }
    }

    public void setColor(class_1767 color) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.method_7789());
        }
    }

    public boolean isSlotSelected(int slotIndex) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlots().contains(slotIndex);
    }

    public class_1767 getColor() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getColor();
    }

    public int getRotation(int slotIndex) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getRotation(slotIndex);
    }

    public int getFirstSelectedSlot() {
        List<Integer> slots = ((ItemDisplaySettingsCategory)this.getCategory()).getSlots();
        return slots.isEmpty() ? -1 : slots.get(0);
    }
}

