/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ContentsFilterLogic
extends FilterLogic {
    private final Supplier<InventoryHandler> getInventoryHandler;
    private final MemorySettingsCategory memorySettings;

    public ContentsFilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, Supplier<InventoryHandler> getInventoryHandler, MemorySettingsCategory memorySettings, String parentTagKey) {
        super(upgrade, saveHandler, filterSlotCount, parentTagKey);
        this.getInventoryHandler = getInventoryHandler;
        this.memorySettings = memorySettings;
    }

    public ContentsFilterLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, int filterSlotCount, Supplier<InventoryHandler> getInventoryHandler, MemorySettingsCategory memorySettings) {
        super(upgrade, saveHandler, filterSlotCount);
        this.getInventoryHandler = getInventoryHandler;
        this.memorySettings = memorySettings;
    }

    public ContentsFilterType getFilterType() {
        if (this.shouldFilterByStorage()) {
            return ContentsFilterType.STORAGE;
        }
        return this.isAllowList() ? ContentsFilterType.ALLOW : ContentsFilterType.BLOCK;
    }

    public void setDepositFilterType(ContentsFilterType contentsFilterType) {
        switch (contentsFilterType) {
            case ALLOW: {
                this.setFilterByStorage(false);
                this.setAllowList(true);
                break;
            }
            case BLOCK: {
                this.setFilterByStorage(false);
                this.setAllowList(false);
                break;
            }
            case STORAGE: {
                this.setFilterByStorage(true);
                this.save();
            }
        }
    }

    @Override
    public boolean matchesFilter(class_1799 stack) {
        if (!this.shouldFilterByStorage()) {
            return super.matchesFilter(stack);
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getFullStacks()) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getPartialStacks()) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        return this.memorySettings.matchesFilter(stack);
    }

    private void setFilterByStorage(boolean filterByStorage) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "filterByStorage", filterByStorage);
        this.save();
    }

    private boolean shouldFilterByStorage() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "filterByStorage").orElse(false);
    }
}

