/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2519;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.ItemStackHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogicBase {
    protected final class_1799 upgrade;
    protected final Consumer<class_1799> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;
    @Nullable
    protected Set<class_6862<class_1792>> tagKeys = null;

    public FilterLogicBase(class_1799 upgrade, Consumer<class_1799> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public String getParentTagKey() {
        return this.parentTagKey;
    }

    public void setAllowByDefault(boolean allowListDefault) {
        this.allowListDefault = allowListDefault;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(class_1799 stack, class_1799 filter) {
        if (filter.method_7960()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals(class_7923.field_41178.method_10221((Object)filter.method_7909()).method_12836()) : primaryMatch == PrimaryMatch.ITEM && !class_1799.method_7984((class_1799)stack, (class_1799)filter)) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.method_7919() != filter.method_7919()) {
            return false;
        }
        return !this.shouldMatchNbt() || ItemStackHelper.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    public Set<class_6862<class_1792>> getTagKeys() {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return Collections.unmodifiableSet(this.tagKeys);
    }

    public void addTag(class_6862<class_1792> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.add(tagName);
        this.serializeTags();
        this.save();
    }

    private void serializeTags() {
        if (this.tagKeys == null) {
            return;
        }
        NBTHelper.setList(this.upgrade, this.parentTagKey, "tags", this.tagKeys, t -> class_2519.method_23256((String)t.comp_327().toString()));
    }

    public void removeTagName(class_6862<class_1792> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.remove(tagName);
        this.serializeTags();
        this.save();
    }

    protected void initTags() {
        this.tagKeys = NBTHelper.getCollection(this.upgrade, this.parentTagKey, "tags", (byte)8, elementNbt -> Optional.of(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(elementNbt.method_10714()))), () -> new TreeSet<class_6862>(Comparator.comparing(class_6862::comp_327))).orElse(new TreeSet<class_6862>(Comparator.comparing(class_6862::comp_327)));
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }

    public boolean shouldMatchAnyTag() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchAnyTag").orElse(true);
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchAnyTag", matchAnyTag);
        this.save();
    }
}

