/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2520;
import net.minecraft.class_3956;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CookingLogic<T extends class_1874> {
    private final class_1799 upgrade;
    private final Consumer<class_1799> saveHandler;
    private ItemStackHandler cookingInventory = null;
    public static final int COOK_INPUT_SLOT = 0;
    public static final int COOK_OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 1;
    @Nullable
    private T cookingRecipe = null;
    private boolean cookingRecipeInitialized = false;
    private final float burnTimeModifier;
    private final Predicate<class_1799> isFuel;
    private final Predicate<class_1799> isInput;
    private final double cookingSpeedMultiplier;
    private final double fuelEfficiencyMultiplier;
    private final class_3956<T> recipeType;
    private boolean paused = false;
    private long remainingCookTime = 0L;
    private long remainingBurnTime = 0L;

    public CookingLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, CookingUpgradeConfig cookingUpgradeConfig, class_3956<T> recipeType, float burnTimeModifier) {
        this(upgrade, saveHandler, s -> CookingLogic.getBurnTime(s, burnTimeModifier) > 0, s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), cookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    public CookingLogic(class_1799 upgrade, Consumer<class_1799> saveHandler, Predicate<class_1799> isFuel, Predicate<class_1799> isInput, CookingUpgradeConfig cookingUpgradeConfig, class_3956<T> recipeType, float burnTimeModifier) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.isFuel = isFuel;
        this.isInput = isInput;
        this.cookingSpeedMultiplier = (Double)cookingUpgradeConfig.cookingSpeedMultiplier.get();
        this.fuelEfficiencyMultiplier = (Double)cookingUpgradeConfig.fuelEfficiencyMultiplier.get();
        this.recipeType = recipeType;
        this.burnTimeModifier = burnTimeModifier;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean tick(class_1937 world) {
        this.updateTimes(world);
        AtomicBoolean didSomething = new AtomicBoolean(true);
        if (this.isBurning(world) || this.readyToStartCooking()) {
            Optional<class_1874> fr = this.getCookingRecipe();
            if (fr.isEmpty() && this.isCooking()) {
                this.setIsCooking(false);
            }
            fr.ifPresent(recipe -> {
                this.updateFuel(world, recipe);
                if (this.isBurning(world) && this.canSmelt((class_1860<?>)recipe, world)) {
                    this.updateCookingProgress(world, recipe);
                } else if (!this.isBurning(world)) {
                    didSomething.set(false);
                }
            });
        }
        if (!this.isBurning(world) && this.isCooking()) {
            this.updateCookingCooldown(world);
        } else {
            didSomething.set(false);
        }
        return didSomething.get();
    }

    private void updateTimes(class_1937 world) {
        if (this.paused) {
            this.unpause(world);
            return;
        }
        this.remainingBurnTime = this.isBurning(world) ? this.getBurnTimeFinish() - world.method_8510() : 0L;
        this.remainingCookTime = this.isCooking() ? this.getCookTimeFinish() - world.method_8510() : 0L;
    }

    private void unpause(class_1937 world) {
        this.paused = false;
        if (this.remainingBurnTime > 0L) {
            this.setBurnTimeFinish(world.method_8510() + this.remainingBurnTime);
        }
        if (this.remainingCookTime > 0L) {
            this.setCookTimeFinish(world.method_8510() + this.remainingCookTime);
            this.setIsCooking(true);
        }
    }

    public boolean isBurning(class_1937 world) {
        return this.getBurnTimeFinish() >= world.method_8510();
    }

    private Optional<T> getCookingRecipe() {
        if (!this.cookingRecipeInitialized) {
            this.cookingRecipe = RecipeHelper.getCookingRecipe(this.getCookInput(), this.recipeType).orElse(null);
            this.cookingRecipeInitialized = true;
        }
        return Optional.ofNullable(this.cookingRecipe);
    }

    private void updateCookingCooldown(class_1937 world) {
        if (this.getRemainingCookTime(world) + 2 > this.getCookTimeTotal()) {
            this.setIsCooking(false);
        } else {
            this.setCookTimeFinish(world.method_8510() + (long)Math.min(this.getRemainingCookTime(world) + 2, this.getCookTimeTotal()));
        }
    }

    private void updateCookingProgress(class_1937 world, T cookingRecipe) {
        if (this.isCooking() && this.finishedCooking(world)) {
            this.smelt((class_1860<?>)cookingRecipe, world);
            if (this.canSmelt((class_1860<?>)cookingRecipe, world)) {
                this.setCookTime(world, (int)((double)cookingRecipe.method_8167() * (1.0 / this.cookingSpeedMultiplier)));
            } else {
                this.setIsCooking(false);
            }
        } else if (!this.isCooking()) {
            this.setIsCooking(true);
            this.setCookTime(world, (int)((double)cookingRecipe.method_8167() * (1.0 / this.cookingSpeedMultiplier)));
        }
    }

    private boolean finishedCooking(class_1937 world) {
        return this.getCookTimeFinish() <= world.method_8510();
    }

    private boolean readyToStartCooking() {
        return !this.getFuel().method_7960() && !this.getCookInput().method_7960();
    }

    private void smelt(class_1860<?> recipe, class_1937 level) {
        if (!this.canSmelt(recipe, level)) {
            return;
        }
        class_1799 input = this.getCookInput();
        class_1799 recipeOutput = recipe.method_8110(level.method_30349());
        class_1799 output = this.getCookOutput();
        if (output.method_7960()) {
            this.setCookOutput(recipeOutput.method_7972());
        } else if (output.method_7909() == recipeOutput.method_7909()) {
            output.method_7933(recipeOutput.method_7947());
            this.setCookOutput(output);
        }
        if (input.method_7909() == class_2246.field_10562.method_8389() && !this.getFuel().method_7960() && this.getFuel().method_7909() == class_1802.field_8550) {
            this.setFuel(new class_1799((class_1935)class_1802.field_8705));
        }
        input.method_7934(1);
        this.setCookInput(input);
    }

    public void setCookInput(class_1799 input) {
        this.cookingInventory.setStackInSlot(0, input);
    }

    private void setCookOutput(class_1799 stack) {
        this.getCookingInventory().setStackInSlot(2, stack);
    }

    private int getRemainingCookTime(class_1937 world) {
        return (int)(this.getCookTimeFinish() - world.method_8510());
    }

    private void setCookTime(class_1937 world, int cookTime) {
        this.setCookTimeFinish(world.method_8510() + (long)cookTime);
        this.setCookTimeTotal(cookTime);
    }

    public void pause() {
        this.paused = true;
        this.setCookTimeFinish(0L);
        this.setIsCooking(false);
        this.setBurnTimeFinish(0L);
    }

    private void updateFuel(class_1937 world, T cookingRecipe) {
        class_1799 fuel = this.getFuel();
        if (!this.isBurning(world) && this.canSmelt((class_1860<?>)cookingRecipe, world)) {
            if (CookingLogic.getBurnTime(fuel, this.burnTimeModifier) <= 0) {
                return;
            }
            this.setBurnTime(world, (int)((double)CookingLogic.getBurnTime(fuel, this.burnTimeModifier) * this.fuelEfficiencyMultiplier / this.cookingSpeedMultiplier));
            if (this.isBurning(world)) {
                class_1799 remainder = fuel.getRecipeRemainder();
                if (!remainder.method_7960()) {
                    this.setFuel(remainder);
                } else if (!fuel.method_7960()) {
                    fuel.method_7934(1);
                    this.setFuel(fuel);
                    if (fuel.method_7960()) {
                        this.setFuel(fuel.getRecipeRemainder());
                    }
                }
            }
        }
    }

    private void setBurnTime(class_1937 world, int burnTime) {
        this.setBurnTimeFinish(world.method_8510() + (long)burnTime);
        this.setBurnTimeTotal(burnTime);
    }

    protected boolean canSmelt(class_1860<?> cookingRecipe, class_1937 level) {
        if (this.getCookInput().method_7960()) {
            return false;
        }
        class_1799 recipeOutput = cookingRecipe.method_8110(level.method_30349());
        if (recipeOutput.method_7960()) {
            return false;
        }
        class_1799 output = this.getCookOutput();
        if (output.method_7960()) {
            return true;
        }
        if (!output.method_7962(recipeOutput)) {
            return false;
        }
        if (output.method_7947() + recipeOutput.method_7947() <= 64 && output.method_7947() + recipeOutput.method_7947() <= output.method_7914()) {
            return true;
        }
        return output.method_7947() + recipeOutput.method_7947() <= recipeOutput.method_7914();
    }

    private static int getBurnTime(class_1799 fuel, float burnTimeModifier) {
        return (int)((float)Objects.requireNonNullElse((Integer)FuelRegistry.INSTANCE.get((class_1935)fuel.method_7909()), 0).intValue() * burnTimeModifier);
    }

    public class_1799 getCookOutput() {
        return this.getCookingInventory().getStackInSlot(2);
    }

    public class_1799 getCookInput() {
        return this.getCookingInventory().getStackInSlot(0);
    }

    public class_1799 getFuel() {
        return this.getCookingInventory().getStackInSlot(1);
    }

    public void setFuel(class_1799 fuel) {
        this.getCookingInventory().setStackInSlot(1, fuel);
    }

    public ItemStackHandler getCookingInventory() {
        if (this.cookingInventory == null) {
            this.cookingInventory = new ItemStackHandler(3){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    CookingLogic.this.upgrade.method_7959("cookingInventory", (class_2520)this.serializeNBT());
                    CookingLogic.this.save();
                    if (slot == 0) {
                        CookingLogic.this.cookingRecipeInitialized = false;
                    }
                }

                public boolean isItemValid(int slot, ItemVariant resource) {
                    return switch (slot) {
                        case 0 -> CookingLogic.this.isInput.test(resource.toStack());
                        case 1 -> CookingLogic.this.isFuel.test(resource.toStack());
                        default -> true;
                    };
                }
            };
            NBTHelper.getCompound(this.upgrade, "smeltingInventory").ifPresentOrElse(arg_0 -> ((ItemStackHandler)this.cookingInventory).deserializeNBT(arg_0), () -> NBTHelper.getCompound(this.upgrade, "cookingInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.cookingInventory).deserializeNBT(arg_0)));
        }
        return this.cookingInventory;
    }

    public long getBurnTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "burnTimeFinish").orElse(0L);
    }

    private void setBurnTimeFinish(long burnTimeFinish) {
        NBTHelper.setLong(this.upgrade, "burnTimeFinish", burnTimeFinish);
        this.save();
    }

    public int getBurnTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "burnTimeTotal").orElse(0);
    }

    private void setBurnTimeTotal(int burnTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "burnTimeTotal", burnTimeTotal);
        this.save();
    }

    public long getCookTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "cookTimeFinish").orElse(-1L);
    }

    private void setCookTimeFinish(long cookTimeFinish) {
        NBTHelper.setLong(this.upgrade, "cookTimeFinish", cookTimeFinish);
        this.save();
    }

    public int getCookTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "cookTimeTotal").orElse(0);
    }

    private void setCookTimeTotal(int cookTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "cookTimeTotal", cookTimeTotal);
        this.save();
    }

    public boolean isCooking() {
        return NBTHelper.getBoolean(this.upgrade, "isCooking").orElse(false);
    }

    private void setIsCooking(boolean isCooking) {
        NBTHelper.setBoolean(this.upgrade, "isCooking", isCooking);
        this.save();
    }
}

