/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackMessage;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<class_5321<class_1937>, Long> lastWorldCheck = new HashMap<class_5321<class_1937>, Long>();
    private static final Map<class_5321<class_1937>, Map<UUID, KeepAliveInfo>> worldStorageSoundKeepAlive = new HashMap<class_5321<class_1937>, Map<UUID, KeepAliveInfo>>();

    private ServerStorageSoundHandler() {
    }

    public static void tick(class_3218 world) {
        if (world.method_8608()) {
            return;
        }
        class_5321 dim = world.method_27983();
        if (lastWorldCheck.computeIfAbsent((class_5321<class_1937>)dim, key -> world.method_8510()) > world.method_8510() - 10L || !worldStorageSoundKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((class_5321<class_1937>)dim, world.method_8510());
        worldStorageSoundKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < world.method_8510() - 10L) {
                ServerStorageSoundHandler.sendStopMessage(world, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID storageUuid, class_1937 world, class_243 position, Runnable onNoLongerRunning) {
        class_5321 dim = world.method_27983();
        if (!worldStorageSoundKeepAlive.containsKey(dim) || !worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).get(storageUuid).update(world.method_8510(), position);
        }
    }

    public static void onSoundStopped(class_3218 world, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(world, storageUuid);
    }

    public static void startPlayingDisc(class_3218 serverWorld, class_2338 position, UUID storageUuid, int discItemId, Runnable onStopHandler) {
        PacketHandler.sendToAllNear(serverWorld, position, 128, (Object)new PlayDiscMessage(storageUuid, discItemId, position));
        ServerStorageSoundHandler.putKeepAliveInfo(serverWorld, storageUuid, onStopHandler, class_243.method_24953((class_2382)position));
    }

    public static void startPlayingDisc(class_3218 serverWorld, class_243 position, UUID storageUuid, int entityId, int discItemId, Runnable onStopHandler) {
        PacketHandler.sendToAllNear(serverWorld, position, 128, (Object)new PlayDiscMessage(storageUuid, discItemId, entityId));
        ServerStorageSoundHandler.putKeepAliveInfo(serverWorld, storageUuid, onStopHandler, position);
    }

    private static void putKeepAliveInfo(class_3218 serverWorld, UUID storageUuid, Runnable onStopHandler, class_243 pos) {
        worldStorageSoundKeepAlive.computeIfAbsent((class_5321<class_1937>)serverWorld.method_27983(), dim -> new HashMap()).put(storageUuid, new KeepAliveInfo(onStopHandler, serverWorld.method_8510(), pos));
    }

    public static void stopPlayingDisc(class_3218 serverWorld, class_243 position, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(serverWorld, storageUuid);
        ServerStorageSoundHandler.sendStopMessage(serverWorld, position, storageUuid);
    }

    private static void removeKeepAliveInfo(class_3218 serverWorld, UUID storageUuid) {
        class_5321 dim = serverWorld.method_27983();
        if (worldStorageSoundKeepAlive.containsKey(dim) && worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).remove(storageUuid).runOnStop();
        }
    }

    private static void sendStopMessage(class_3218 serverWorld, class_243 position, UUID storageUuid) {
        PacketHandler.sendToAllNear(serverWorld, position, 128, (Object)new StopDiscPlaybackMessage(storageUuid));
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onStopHandler;
        private long lastKeepAliveTime;
        private class_243 lastPosition;

        private KeepAliveInfo(Runnable onStopHandler, long lastKeepAliveTime, class_243 lastPosition) {
            this.onStopHandler = new WeakReference<Runnable>(onStopHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public class_243 getLastPosition() {
            return this.lastPosition;
        }

        public void update(long gameTime, class_243 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnStop() {
            Runnable handler = (Runnable)this.onStopHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

