/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FluidFilterLogic {
    private final List<FluidStack> fluidFilters;
    private final class_1799 upgrade;
    private final Consumer<class_1799> saveHandler;
    private boolean noFilter = true;

    public FluidFilterLogic(int filterSlots, class_1799 upgrade, Consumer<class_1799> saveHandler) {
        this.fluidFilters = class_2371.method_10213((int)filterSlots, (Object)FluidStack.EMPTY);
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.deserializeFluidFilters();
        this.updateNoFilter();
    }

    private void deserializeFluidFilters() {
        NBTHelper.getTagValue(this.upgrade, "", "fluidFilters", (c, n1) -> c.method_10554(n1, 10)).ifPresent(listNbt -> {
            int i = 0;
            for (class_2520 elementNbt : listNbt) {
                FluidStack value = FluidStack.loadFluidStackFromNBT((class_2487)((class_2487)elementNbt));
                if (value != null) {
                    this.fluidFilters.set(i, value);
                }
                if (++i < this.fluidFilters.size()) continue;
                break;
            }
        });
    }

    private void updateNoFilter() {
        this.noFilter = true;
        for (FluidStack fluidFilter : this.fluidFilters) {
            if (fluidFilter.isEmpty()) continue;
            this.noFilter = false;
            return;
        }
    }

    public boolean fluidMatches(FluidStack fluid) {
        return this.noFilter || this.matchesFluidFilter(fluid);
    }

    private boolean matchesFluidFilter(FluidStack fluid) {
        for (FluidStack fluidFilter : this.fluidFilters) {
            if (!fluidFilter.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public void setFluid(int index, FluidStack fluid) {
        this.fluidFilters.set(index, fluid.copy());
        this.serializeFluidFilters();
        this.updateNoFilter();
        this.save();
    }

    public FluidStack getFluid(int index) {
        return this.fluidFilters.get(index);
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilters.size();
    }

    private void serializeFluidFilters() {
        class_2499 fluids = new class_2499();
        this.fluidFilters.forEach(f -> fluids.add((Object)f.writeToNBT(new class_2487())));
        this.upgrade.method_7948().method_10566("fluidFilters", (class_2520)fluids);
    }
}

