/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.block.BucketPickupHandlerWrapper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.FluidHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;
    private final PumpUpgradeConfig pumpUpgradeConfig = ((PumpUpgradeItem)this.upgradeItem).getPumpUpgradeConfig();

    protected PumpUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)this.pumpUpgradeConfig.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.setCooldown(world, this.storageWrapper.getFluidHandler().map(storageFluidHandler -> this.tick((Storage<FluidVariant>)storageFluidHandler, entity, world, pos)).orElse(40));
    }

    private int tick(Storage<FluidVariant> storageFluidHandler, @Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        if (entity == null) {
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        } else {
            class_1657 player;
            if (this.shouldInteractWithHand() && entity instanceof class_1657 && this.handleFluidContainerInHands(player = (class_1657)entity, storageFluidHandler)) {
                this.lastHandActionTime = level.method_8510();
                return 3;
            }
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        }
        return this.lastHandActionTime + 30L > level.method_8510() ? 3 : 40;
    }

    private Optional<Integer> handleInWorldInteractions(Storage<FluidVariant> storageFluidHandler, class_1937 world, class_2338 pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithHand() && this.handleFluidContainersInHandsOfNearbyPlayers(world, pos, storageFluidHandler)) {
            this.lastHandActionTime = world.method_8510();
            return Optional.of(3);
        }
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(world, pos, storageFluidHandler)).isPresent()) {
            return newCooldown;
        }
        return this.interactWithAttachedFluidHandlers(world, pos, storageFluidHandler);
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(class_1937 world, class_2338 pos, Storage<FluidVariant> storageFluidHandler) {
        for (class_2350 dir : class_2350.values()) {
            boolean successful = false;
            Storage storage = (Storage)FluidStorage.SIDED.find(world, pos.method_10081(dir.method_10163()), (Object)dir.method_10153());
            if (storage != null) {
                successful = this.isInput() ? this.fillFromFluidHandler((Storage<FluidVariant>)storage, storageFluidHandler, this.getMaxInOut()) : this.fillFluidHandler((Storage<FluidVariant>)storage, storageFluidHandler, this.getMaxInOut());
            }
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private long getMaxInOut() {
        return Math.max(81000L, (long)((Integer)this.pumpUpgradeConfig.maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows() * this.getAdjustedStackMultiplier(this.storageWrapper)) * 81L);
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.pumpUpgradeConfig.stackMultiplierRatio.get() * (double)(storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    private Optional<Integer> interactWithWorld(class_1937 world, class_2338 pos, Storage<FluidVariant> storageFluidHandler) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(world, pos, storageFluidHandler);
        }
        for (class_2350 dir : class_2350.values()) {
            class_2338 offsetPos = pos.method_10081(dir.method_10163());
            if (!this.placeFluidInWorld(world, storageFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(class_1937 world, Storage<FluidVariant> storageFluidHandler, class_2350 dir, class_2338 offsetPos) {
        if (dir != class_2350.field_11036) {
            for (StorageView view : storageFluidHandler.nonEmptyViews()) {
                FluidStack tankFluid = new FluidStack(view);
                if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || !this.isValidForFluidPlacement(world, offsetPos) || !FluidHelper.placeFluid(null, world, offsetPos, storageFluidHandler, (FluidVariant)view.getResource(), view.getAmount(), null)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(class_1937 world, class_2338 offsetPos) {
        class_2680 blockState = world.method_8320(offsetPos);
        return blockState.method_26215() || !blockState.method_26227().method_15769() && !blockState.method_26227().method_15771();
    }

    private Optional<Integer> fillFromBlockInRange(class_1937 world, class_2338 basePos, Storage<FluidVariant> storageFluidHandler) {
        LinkedList<class_2338> nextPositions = new LinkedList<class_2338>();
        HashSet<class_2338> searchedPositions = new HashSet<class_2338>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            class_2338 pos = (class_2338)nextPositions.poll();
            if (this.fillFromBlock(world, pos, storageFluidHandler)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.method_10262((class_2382)pos))) * 20.0));
            }
            for (class_2350 dir : class_2350.values()) {
                class_2338 offsetPos = pos.method_10081(dir.method_10163());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.method_10262((class_2382)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(class_1937 world, class_2338 pos, Storage<FluidVariant> storageFluidHandler) {
        class_3610 fluidState = world.method_8316(pos);
        if (!fluidState.method_15769()) {
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (!(block instanceof class_2263)) {
                return false;
            }
            class_2263 bucketPickup = (class_2263)block;
            BucketPickupHandlerWrapper targetFluidHandler = new BucketPickupHandlerWrapper(bucketPickup, world, pos);
            return this.fillFromFluidHandler((Storage<FluidVariant>)targetFluidHandler, storageFluidHandler);
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(class_1937 world, class_2338 pos, Storage<FluidVariant> storageFluidHandler) {
        class_238 searchBox = new class_238(pos).method_1014(3.0);
        for (class_1657 player : world.method_18456()) {
            if (!searchBox.method_1008(player.method_23317(), player.method_23318(), player.method_23321()) || !this.handleFluidContainerInHands(player, storageFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(class_1657 player, Storage<FluidVariant> storageFluidHandler) {
        return this.handleFluidContainerInHand(storageFluidHandler, player, class_1268.field_5808) || this.handleFluidContainerInHand(storageFluidHandler, player, class_1268.field_5810);
    }

    private boolean handleFluidContainerInHand(Storage<FluidVariant> storageFluidHandler, class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_7947() != 1 || itemInHand == this.storageWrapper.getWrappedStorageStack()) {
            return false;
        }
        return FluidHelper.interactWithFluidStorage(storageFluidHandler, player, hand, !this.isInput());
    }

    private boolean fillFluidHandler(Storage<FluidVariant> fluidHandler, Storage<FluidVariant> storageFluidHandler, long maxFill) {
        boolean ret = false;
        for (StorageView view : storageFluidHandler.nonEmptyViews()) {
            FluidStack tankFluid = new FluidStack(view);
            if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid)) continue;
            if (StorageUtil.move(storageFluidHandler, fluidHandler, arg_0 -> ((FluidVariant)((FluidVariant)view.getResource())).equals(arg_0), (long)maxFill, null) != 0L) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean fillFromFluidHandler(Storage<FluidVariant> fluidHandler, Storage<FluidVariant> storageFluidHandler) {
        return this.fillFromFluidHandler(fluidHandler, storageFluidHandler, 81000L);
    }

    private boolean fillFromFluidHandler(Storage<FluidVariant> fluidHandler, Storage<FluidVariant> storageFluidHandler, long maxDrain) {
        FluidStack containedFluid = TransferUtil.simulateExtractAnyFluid(fluidHandler, (long)maxDrain);
        if (!containedFluid.isEmpty() && this.fluidFilterLogic.fluidMatches(containedFluid)) {
            return StorageUtil.move(fluidHandler, storageFluidHandler, fluidVariant -> fluidVariant.isOf((Object)containedFluid.getFluid()), (long)containedFluid.getAmount(), null) > 0L;
        }
        return false;
    }

    public void setIsInput(boolean input) {
        NBTHelper.setBoolean(this.upgrade, "input", input);
        this.save();
    }

    public boolean isInput() {
        return NBTHelper.getBoolean(this.upgrade, "input").orElse(true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        NBTHelper.setBoolean(this.upgrade, "interactWithHand", interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithHand").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        NBTHelper.setBoolean(this.upgrade, "interactWithWorld", interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithWorld").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }
}

