/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3611;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private final XpPumpUpgradeConfig xpPumpUpgradeConfig;

    protected XpPumpUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.xpPumpUpgradeConfig = ((XpPumpUpgradeItem)this.upgradeItem).getXpPumpUpgradeConfig();
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 world, class_2338 pos) {
        if (entity != null && !(entity instanceof class_1657) || this.isInCooldown(world)) {
            return;
        }
        if (entity == null) {
            class_238 searchBox = new class_238(pos).method_1014(3.0);
            for (class_1657 player : world.method_18456()) {
                if (!searchBox.method_1008(player.method_23317(), player.method_23318(), player.method_23321())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        } else {
            class_1657 player = (class_1657)entity;
            this.interactWithPlayer(player);
            this.mendItems(player);
        }
        this.setCooldown(world, 5);
    }

    private void mendItems(class_1657 player) {
        float xpToTryDrain;
        class_1799 itemStack;
        if (Boolean.FALSE.equals(this.xpPumpUpgradeConfig.mendingOn.get()) || !this.shouldMendItems()) {
            return;
        }
        Map.Entry entry = class_1890.method_24365((class_1887)class_1893.field_9101, (class_1309)player, class_1799::method_7986);
        if (entry != null && !(itemStack = (class_1799)entry.getValue()).method_7960() && itemStack.method_7986() && XpHelper.getXpRepairRatio(itemStack) > 0.0f && (xpToTryDrain = Math.min((float)((Integer)this.xpPumpUpgradeConfig.maxXpPointsPerMending.get()).intValue(), (float)itemStack.method_7919() / XpHelper.getXpRepairRatio(itemStack))) > 0.0f) {
            this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                try (Transaction outer = Transaction.openOuter();){
                    FluidStack drained = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), (TransactionContext)outer, false);
                    outer.commit();
                    float xpDrained = XpHelper.liquidToExperience((int)drained.getAmount());
                    int durationToRepair = (int)(xpDrained * XpHelper.getXpRepairRatio(itemStack));
                    itemStack.method_7974(itemStack.method_7919() - durationToRepair);
                }
            });
        }
    }

    private void interactWithPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if (direction == AutomationDirection.INPUT) {
                if (level < player.field_7520 || level == player.field_7520 && player.field_7510 > 0.0f) {
                    this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, level, false);
                }
            } else if (direction == AutomationDirection.OUTPUT && level > player.field_7520) {
                this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        try (Transaction outer = Transaction.openOuter();){
            int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
            FluidStack drained = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), (TransactionContext)outer, ignoreInOutLimit);
            outer.commit();
            if (!drained.isEmpty()) {
                player.method_7255((int)XpHelper.liquidToExperience((int)drained.getAmount()));
            }
        }
    }

    private void tryFillTankWithPlayerExperience(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(class_1657 player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        try (Transaction outer = Transaction.openOuter();){
            int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
            long filled = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (class_3611)ModFluids.XP_STILL, (TransactionContext)outer, ignoreInOutLimit);
            outer.commit();
            if (filled > 0L) {
                player.method_7255((int)(-XpHelper.liquidToExperience(filled)));
            }
        }
    }

    public void takeLevelsFromPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, Math.max(player.field_7520 - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, player.field_7520 + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(class_1657 player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return NBTHelper.getEnumConstant(this.upgrade, "direction", AutomationDirection::fromName).orElse(AutomationDirection.INPUT);
    }

    public void setDirection(AutomationDirection direction) {
        NBTHelper.setEnumConstant(this.upgrade, "direction", direction);
        this.save();
    }

    public void setLevel(int level) {
        NBTHelper.setInteger(this.upgrade, "level", level);
        this.save();
    }

    public int getLevel() {
        return NBTHelper.getInt(this.upgrade, "level").orElse(10);
    }

    public void setLevelsToStore(int levelsToTake) {
        NBTHelper.setInteger(this.upgrade, "levelsToStore", levelsToTake);
        this.save();
    }

    public int getLevelsToStore() {
        return NBTHelper.getInt(this.upgrade, "levelsToStore").orElse(1);
    }

    public void setLevelsToTake(int levelsToGive) {
        NBTHelper.setInteger(this.upgrade, "levelsToTake", levelsToGive);
        this.save();
    }

    public int getLevelsToTake() {
        return NBTHelper.getInt(this.upgrade, "levelsToTake").orElse(1);
    }

    public boolean shouldMendItems() {
        return NBTHelper.getBoolean(this.upgrade, "mendItems").orElse(true);
    }

    public void setMendItems(boolean mendItems) {
        NBTHelper.setBoolean(this.upgrade, "mendItems", mendItems);
        this.save();
    }
}

