/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.init;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedcore.compat.audioplayer.AudioPlayerCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.craftingtweaks.CraftingTweaksCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.JeiCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.litematica.LitematicaCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.rei.REICompat;
import net.p3pp3rf1y.sophisticatedcore.compat.trinkets.TrinketsCompat;

public class ModCompat {
    private static final Map<String, Supplier<Callable<ICompat>>> compatFactories = new HashMap<String, Supplier<Callable<ICompat>>>();

    private ModCompat() {
    }

    public static void initCompats() {
        for (Map.Entry<String, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!FabricLoader.getInstance().isModLoaded(entry.getKey())) continue;
            try {
                entry.getValue().get().call().setup();
            }
            catch (Exception e) {
                SophisticatedCore.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
            }
        }
    }

    static {
        compatFactories.put("jei", () -> JeiCompat::new);
        compatFactories.put("craftingtweaks", () -> CraftingTweaksCompat::new);
        compatFactories.put("emi", () -> EmiCompat::new);
        compatFactories.put("roughlyenoughitems", () -> REICompat::new);
        compatFactories.put("litematica", () -> LitematicaCompat::new);
        compatFactories.put("audioplayer", () -> AudioPlayerCompat::new);
        compatFactories.put("trinkets", () -> TrinketsCompat::new);
    }
}

