/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedcore.util.TriPredicate;

public interface IInventoryPartHandler {
    public static final IInventoryPartHandler EMPTY = () -> "EMPTY";

    default public int getSlotLimit(int slot) {
        return 0;
    }

    default public boolean isSlotAccessible(int slot) {
        return false;
    }

    default public int getStackLimit(int slot, ItemVariant resource) {
        return 0;
    }

    default public long extractItem(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    default public long insertItem(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction, Function4<Integer, ItemVariant, Long, TransactionContext, Long> insertSuper) {
        return maxAmount;
    }

    default public void setStackInSlot(int slot, class_1799 stack, BiConsumer<Integer, class_1799> setStackInSlotSuper) {
    }

    @Deprecated
    default public boolean isItemValid(int slot, ItemVariant resource, @Nullable class_1657 player, TriPredicate<Integer, ItemVariant, Integer> isItemValidSuper) {
        return this.isItemValid(slot, resource, 1, player, isItemValidSuper);
    }

    default public boolean isItemValid(int slot, ItemVariant resource, int count, @Nullable class_1657 player, TriPredicate<Integer, ItemVariant, Integer> isItemValidSuper) {
        return false;
    }

    default public ItemVariant getVariantInSlot(int slot, IntFunction<ItemVariant> getVariantInSlotSuper) {
        return ItemVariant.blank();
    }

    default public class_1799 getStackInSlot(int slot, IntFunction<class_1799> getStackInSlotSuper) {
        return class_1799.field_8037;
    }

    default public boolean canBeReplaced() {
        return false;
    }

    default public int getSlots() {
        return 0;
    }

    public String getName();

    @Nullable
    default public Pair<class_2960, class_2960> getNoItemIcon(int slot) {
        return null;
    }

    default public class_1792 getFilterItem(int slot) {
        return class_1802.field_8162;
    }

    default public void onSlotLimitChange() {
    }

    default public Set<Integer> getNoSortSlots() {
        return Set.of();
    }

    default public void onSlotFilterChanged(int slot) {
    }

    default public boolean isFilterItem(class_1792 item) {
        return false;
    }

    default public Map<class_1792, Set<Integer>> getFilterItems() {
        return Map.of();
    }

    default public void onInit() {
    }

    default public boolean isInfinite(int slot) {
        return false;
    }

    public static interface Factory {
        public IInventoryPartHandler create(InventoryHandler var1, SlotRange var2, Supplier<MemorySettingsCategory> var3);
    }

    public static class Default
    implements IInventoryPartHandler {
        public static final String NAME = "default";
        private final InventoryHandler parent;
        private final int slots;

        public Default(InventoryHandler parent, int slots) {
            this.parent = parent;
            this.slots = slots;
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.parent.getBaseSlotLimit();
        }

        @Override
        public int getStackLimit(int slot, ItemVariant resource) {
            return this.parent.getBaseStackLimit(resource);
        }

        @Override
        public long extractItem(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
            return this.parent.extractItemInternal(slot, resource, maxAmount, ctx);
        }

        @Override
        public long insertItem(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx, Function4<Integer, ItemVariant, Long, TransactionContext, Long> insertSuper) {
            return (Long)insertSuper.apply((Object)slot, (Object)resource, (Object)maxAmount, (Object)ctx);
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack, BiConsumer<Integer, class_1799> setStackInSlotSuper) {
            setStackInSlotSuper.accept(slot, stack);
        }

        @Override
        public boolean isItemValid(int slot, ItemVariant stack, int count, @Nullable class_1657 player, TriPredicate<Integer, ItemVariant, Integer> isItemValidSuper) {
            return true;
        }

        @Override
        public ItemVariant getVariantInSlot(int slot, IntFunction<ItemVariant> getVariantInSlotSuper) {
            return getVariantInSlotSuper.apply(slot);
        }

        @Override
        public class_1799 getStackInSlot(int slot, IntFunction<class_1799> getStackInSlotSuper) {
            return getStackInSlotSuper.apply(slot);
        }

        @Override
        public boolean canBeReplaced() {
            return true;
        }

        @Override
        public boolean isSlotAccessible(int slot) {
            return true;
        }

        @Override
        public int getSlots() {
            return this.slots;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

