/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;

public class BatteryUpgradeItem
extends UpgradeItemBase<BatteryUpgradeWrapper> {
    public static final UpgradeType<BatteryUpgradeWrapper> TYPE = new UpgradeType<BatteryUpgradeWrapper>(BatteryUpgradeWrapper::new);
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(BatteryUpgradeItem.class::isInstance, 0, TranslationHelper.INSTANCE.translError("add.battery_exists", new Object[0])));
    private final BatteryUpgradeConfig batteryUpgradeConfig;

    public BatteryUpgradeItem(BatteryUpgradeConfig batteryUpgradeConfig, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
        this.batteryUpgradeConfig = batteryUpgradeConfig;
    }

    public BatteryUpgradeConfig getBatteryUpgradeConfig() {
        return this.batteryUpgradeConfig;
    }

    @Override
    public UpgradeType<BatteryUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    @Override
    public UpgradeSlotChangeResult checkExtraInsertConditions(class_1799 upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide, @Nullable IUpgradeItem<?> upgradeInSlot) {
        double d;
        double d2 = this.getMaxEnergyStored(storageWrapper);
        if (upgradeInSlot instanceof StackUpgradeItem) {
            StackUpgradeItem stackUpgrade = (StackUpgradeItem)upgradeInSlot;
            d = stackUpgrade.getStackSizeMultiplier();
        } else {
            d = 1.0;
        }
        int maxEnergyAfter = (int)(d2 / d);
        double multiplierRequired = (double)BatteryUpgradeWrapper.getEnergyStored(upgradeStack) / (double)maxEnergyAfter;
        if (multiplierRequired > 1.0) {
            DecimalFormat multiplierFormat = new DecimalFormat("0.#");
            String formattedMultiplierRequired = multiplierFormat.format(Math.ceil(10.0 * multiplierRequired) / 10.0);
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.battery_energy_high", formattedMultiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    public int getMaxEnergyStored(IStorageWrapper storageWrapper) {
        int maxEnergyBase;
        double stackMultiplier = this.getAdjustedStackMultiplier(storageWrapper);
        return 2.147483647E9 / stackMultiplier < (double)(maxEnergyBase = this.getMaxEnergyBase(storageWrapper)) ? Integer.MAX_VALUE : (int)((double)maxEnergyBase * stackMultiplier);
    }

    public double getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1.0 + (Double)this.batteryUpgradeConfig.stackMultiplierRatio.get() * (storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1.0);
    }

    public int getMaxEnergyBase(IStorageWrapper storageWrapper) {
        return (Integer)this.batteryUpgradeConfig.energyPerSlotRow.get() * storageWrapper.getNumberOfSlotRows();
    }
}

