/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;

public class FluidFilterContainer {
    private final class_1657 player;
    private final IServerUpdater serverUpdater;
    private final Supplier<FluidFilterLogic> fluidFilterLogic;
    private static final String DATA_FLUID = "setFluid";

    public FluidFilterContainer(class_1657 player, IServerUpdater serverUpdater, Supplier<FluidFilterLogic> fluidFilterLogic) {
        this.player = player;
        this.serverUpdater = serverUpdater;
        this.fluidFilterLogic = fluidFilterLogic;
    }

    public FluidStack getFluid(int index) {
        return this.fluidFilterLogic.get().getFluid(index);
    }

    private void setFluid(int index, FluidStack fluid) {
        this.fluidFilterLogic.get().setFluid(index, fluid);
        this.serverUpdater.sendDataToServer(() -> this.serializeSetFluidData(index, fluid));
    }

    private class_2487 serializeSetFluidData(int index, FluidStack fluid) {
        class_2487 ret = new class_2487();
        class_2487 fluidNbt = new class_2487();
        fluidNbt.method_10569("index", index);
        fluidNbt.method_10566("fluid", (class_2520)fluid.writeToNBT(new class_2487()));
        ret.method_10566(DATA_FLUID, (class_2520)fluidNbt);
        return ret;
    }

    public boolean handleMessage(class_2487 data) {
        if (data.method_10545(DATA_FLUID)) {
            class_2487 fluidData = data.method_10562(DATA_FLUID);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((class_2487)fluidData.method_10562("fluid"));
            this.setFluid(fluidData.method_10550("index"), fluid);
            return true;
        }
        return false;
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilterLogic.get().getNumberOfFluidFilters();
    }

    public void slotClick(int index) {
        FluidStack containedFluid;
        class_1799 carried = this.player.field_7512.method_34255();
        if (carried.method_7960()) {
            this.setFluid(index, FluidStack.EMPTY);
            return;
        }
        Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)carried).find(FluidStorage.ITEM);
        if (storage != null && !(containedFluid = TransferUtil.simulateExtractAnyFluid((Storage)storage, (long)81000L)).isEmpty()) {
            this.setFluid(index, containedFluid);
        }
    }
}

