/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.api.harvester;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createdragonsplus.util.CodeReference;
import plus.dragons.createintegratedfarming.integration.ModIntegration;

@FunctionalInterface
public interface CustomHarvestBehaviour {
    public static final SimpleRegistry<Block, CustomHarvestBehaviour> REGISTRY = SimpleRegistry.create();
    @ApiStatus.Internal
    public static final LoadingCache<Dynamic<Tag>, ItemEnchantments> ENCHANTMENTS_DECODER_CACHE = CacheBuilder.newBuilder().maximumSize(64L).concurrencyLevel(1).build((CacheLoader)new CacheLoader<Dynamic<Tag>, ItemEnchantments>(){

        public ItemEnchantments load(Dynamic<Tag> key) {
            return DataComponents.ENCHANTMENTS.codecOrThrow().parse(key).resultOrPartial().orElse(ItemEnchantments.EMPTY);
        }
    });

    public void harvest(HarvesterMovementBehaviour var1, MovementContext var2, BlockPos var3, BlockState var4);

    public static boolean replant() {
        return (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
    }

    public static boolean partial() {
        return (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
    }

    public static ItemStack getHarvestTool(MovementContext context) {
        return CustomHarvestBehaviour.getHarvestTool(context, ItemStack.EMPTY);
    }

    public static ItemStack getHarvestTool(MovementContext context, ItemStack original) {
        if (ModIntegration.CREATE_ENCHANTABLE_MACHINERY.enabled()) {
            Tag tag;
            if (original.isEmpty()) {
                original = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            }
            if ((tag = context.blockEntityData.get("Enchantments")) == null) {
                return original;
            }
            RegistryOps registryOps = context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ItemEnchantments enchantments = (ItemEnchantments)ENCHANTMENTS_DECODER_CACHE.getUnchecked((Object)new Dynamic((DynamicOps)registryOps, (Object)tag));
            original.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
            return original;
        }
        return original;
    }

    @CodeReference(value={BlockHelper.class}, targets={"destroyBlockAs"}, source={"create"}, license={"mit"})
    public static void harvestBlock(Level level, BlockPos pos, BlockState newState, @Nullable Player player, ItemStack usedTool, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockEntity blockEntity;
        BlockState state = level.getBlockState(pos);
        if (level.random.nextFloat() < effectChance) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            usedTool.mineBlock(level, state, pos, player);
            player.awardStat(Stats.BLOCK_MINED.get((Object)state.getBlock()));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!(!level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) || level.restoringBlockSnapshots || player != null && player.isCreative())) {
                List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)usedTool);
                if (player != null) {
                    BlockDropsEvent event = new BlockDropsEvent(serverLevel, pos, state, blockEntity, List.of(), (Entity)player, usedTool);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled() && event.getDroppedExperience() > 0) {
                        state.getBlock().popExperience(serverLevel, pos, event.getDroppedExperience());
                    }
                }
                for (ItemStack itemStack : drops) {
                    droppedItemCallback.accept(itemStack);
                }
                state.spawnAfterBreak((ServerLevel)level, pos, ItemStack.EMPTY, true);
            }
        }
        level.setBlockAndUpdate(pos, newState);
    }
}

