/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.fishing.net;

import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import plus.dragons.createintegratedfarming.common.fishing.net.AbstractFishingNetContext;
import plus.dragons.createintegratedfarming.common.fishing.net.FishingNetContext;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public abstract class AbstractFishingNetMovementBehaviour<T extends AbstractFishingNetContext<?>>
implements MovementBehaviour {
    protected abstract T getFishingNetContext(MovementContext var1, ServerLevel var2);

    protected boolean canCaptureEntity(LivingEntity entity) {
        if (entity instanceof Enemy) {
            return false;
        }
        if (entity instanceof WaterAnimal) {
            EntityDimensions dimensions = entity.getDimensions(Pose.SWIMMING);
            float maxSize = CIFConfig.server().fishingNetCapturedCreatureMaxSize.getF();
            return dimensions.height() < maxSize && dimensions.width() < maxSize;
        }
        return false;
    }

    protected void onCaptureEntity(MovementContext context, ServerLevel level, T fishing, LivingEntity entity) {
        if (!entity.isBaby() && level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(entity.getLootTable());
            LootParams lootParams = ((AbstractFishingNetContext)fishing).buildCaptureLootContext(context, level, entity);
            lootTable.getRandomItems(lootParams, entity.getLootTableSeed(), item -> this.dropItem(context, (ItemStack)item));
            if (((Boolean)CIFConfig.server().fishingNetCapturedCreatureDropExpNugget.get()).booleanValue()) {
                int experience = EventHooks.getExperienceDrop((LivingEntity)entity, (Player)((AbstractFishingNetContext)fishing).player, (int)entity.getExperienceReward(level, (Entity)entity));
                this.dropItem(context, new ItemStack((ItemLike)AllItems.EXP_NUGGET.get(), Math.ceilDiv(experience, 3)));
            }
        }
        entity.discard();
    }

    public void tick(MovementContext context) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            T fishing = this.getFishingNetContext(context, level2);
            if (((AbstractFishingNetContext)fishing).timeUntilCatch > 0) {
                --((AbstractFishingNetContext)fishing).timeUntilCatch;
            }
            if (level2.getGameTime() % 20L == 0L && ((Boolean)CIFConfig.server().fishingNetCaptureCreatureInWater.get()).booleanValue()) {
                AABB area = context.state.getShape((BlockGetter)level2, context.localPos).bounds().expandTowards(context.motion.scale(5.0)).move(context.position).inflate(0.2);
                level2.getEntities(EntityTypeTest.forClass(LivingEntity.class), area, this::canCaptureEntity).forEach(entity -> this.onCaptureEntity(context, level2, fishing, (LivingEntity)entity));
            }
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            T fishing = this.getFishingNetContext(context, level2);
            boolean isValid = ((AbstractFishingNetContext)fishing).visitNewPositon(level2, pos);
            if (!isValid || ((AbstractFishingNetContext)fishing).timeUntilCatch > 0) {
                return;
            }
            if (((AbstractFishingNetContext)fishing).canCatch()) {
                LootParams params = ((AbstractFishingNetContext)fishing).buildFishingLootContext(context, level2, pos);
                LootTable lootTable = ((AbstractFishingNetContext)fishing).getLootTable(level2, pos);
                ObjectArrayList loots = lootTable.getRandomItems(params);
                ItemFishedEvent event = (ItemFishedEvent)NeoForge.EVENT_BUS.post((Event)new ItemFishedEvent((List)loots, 0, ((AbstractFishingNetContext)fishing).getFishingHook()));
                if (!event.isCanceled()) {
                    loots.forEach(stack -> this.dropItem(context, (ItemStack)stack));
                }
            }
            ((AbstractFishingNetContext)fishing).reset(level2);
        }
    }

    public void stopMoving(MovementContext context) {
        Object object = context.temporaryData;
        if (object instanceof FishingNetContext) {
            FishingNetContext fishing = (FishingNetContext)object;
            object = context.world;
            if (object instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                fishing.invalidate(level);
            }
        }
    }
}

