/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.fishing.net;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import plus.dragons.createintegratedfarming.common.fishing.net.AbstractFishingNetContext;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public class FishingNetContext
extends AbstractFishingNetContext<FishingHook> {
    public FishingNetContext(ServerLevel level, ItemStack fishingRod) {
        super(level, fishingRod);
    }

    @Override
    protected FishingHook createFishingHook(ServerLevel level) {
        return new FishingHook(EntityType.FISHING_BOBBER, (Level)level);
    }

    @Override
    protected boolean isPosValidForFishing(ServerLevel level, BlockPos pos) {
        return this.fishingHook.getOpenWaterTypeForBlock(pos) == FishingHook.OpenWaterType.INSIDE_WATER;
    }

    @Override
    public LootTable getLootTable(ServerLevel level, BlockPos pos) {
        return level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
    }

    @Override
    public LootParams buildFishingLootContext(MovementContext context, ServerLevel level, BlockPos pos) {
        this.fishingHook.openWater = (Boolean)CIFConfig.server().fishingNetChecksOpenWater.get() != false ? this.fishingHook.getOpenWaterTypeForArea(pos.offset(-2, 0, -2), pos.offset(2, 0, 2)) == FishingHook.OpenWaterType.INSIDE_WATER : false;
        return super.buildFishingLootContext(context, level, pos);
    }
}

