/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.fishing.net;

import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.entity.entities.LavaFishingBobberEntity;
import com.scouter.netherdepthsupgrade.loot.NDULootTables;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import plus.dragons.createintegratedfarming.common.fishing.net.AbstractFishingNetContext;
import plus.dragons.createintegratedfarming.mixin.integration.LavaFishingBobberEntityInvoker;

public class LavaFishingNetContext
extends AbstractFishingNetContext<LavaFishingBobberEntity> {
    public LavaFishingNetContext(ServerLevel level, ItemStack fishingRod) {
        super(level, fishingRod);
    }

    @Override
    protected LavaFishingBobberEntity createFishingHook(ServerLevel level) {
        return new LavaFishingBobberEntity((EntityType)NDUEntity.LAVA_BOBBER.get(), (Level)level);
    }

    @Override
    protected boolean isPosValidForFishing(ServerLevel level, BlockPos pos) {
        return level.getFluidState(pos).is(FluidTags.LAVA) && level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    @Override
    public LootTable getLootTable(ServerLevel level, BlockPos pos) {
        ReloadableServerRegistries.Holder registries = level.getServer().reloadableRegistries();
        if (level.dimension() == Level.NETHER) {
            return level.getServer().reloadableRegistries().getLootTable(NDULootTables.NETHER_FISHING);
        }
        return level.getServer().reloadableRegistries().getLootTable(NDULootTables.LAVA_FISHING);
    }

    @Override
    public LootParams buildFishingLootContext(MovementContext context, ServerLevel level, BlockPos pos) {
        ((LavaFishingBobberEntity)this.fishingHook).openWater = ((LavaFishingBobberEntityInvoker)this.fishingHook).invokeCalculateOpenLava(pos);
        return super.buildFishingLootContext(context, level, pos);
    }
}

