/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostCapturable;

public class RoostBlockItem
extends BlockItem {
    public RoostBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        RoostCapturable capturable = (RoostCapturable)RoostCapturable.REGISTRY.get((Object)target.getType());
        return capturable == null ? InteractionResult.PASS : capturable.captureItem(target.level(), stack, hand, player, (Entity)target);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity be = world.getBlockEntity(pos);
        Player player = context.getPlayer();
        if (!(be instanceof SpawnerBlockEntity)) {
            return super.useOn(context);
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)be).getSpawner();
        List<SpawnData> possibleSpawns = spawner.spawnPotentials.unwrap().stream().map(WeightedEntry.Wrapper::data).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.nextSpawnData);
        }
        for (SpawnData e : possibleSpawns) {
            RoostCapturable capturable;
            Optional optionalEntity = EntityType.by((CompoundTag)e.entityToSpawn());
            if (optionalEntity.isEmpty() || (capturable = (RoostCapturable)RoostCapturable.REGISTRY.get((Object)((EntityType)optionalEntity.get()))) == null) continue;
            return capturable.captureItem(world, player.getItemInHand(context.getHand()), context.getHand(), player, ((EntityType)optionalEntity.get()).create(world));
        }
        return super.useOn(context);
    }
}

