/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import plus.dragons.createintegratedfarming.common.registry.CIFBlockSpoutingBehaviours;
import plus.dragons.createintegratedfarming.common.registry.CIFHarvestBehaviours;
import plus.dragons.createintegratedfarming.integration.netherdepthsupgrade.NethersDepthsUpgradeIntegration;

public enum ModIntegration {
    FARMERSDELIGHT("farmersdelight"){

        @Override
        public void onCommonSetup() {
            CIFHarvestBehaviours.registerFarmersDelight();
            CIFBlockSpoutingBehaviours.registerFarmersDelight();
        }
    }
    ,
    MYNETHERSDELIGHT("mynethersdelight"){

        @Override
        public void onCommonSetup() {
            CIFBlockSpoutingBehaviours.registerMyNethersDelight();
        }
    }
    ,
    MMLIB("mysterious_mountain_lib"){

        @Override
        public void onCommonSetup() {
            CIFHarvestBehaviours.registerMmlib();
        }
    }
    ,
    CREATE_ENCHANTABLE_MACHINERY("createenchantablemachinery"),
    CREATE_CRAFT_AND_ADDITIONS("createadditions"),
    NETHER_DEPTHS_UPGRADE("netherdepthsupgrade"){

        @Override
        public void onConstructMod() {
            NethersDepthsUpgradeIntegration.register();
        }
    };

    private final String id;

    private ModIntegration(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public boolean enabled() {
        return ModList.get().isLoaded(this.id);
    }

    public ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)path);
    }

    public ModLoadedCondition condition() {
        return new ModLoadedCondition(this.id);
    }

    public void onConstructMod() {
    }

    public void onCommonSetup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup() {
    }

    public static class Constants {
        public static final String FARMERS_DELIGHT = "farmersdelight";
        public static final String MY_NETHERS_DELIGHT = "mynethersdelight";
        public static final String MMLIB = "mysterious_mountain_lib";
        public static final String CREATE_ENCHANTABLE_MACHINERY = "createenchantablemachinery";
        public static final String CREATE_CRAFT_AND_ADDITIONS = "createadditions";
        public static final String NETHER_DEPTHS_UPGRADE = "netherdepthsupgrade";
    }
}

