/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostCapturable;

public class RoostBlockItem
extends BlockItem {
    public RoostBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        RoostCapturable capturable = (RoostCapturable)RoostCapturable.REGISTRY.get((Object)target.getType());
        return capturable == null ? InteractionResult.PASS : capturable.captureItem(target.level(), stack, hand, player, (Entity)target);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos = context.getClickedPos());
        if (!(blockEntity instanceof SpawnerBlockEntity)) {
            return super.useOn(context);
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)blockEntity).getSpawner();
        List<SpawnData> possibleSpawns = spawner.spawnPotentials.unwrap().stream().map(WeightedEntry.Wrapper::data).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.nextSpawnData);
        }
        for (SpawnData spawnData : possibleSpawns) {
            Entity entity;
            RoostCapturable capturable;
            Optional optional = EntityType.by((CompoundTag)spawnData.entityToSpawn());
            if (optional.isEmpty() || (capturable = (RoostCapturable)RoostCapturable.REGISTRY.get((Object)((EntityType)optional.get()))) == null || (entity = ((EntityType)optional.get()).create(level)) == null) continue;
            return capturable.captureItem(level, context.getItemInHand(), context.getHand(), player, entity);
        }
        return super.useOn(context);
    }
}

