/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost.chicken;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createintegratedfarming.common.ranching.roost.AnimalRoostBlockEntity;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFood;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFoodFluid;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFoodItem;
import plus.dragons.createintegratedfarming.common.registry.CIFDataMaps;
import plus.dragons.createintegratedfarming.common.registry.CIFLootTables;

public class ChickenRoostBlockEntity
extends AnimalRoostBlockEntity {
    @Override
    protected ResourceKey<LootTable> productionLootTable() {
        return CIFLootTables.CHICKEN_ROOST;
    }

    public ChickenRoostBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean feedItem(ItemStack stack, boolean simulate) {
        assert (this.level != null);
        if (this.feedCooldown > 0 || this.eggTime <= 0) {
            return false;
        }
        ChickenFoodItem food = (ChickenFoodItem)stack.getItemHolder().getData(CIFDataMaps.CHICKEN_FOOD_ITEMS);
        if (food == null) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.feed(food);
        Direction facing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        Vec3 feedPos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add((double)((float)facing.getStepX() * 0.5f), 0.8125, (double)((float)facing.getStepZ() * 0.5f));
        food.usingConvertsTo().ifPresent(remainer -> Containers.dropItemStack((Level)this.level, (double)feedPos.x, (double)feedPos.y, (double)feedPos.z, (ItemStack)remainer));
        this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), feedPos.x, feedPos.y, feedPos.z, 0.0, 0.0, 0.0);
        return true;
    }

    public int feedFluid(FluidStack fluid, boolean simulate) {
        if (this.feedCooldown > 0 || this.eggTime <= 0) {
            return 0;
        }
        ChickenFoodFluid food = (ChickenFoodFluid)fluid.getFluidHolder().getData(CIFDataMaps.CHICKEN_FOOD_FLUIDS);
        if (food == null) {
            return 0;
        }
        if (simulate) {
            return food.amount();
        }
        this.feed(food);
        return food.amount();
    }

    public void feed(ChickenFood food) {
        assert (this.level != null);
        this.eggTime = Math.max(0, this.eggTime - food.getProgress(this.level.random));
        this.feedCooldown = food.getCooldown(this.level.random);
        this.level.playSound(null, this.worldPosition, SoundEvents.CHICKEN_AMBIENT, SoundSource.BLOCKS, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
        this.notifyUpdate();
    }
}

