/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.untitledduck.ranching.roost.duck;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModSoundEvents;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostBlock;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostCapturable;
import plus.dragons.createintegratedfarming.integration.untitledduck.ranching.roost.duck.DuckRoostBlockEntity;
import plus.dragons.createintegratedfarming.integration.untitledduck.registry.UntitledDuckBlockEntities;
import plus.dragons.createintegratedfarming.integration.untitledduck.registry.UntitledDuckBlocks;

public class DuckRoostBlock
extends RoostBlock
implements IBE<DuckRoostBlockEntity> {
    protected final Holder<Block> empty;
    protected final byte variant;

    public DuckRoostBlock(BlockBehaviour.Properties properties, Holder<Block> empty, byte variant) {
        super(properties);
        this.empty = empty;
        this.variant = variant;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.onBlockEntityUse((BlockGetter)level, pos, coop -> {
            ItemStack stack = coop.outputHandler.extractItem(0, 64, false);
            if (!stack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(stack);
                level.playSound(player, pos, (SoundEvent)ModSoundEvents.DUCK_LAY_EGG.get(), SoundSource.BLOCKS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.0f);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        });
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.LEAD)) {
            DuckEntity duck = this.duckVariant(level);
            duck.setPos(pos.getCenter());
            duck.setLeashedTo((Entity)player, true);
            level.addFreshEntity((Entity)duck);
            level.setBlockAndUpdate(pos, ((Block)this.empty.value()).withPropertiesOf(state));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, coop -> {
            if (coop != null && coop.feedItem(stack, false)) {
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        });
    }

    private DuckEntity duckVariant(Level level) {
        DuckEntity duck = new DuckEntity((EntityType)ModEntityTypes.DUCK.get(), level);
        if (this.variant > 2) {
            duck.setCustomName((Component)Component.literal((String)"pekin"));
        } else {
            duck.setVariant(this.variant);
        }
        return duck;
    }

    private static Block blockVariant(DuckEntity duck) {
        if (duck.getCustomName() != null && duck.getCustomName().getString().equals("pekin")) {
            return (Block)UntitledDuckBlocks.DUCK_ROOST_PEKIN.get();
        }
        return switch (duck.getVariant()) {
            case 1 -> (DuckRoostBlock)((Object)UntitledDuckBlocks.DUCK_ROOST_FEMALE.get());
            case 2 -> (DuckRoostBlock)((Object)UntitledDuckBlocks.DUCK_ROOST_CAMPBELL.get());
            default -> (DuckRoostBlock)((Object)UntitledDuckBlocks.DUCK_ROOST_NORMAL.get());
        };
    }

    public static BlockState withVariantPropertiesOf(BlockState state, DuckEntity duck) {
        BlockState blockstate = DuckRoostBlock.blockVariant(duck).defaultBlockState();
        for (Property property : state.getBlock().getStateDefinition().getProperties()) {
            if (!blockstate.hasProperty(property)) continue;
            blockstate = DuckRoostBlock.copyProperty(state, blockstate, property);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.setValue(property, sourceState.getValue(property));
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        super.updateEntityAfterFallOn(level, entity);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!entity.isAlive()) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)entity.blockPosition(), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.getItem(), Direction.UP, false);
        itemEntity.setItem(remainder);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return ItemHelper.calcRedstoneFromBlockEntity((IBE)this, (Level)level, (BlockPos)pos);
    }

    protected MapCodec<? extends DuckRoostBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)DuckRoostBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("empty").forGetter(block -> block.empty), (App)Codec.BYTE.fieldOf("variant").forGetter(block -> block.variant)).apply((Applicative)instance, DuckRoostBlock::new));
    }

    public Class<DuckRoostBlockEntity> getBlockEntityClass() {
        return DuckRoostBlockEntity.class;
    }

    public BlockEntityType<? extends DuckRoostBlockEntity> getBlockEntityType() {
        return (BlockEntityType)UntitledDuckBlockEntities.DUCK_ROOST.get();
    }

    public static class Capturable
    implements RoostCapturable {
        @Override
        public ItemInteractionResult captureBlock(Level level, BlockState state, BlockPos pos, ItemStack stack, Player player, Entity entity) {
            DuckEntity duck;
            if (entity instanceof DuckEntity && !(duck = (DuckEntity)entity).isBaby()) {
                level.setBlockAndUpdate(pos, DuckRoostBlock.withVariantPropertiesOf(state, duck));
                duck.playSound((SoundEvent)ModSoundEvents.DUCK_HURT.get());
                duck.discard();
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        @Override
        public InteractionResult captureItem(Level level, ItemStack stack, InteractionHand hand, Player player, Entity entity) {
            DuckEntity duck;
            if (entity instanceof DuckEntity && !(duck = (DuckEntity)entity).isBaby()) {
                if (player.hasInfiniteMaterials()) {
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)DuckRoostBlock.blockVariant(duck).asItem()));
                } else if (stack.getCount() == 1) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)DuckRoostBlock.blockVariant(duck).asItem()));
                } else {
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)DuckRoostBlock.blockVariant(duck).asItem()));
                    stack.shrink(1);
                }
                duck.playSound((SoundEvent)ModSoundEvents.DUCK_HURT.get());
                duck.discard();
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
    }
}

