/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost.chicken;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHandlerWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFood;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFoodFluid;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenFoodItem;
import plus.dragons.createintegratedfarming.common.registry.CIFDataMaps;
import plus.dragons.createintegratedfarming.common.registry.CIFLootTables;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public class ChickenRoostBlockEntity
extends SmartBlockEntity {
    protected final ItemStackHandler inventory;
    protected final IItemHandler outputHandler;
    protected int feedCooldown;
    protected int eggTime = 12000;

    public ChickenRoostBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.inventory = new ItemStackHandler(this, (Integer)CIFConfig.server().roostingInventorySlotCount.get()){

            public int getSlotLimit(int slot) {
                return (Integer)CIFConfig.server().roostingInventorySlotSize.get();
            }
        };
        this.outputHandler = new ItemHandlerWrapper(this, (IItemHandlerModifiable)this.inventory){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)) {
            return null;
        }
        return this.outputHandler;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(side -> side == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).considerOccupiedWhen(side -> this.feedCooldown > 0).setInsertionHandler(this::tryInsertFrom));
    }

    public void initialize() {
        assert (this.level != null);
        super.initialize();
        if (this.eggTime >= 12000) {
            this.eggTime = 6000 + this.level.random.nextInt(6000);
        }
    }

    public void lazyTick() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean changed = false;
        if (this.feedCooldown > 0) {
            this.feedCooldown = Math.max(0, this.feedCooldown - this.lazyTickRate);
            changed = true;
        }
        if (this.eggTime > 0) {
            this.eggTime = Math.max(0, this.eggTime - this.lazyTickRate);
            changed = true;
        }
        if (this.eggTime <= 0) {
            boolean inserted = false;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(CIFLootTables.CHICKEN_ROOST);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)this.worldPosition.getCenter()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this).create(LootContextParamSets.BLOCK);
            ObjectArrayList lootStacks = lootTable.getRandomItems(lootParams);
            for (ItemStack stack : lootStacks) {
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                inserted |= stack.getCount() != remainder.getCount();
            }
            if (inserted) {
                this.eggTime = 6000 + this.level.random.nextInt(6000);
                this.level.playSound(null, this.worldPosition, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
                changed = true;
            }
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("EggLayTime", this.eggTime);
        tag.putInt("FeedCooldown", this.feedCooldown);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        this.eggTime = Math.clamp((long)tag.getInt("EggLayTime"), 0, 12000);
        this.feedCooldown = tag.getInt("FeedCooldown");
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    protected ItemStack tryInsertFrom(TransportedItemStack transported, Direction side, boolean simulate) {
        assert (this.level != null);
        ItemStack stack = transported.stack.copy();
        if (this.feedItem(stack, simulate) && !simulate) {
            stack.shrink(1);
        }
        return stack;
    }

    public boolean feedItem(ItemStack stack, boolean simulate) {
        assert (this.level != null);
        if (this.feedCooldown > 0 || this.eggTime <= 0) {
            return false;
        }
        ChickenFoodItem food = (ChickenFoodItem)stack.getItemHolder().getData(CIFDataMaps.CHICKEN_FOOD_ITEMS);
        if (food == null) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.feed(food);
        Direction facing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        Vec3 feedPos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add((double)((float)facing.getStepX() * 0.5f), 0.8125, (double)((float)facing.getStepZ() * 0.5f));
        food.usingConvertsTo().ifPresent(remainer -> Containers.dropItemStack((Level)this.level, (double)feedPos.x, (double)feedPos.y, (double)feedPos.z, (ItemStack)remainer));
        this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), feedPos.x, feedPos.y, feedPos.z, 0.0, 0.0, 0.0);
        return true;
    }

    public int feedFluid(FluidStack fluid, boolean simulate) {
        if (this.feedCooldown > 0 || this.eggTime <= 0) {
            return 0;
        }
        ChickenFoodFluid food = (ChickenFoodFluid)fluid.getFluidHolder().getData(CIFDataMaps.CHICKEN_FOOD_FLUIDS);
        if (food == null) {
            return 0;
        }
        if (simulate) {
            return food.amount();
        }
        this.feed(food);
        return food.amount();
    }

    public void feed(ChickenFood food) {
        assert (this.level != null);
        this.eggTime = Math.max(0, this.eggTime - food.getProgress(this.level.random));
        this.feedCooldown = food.getCooldown(this.level.random);
        this.level.playSound(null, this.worldPosition, SoundEvents.CHICKEN_AMBIENT, SoundSource.BLOCKS, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
        this.notifyUpdate();
    }
}

