/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.farmersdelight;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import plus.dragons.createintegratedfarming.integration.ModIntegration;
import plus.dragons.createintegratedfarming.integration.farmersdelight.data.FDRecipeProvider;
import plus.dragons.createintegratedfarming.integration.farmersdelight.ponder.FDPonderPlugin;
import plus.dragons.createintegratedfarming.integration.farmersdelight.registry.FDArmInteractionPointTypes;
import plus.dragons.createintegratedfarming.integration.farmersdelight.registry.FDBlockEntities;
import plus.dragons.createintegratedfarming.integration.farmersdelight.registry.FDBlockSpoutingBehaviours;
import plus.dragons.createintegratedfarming.integration.farmersdelight.registry.FDHarvestBehaviors;

@Mod(value="create_integrated_farming")
public class FDIntegration {
    public FDIntegration(IEventBus modBus) {
        if (ModIntegration.MY_NETHERS_DELIGHT.enabled()) {
            modBus.register((Object)new Common());
            modBus.register(FDBlockEntities.class);
            if (FMLLoader.getDist() == Dist.CLIENT) {
                modBus.register((Object)new Client());
            }
        }
    }

    public static class Common {
        @SubscribeEvent
        public void construct(FMLConstructModEvent event) {
            FDArmInteractionPointTypes.register();
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            FDHarvestBehaviors.register();
            FDBlockSpoutingBehaviours.register();
        }

        @SubscribeEvent
        public void generate(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            CompletableFuture lookupProvider = event.getLookupProvider();
            PackOutput output = generator.getPackOutput();
            boolean server = event.includeServer();
            generator.addProvider(server, (DataProvider)new FDRecipeProvider(output, lookupProvider));
        }
    }

    public static class Client {
        @SubscribeEvent
        public void construct(FMLConstructModEvent event) {
            FDPonderPlugin.register();
        }
    }
}

